"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

function _default() {
  return function ({
    config,
    matchUtilities,
    theme,
    variants
  }) {
    matchUtilities({
      'backdrop-brightness': value => {
        return {
          '--tw-backdrop-brightness': `brightness(${value})`,
          ...(config('mode') === 'jit' ? {
            'backdrop-filter': 'var(--tw-backdrop-filter)'
          } : {})
        };
      }
    }, {
      values: theme('backdropBrightness'),
      variants: variants('backdropBrightness'),
      type: 'any'
    });
  };
}