function getRoot(ele) {
  var _ele$getRootNode;
  return ele === null || ele === void 0 ? void 0 : (_ele$getRootNode = ele.getRootNode) === null || _ele$getRootNode === void 0 ? void 0 : _ele$getRootNode.call(ele);
}

/**
 * Check if is in shadowRoot
 */
export function inShadow(ele) {
  return getRoot(ele) !== (ele === null || ele === void 0 ? void 0 : ele.ownerDocument);
}

/**
 * Return shadowRoot if possible
 */
export function getShadowRoot(ele) {
  return inShadow(ele) ? getRoot(ele) : null;
}