"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.visitor = void 0;
var tslib_1 = require("tslib");
var t = tslib_1.__importStar(require("@babel/types"));
var icu_messageformat_parser_1 = require("@formatjs/icu-messageformat-parser");
var utils_1 = require("../utils");
var visitor = function (path, _a) {
    var opts = _a.opts, filename = _a.file.opts.filename;
    var _b = opts, removeDefaultMessage = _b.removeDefaultMessage, idInterpolationPattern = _b.idInterpolationPattern, overrideIdFn = _b.overrideIdFn, ast = _b.ast, preserveWhitespace = _b.preserveWhitespace;
    var _c = this, componentNames = _c.componentNames, messages = _c.messages;
    if (utils_1.wasExtracted(path)) {
        return;
    }
    var name = path.get('name');
    if (!componentNames.find(function (n) { return name.isJSXIdentifier({ name: n }); })) {
        return;
    }
    var attributes = path
        .get('attributes')
        .filter(function (attr) { return attr.isJSXAttribute(); });
    var descriptorPath = utils_1.createMessageDescriptor(attributes.map(function (attr) { return [
        attr.get('name'),
        attr.get('value'),
    ]; }));
    // In order for a default message to be extracted when
    // declaring a JSX element, it must be done with standard
    // `key=value` attributes. But it's completely valid to
    // write `<FormattedMessage {...descriptor} />`, because it will be
    // skipped here and extracted elsewhere. The descriptor will
    // be extracted only (storeMessage) if a `defaultMessage` prop.
    if (!descriptorPath.defaultMessage) {
        return;
    }
    // Evaluate the Message Descriptor values in a JSX
    // context, then store it.
    var descriptor = utils_1.evaluateMessageDescriptor(descriptorPath, true, filename || undefined, idInterpolationPattern, overrideIdFn, preserveWhitespace);
    utils_1.storeMessage(descriptor, path, opts, filename || undefined, messages);
    var idAttr;
    var descriptionAttr;
    var defaultMessageAttr;
    var firstAttr = attributes[0];
    for (var _i = 0, attributes_1 = attributes; _i < attributes_1.length; _i++) {
        var attr = attributes_1[_i];
        if (!attr.isJSXAttribute()) {
            continue;
        }
        switch (utils_1.getMessageDescriptorKey(attr.get('name'))) {
            case 'description':
                descriptionAttr = attr;
                break;
            case 'defaultMessage':
                defaultMessageAttr = attr;
                break;
            case 'id':
                idAttr = attr;
                break;
        }
    }
    // Insert ID before removing node to prevent null node insertBefore
    if (overrideIdFn || (descriptor.id && idInterpolationPattern)) {
        if (idAttr) {
            idAttr.get('value').replaceWith(t.stringLiteral(descriptor.id));
        }
        else if (firstAttr) {
            firstAttr.insertBefore(t.jsxAttribute(t.jsxIdentifier('id'), t.stringLiteral(descriptor.id)));
        }
    }
    if (descriptionAttr) {
        descriptionAttr.remove();
    }
    if (defaultMessageAttr) {
        if (removeDefaultMessage) {
            defaultMessageAttr.remove();
        }
        else if (ast && descriptor.defaultMessage) {
            defaultMessageAttr
                .get('value')
                .replaceWith(t.jsxExpressionContainer(t.nullLiteral()));
            var valueAttr = defaultMessageAttr.get('value');
            valueAttr
                .get('expression')
                .replaceWithSourceString(JSON.stringify(icu_messageformat_parser_1.parse(descriptor.defaultMessage)));
        }
    }
    // Tag the AST node so we don't try to extract it twice.
    utils_1.tagAsExtracted(path);
};
exports.visitor = visitor;
