"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.visitor = void 0;
var tslib_1 = require("tslib");
var t = tslib_1.__importStar(require("@babel/types"));
var utils_1 = require("../utils");
var icu_messageformat_parser_1 = require("@formatjs/icu-messageformat-parser");
function assertObjectExpression(path, callee) {
    if (!path || !path.isObjectExpression()) {
        throw path.buildCodeFrameError("[React Intl] `" + callee.get('property').node.name + "()` must be called with an object expression with values that are React Intl Message Descriptors, also defined as object expressions.");
    }
}
function isFormatMessageCall(callee, functionNames) {
    if (functionNames.find(function (name) { return callee.isIdentifier({ name: name }); })) {
        return true;
    }
    if (callee.isMemberExpression()) {
        var property_1 = callee.get('property');
        return !!functionNames.find(function (name) { return property_1.isIdentifier({ name: name }); });
    }
    return false;
}
function getMessagesObjectFromExpression(nodePath) {
    var currentPath = nodePath;
    while (t.isTSAsExpression(currentPath.node) ||
        t.isTSTypeAssertion(currentPath.node) ||
        t.isTypeCastExpression(currentPath.node)) {
        currentPath = currentPath.get('expression');
    }
    return currentPath;
}
var visitor = function (path, _a) {
    var opts = _a.opts, filename = _a.file.opts.filename;
    var _b = opts, overrideIdFn = _b.overrideIdFn, idInterpolationPattern = _b.idInterpolationPattern, removeDefaultMessage = _b.removeDefaultMessage, ast = _b.ast, preserveWhitespace = _b.preserveWhitespace;
    if (utils_1.wasExtracted(path)) {
        return;
    }
    var _c = this, messages = _c.messages, functionNames = _c.functionNames;
    var callee = path.get('callee');
    var args = path.get('arguments');
    /**
     * Process MessageDescriptor
     * @param messageDescriptor Message Descriptor
     */
    function processMessageObject(messageDescriptor) {
        var _a;
        assertObjectExpression(messageDescriptor, callee);
        var properties = messageDescriptor.get('properties');
        var descriptorPath = utils_1.createMessageDescriptor(properties.map(function (prop) {
            return [prop.get('key'), prop.get('value')];
        }));
        // Evaluate the Message Descriptor values, then store it.
        var descriptor = utils_1.evaluateMessageDescriptor(descriptorPath, false, filename || undefined, idInterpolationPattern, overrideIdFn, preserveWhitespace);
        utils_1.storeMessage(descriptor, messageDescriptor, opts, filename || undefined, messages);
        var firstProp = properties[0];
        var defaultMessageProp = properties.find(function (prop) {
            var keyProp = prop.get('key');
            return (keyProp.isIdentifier({ name: 'defaultMessage' }) ||
                keyProp.isStringLiteral({ value: 'defaultMessage' }));
        });
        var idProp = properties.find(function (prop) {
            var keyProp = prop.get('key');
            return (keyProp.isIdentifier({ name: 'id' }) ||
                keyProp.isStringLiteral({ value: 'id' }));
        });
        // Insert ID potentially 1st before removing nodes
        if (idProp) {
            idProp.get('value').replaceWith(t.stringLiteral(descriptor.id));
        }
        else {
            firstProp.insertBefore(t.objectProperty(t.identifier('id'), t.stringLiteral(descriptor.id)));
        }
        // Remove description
        (_a = properties
            .find(function (prop) {
            var keyProp = prop.get('key');
            return (keyProp.isIdentifier({ name: 'description' }) ||
                keyProp.isStringLiteral({ value: 'description' }));
        })) === null || _a === void 0 ? void 0 : _a.remove();
        // Pre-parse or remove defaultMessage
        if (defaultMessageProp) {
            if (removeDefaultMessage) {
                defaultMessageProp === null || defaultMessageProp === void 0 ? void 0 : defaultMessageProp.remove();
            }
            else if (descriptor.defaultMessage) {
                var valueProp = defaultMessageProp.get('value');
                if (ast) {
                    valueProp.replaceWithSourceString(JSON.stringify(icu_messageformat_parser_1.parse(descriptor.defaultMessage)));
                }
                else {
                    valueProp.replaceWith(t.stringLiteral(descriptor.defaultMessage));
                }
            }
        }
        utils_1.tagAsExtracted(path);
    }
    // Check that this is `defineMessages` call
    if (callee.isIdentifier({ name: 'defineMessages' }) ||
        callee.isIdentifier({ name: 'defineMessage' })) {
        var firstArgument = args[0];
        var messagesObj = getMessagesObjectFromExpression(firstArgument);
        assertObjectExpression(messagesObj, callee);
        if (callee.isIdentifier({ name: 'defineMessage' })) {
            processMessageObject(messagesObj);
        }
        else {
            var properties = messagesObj.get('properties');
            if (Array.isArray(properties)) {
                properties
                    .map(function (prop) { return prop.get('value'); })
                    .forEach(processMessageObject);
            }
        }
    }
    // Check that this is `intl.formatMessage` call
    if (isFormatMessageCall(callee, functionNames)) {
        var messageDescriptor = args[0];
        if (messageDescriptor.isObjectExpression()) {
            processMessageObject(messageDescriptor);
        }
    }
};
exports.visitor = visitor;
