"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = usePickerInput;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _KeyCode = _interopRequireDefault(require("rc-util/lib/KeyCode"));
var _raf = _interopRequireDefault(require("rc-util/lib/raf"));
var _react = require("react");
var _uiUtil = require("../utils/uiUtil");
function usePickerInput(_ref) {
  var open = _ref.open,
    value = _ref.value,
    isClickOutside = _ref.isClickOutside,
    triggerOpen = _ref.triggerOpen,
    forwardKeyDown = _ref.forwardKeyDown,
    _onKeyDown = _ref.onKeyDown,
    blurToCancel = _ref.blurToCancel,
    onSubmit = _ref.onSubmit,
    onCancel = _ref.onCancel,
    _onFocus = _ref.onFocus,
    _onBlur = _ref.onBlur,
    changeOnBlur = _ref.changeOnBlur;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    typing = _useState2[0],
    setTyping = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    focused = _useState4[0],
    setFocused = _useState4[1];

  /**
   * We will prevent blur to handle open event when user click outside,
   * since this will repeat trigger `onOpenChange` event.
   */
  var preventBlurRef = (0, _react.useRef)(false);
  var valueChangedRef = (0, _react.useRef)(false);
  var preventDefaultRef = (0, _react.useRef)(false);
  var inputProps = {
    onMouseDown: function onMouseDown() {
      setTyping(true);
      triggerOpen(true);
    },
    onKeyDown: function onKeyDown(e) {
      var preventDefault = function preventDefault() {
        preventDefaultRef.current = true;
      };
      _onKeyDown(e, preventDefault);
      if (preventDefaultRef.current) return;
      switch (e.which) {
        case _KeyCode.default.ENTER:
          {
            if (!open) {
              triggerOpen(true);
            } else if (onSubmit() !== false) {
              setTyping(true);
            }
            e.preventDefault();
            return;
          }
        case _KeyCode.default.TAB:
          {
            if (typing && open && !e.shiftKey) {
              setTyping(false);
              e.preventDefault();
            } else if (!typing && open) {
              if (!forwardKeyDown(e) && e.shiftKey) {
                setTyping(true);
                e.preventDefault();
              }
            }
            return;
          }
        case _KeyCode.default.ESC:
          {
            setTyping(true);
            onCancel();
            return;
          }
      }
      if (!open && ![_KeyCode.default.SHIFT].includes(e.which)) {
        triggerOpen(true);
      } else if (!typing) {
        // Let popup panel handle keyboard
        forwardKeyDown(e);
      }
    },
    onFocus: function onFocus(e) {
      setTyping(true);
      setFocused(true);
      if (_onFocus) {
        _onFocus(e);
      }
    },
    onBlur: function onBlur(e) {
      if (preventBlurRef.current || !isClickOutside(document.activeElement)) {
        preventBlurRef.current = false;
        return;
      }
      if (blurToCancel) {
        setTimeout(function () {
          var _document = document,
            activeElement = _document.activeElement;
          while (activeElement && activeElement.shadowRoot) {
            activeElement = activeElement.shadowRoot.activeElement;
          }
          if (isClickOutside(activeElement)) {
            onCancel();
          }
        }, 0);
      } else if (open) {
        triggerOpen(false);
        if (valueChangedRef.current) {
          onSubmit();
        }
      }
      setFocused(false);
      _onBlur === null || _onBlur === void 0 ? void 0 : _onBlur(e);
    }
  };

  // check if value changed
  (0, _react.useEffect)(function () {
    valueChangedRef.current = false;
  }, [open]);
  (0, _react.useEffect)(function () {
    valueChangedRef.current = true;
  }, [value]);

  // Global click handler
  (0, _react.useEffect)(function () {
    return (0, _uiUtil.addGlobalMouseDownEvent)(function (e) {
      var target = (0, _uiUtil.getTargetFromEvent)(e);
      var clickedOutside = isClickOutside(target);
      if (open) {
        if (!clickedOutside) {
          preventBlurRef.current = true;

          // Always set back in case `onBlur` prevented by user
          (0, _raf.default)(function () {
            preventBlurRef.current = false;
          });
        } else if (!changeOnBlur && (!focused || clickedOutside)) {
          triggerOpen(false);
        }
      }
    });
  });
  return [inputProps, {
    focused: focused,
    typing: typing
  }];
}