"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.interpolateName = void 0;
var tslib_1 = require("tslib");
var path = tslib_1.__importStar(require("path"));
var crypto_1 = require("crypto");
function getHashDigest(content, hashType, digestType, length) {
    if (hashType === void 0) { hashType = 'md5'; }
    if (digestType === void 0) { digestType = 'hex'; }
    if (length === void 0) { length = 9999; }
    var hasher = crypto_1.createHash(hashType);
    hasher.update(content);
    return hasher.digest(digestType).slice(0, length);
}
function interpolateName(loaderContext, name, options) {
    var filename;
    var hasQuery = loaderContext.resourceQuery && loaderContext.resourceQuery.length > 1;
    if (typeof name === 'function') {
        filename = name(loaderContext.resourcePath, hasQuery ? loaderContext.resourceQuery : undefined);
    }
    else {
        filename = name || '[hash].[ext]';
    }
    var context = options.context;
    var content = options.content;
    var regExp = options.regExp;
    var ext = 'bin';
    var basename = 'file';
    var directory = '';
    var folder = '';
    var query = '';
    if (loaderContext.resourcePath) {
        var parsed = path.parse(loaderContext.resourcePath);
        var resourcePath = loaderContext.resourcePath;
        if (parsed.ext) {
            ext = parsed.ext.substr(1);
        }
        if (parsed.dir) {
            basename = parsed.name;
            resourcePath = parsed.dir + path.sep;
        }
        if (typeof context !== 'undefined') {
            directory = path
                .relative(context, resourcePath + '_')
                .replace(/\\/g, '/')
                .replace(/\.\.(\/)?/g, '_$1');
            directory = directory.substr(0, directory.length - 1);
        }
        else {
            directory = resourcePath.replace(/\\/g, '/').replace(/\.\.(\/)?/g, '_$1');
        }
        if (directory.length === 1) {
            directory = '';
        }
        else if (directory.length > 1) {
            folder = path.basename(directory);
        }
    }
    if (loaderContext.resourceQuery && loaderContext.resourceQuery.length > 1) {
        query = loaderContext.resourceQuery;
        var hashIdx = query.indexOf('#');
        if (hashIdx >= 0) {
            query = query.substr(0, hashIdx);
        }
    }
    var url = filename;
    if (content) {
        // Match hash template
        url = url
            // `hash` and `contenthash` are same in `loader-utils` context
            // let's keep `hash` for backward compatibility
            .replace(/\[(?:([^:\]]+):)?(?:hash|contenthash)(?::([a-z]+\d*))?(?::(\d+))?\]/gi, function (_, hashType, digestType, maxLength) {
            return getHashDigest(content, hashType, digestType, parseInt(maxLength, 10));
        });
    }
    url = url
        .replace(/\[ext\]/gi, function () { return ext; })
        .replace(/\[name\]/gi, function () { return basename; })
        .replace(/\[path\]/gi, function () { return directory; })
        .replace(/\[folder\]/gi, function () { return folder; })
        .replace(/\[query\]/gi, function () { return query; });
    if (regExp && loaderContext.resourcePath) {
        var match = loaderContext.resourcePath.match(new RegExp(regExp));
        match &&
            match.forEach(function (matched, i) {
                url = url.replace(new RegExp('\\[' + i + '\\]', 'ig'), matched);
            });
    }
    if (typeof loaderContext.options === 'object' &&
        typeof loaderContext.options.customInterpolateName === 'function') {
        url = loaderContext.options.customInterpolateName.call(loaderContext, url, name, options);
    }
    return url;
}
exports.interpolateName = interpolateName;
