"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.error = exports.warn = exports.debug = void 0;
var tslib_1 = require("tslib");
var chalk_1 = require("chalk");
var util_1 = require("util");
var LEVEL_COLORS = {
    debug: chalk_1.green,
    warn: chalk_1.yellow,
    error: chalk_1.red,
};
function label(level, message) {
    return "[@formatjs/ts-transformer] [" + LEVEL_COLORS[level](level.toUpperCase()) + "] " + message;
}
function debug(message) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    if (process.env.LOG_LEVEL !== 'debug') {
        return;
    }
    process.stderr.write(util_1.format.apply(void 0, tslib_1.__spreadArray([label('debug', message)], args)));
    process.stderr.write('\n');
}
exports.debug = debug;
function warn(message) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    process.stderr.write(util_1.format.apply(void 0, tslib_1.__spreadArray([label('warn', message)], args)));
    process.stderr.write('\n');
}
exports.warn = warn;
function error(message) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    process.stderr.write(util_1.format.apply(void 0, tslib_1.__spreadArray([label('error', message)], args)));
    process.stderr.write('\n');
}
exports.error = error;
