"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.printDateTimeSkeleton = exports.doPrintAST = exports.printAST = void 0;
var tslib_1 = require("tslib");
var types_1 = require("./types");
function printAST(ast) {
    return doPrintAST(ast, false);
}
exports.printAST = printAST;
function doPrintAST(ast, isInPlural) {
    var printedNodes = ast.map(function (el) {
        if (types_1.isLiteralElement(el)) {
            return printLiteralElement(el, isInPlural);
        }
        if (types_1.isArgumentElement(el)) {
            return printArgumentElement(el);
        }
        if (types_1.isDateElement(el) || types_1.isTimeElement(el) || types_1.isNumberElement(el)) {
            return printSimpleFormatElement(el);
        }
        if (types_1.isPluralElement(el)) {
            return printPluralElement(el);
        }
        if (types_1.isSelectElement(el)) {
            return printSelectElement(el);
        }
        if (types_1.isPoundElement(el)) {
            return '#';
        }
        if (types_1.isTagElement(el)) {
            return printTagElement(el);
        }
    });
    return printedNodes.join('');
}
exports.doPrintAST = doPrintAST;
function printTagElement(el) {
    return "<" + el.value + ">" + printAST(el.children) + "</" + el.value + ">";
}
function printEscapedMessage(message) {
    return message.replace(/([{}](?:.*[{}])?)/su, "'$1'");
}
function printLiteralElement(_a, isInPlural) {
    var value = _a.value;
    var escaped = printEscapedMessage(value);
    return isInPlural ? escaped.replace('#', "'#'") : escaped;
}
function printArgumentElement(_a) {
    var value = _a.value;
    return "{" + value + "}";
}
function printSimpleFormatElement(el) {
    return "{" + el.value + ", " + types_1.TYPE[el.type] + (el.style ? ", " + printArgumentStyle(el.style) : '') + "}";
}
function printNumberSkeletonToken(token) {
    var stem = token.stem, options = token.options;
    return options.length === 0
        ? stem
        : "" + stem + options.map(function (o) { return "/" + o; }).join('');
}
function printArgumentStyle(style) {
    if (typeof style === 'string') {
        return printEscapedMessage(style);
    }
    else if (style.type === types_1.SKELETON_TYPE.dateTime) {
        return "::" + printDateTimeSkeleton(style);
    }
    else {
        return "::" + style.tokens.map(printNumberSkeletonToken).join(' ');
    }
}
function printDateTimeSkeleton(style) {
    return style.pattern;
}
exports.printDateTimeSkeleton = printDateTimeSkeleton;
function printSelectElement(el) {
    var msg = [
        el.value,
        'select',
        Object.keys(el.options)
            .map(function (id) { return id + "{" + doPrintAST(el.options[id].value, false) + "}"; })
            .join(' '),
    ].join(',');
    return "{" + msg + "}";
}
function printPluralElement(el) {
    var type = el.pluralType === 'cardinal' ? 'plural' : 'selectordinal';
    var msg = [
        el.value,
        type,
        tslib_1.__spreadArray([
            el.offset ? "offset:" + el.offset : ''
        ], Object.keys(el.options).map(function (id) { return id + "{" + doPrintAST(el.options[id].value, true) + "}"; })).filter(Boolean)
            .join(' '),
    ].join(',');
    return "{" + msg + "}";
}
