"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseFile = void 0;
var compiler_sfc_1 = require("@vue/compiler-sfc");
function walk(node, visitor) {
    if (typeof node !== 'object') {
        return;
    }
    if (node.type !== 1 /* ELEMENT */ &&
        node.type !== 8 /* COMPOUND_EXPRESSION */ &&
        node.type !== 5 /* INTERPOLATION */) {
        return;
    }
    visitor(node);
    if (node.type === 5 /* INTERPOLATION */) {
        visitor(node.content);
    }
    else if (node.type === 1 /* ELEMENT */) {
        node.children.forEach(function (n) { return walk(n, visitor); });
        node.props
            .filter(function (prop) { return prop.type === 7 /* DIRECTIVE */; })
            .filter(function (prop) { return !!prop.exp; })
            .forEach(function (prop) { return visitor(prop.exp); });
    }
    else {
        node.children.forEach(function (n) { return walk(n, visitor); });
    }
}
function templateSimpleExpressionNodeVisitor(parseScriptFn) {
    return function (n) {
        if (typeof n !== 'object') {
            return;
        }
        if (n.type !== 4 /* SIMPLE_EXPRESSION */) {
            return;
        }
        var content = n.content;
        // Wrap this in () since a vue comp node attribute can just be
        // an object literal which, by itself is invalid TS
        // but with () it becomes an ExpressionStatement
        parseScriptFn("(" + content + ")");
    };
}
function parseFile(source, filename, parseScriptFn) {
    var _a = compiler_sfc_1.parse(source, {
        filename: filename,
    }), descriptor = _a.descriptor, errors = _a.errors;
    if (errors.length) {
        throw errors[0];
    }
    var script = descriptor.script, template = descriptor.template;
    if (template) {
        walk(template.ast, templateSimpleExpressionNodeVisitor(parseScriptFn));
    }
    if (script) {
        parseScriptFn(script.content);
    }
}
exports.parseFile = parseFile;
