"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateENXB = exports.generateENXA = exports.generateXXHA = exports.generateXXAC = exports.generateXXLS = void 0;
var tslib_1 = require("tslib");
var icu_messageformat_parser_1 = require("@formatjs/icu-messageformat-parser");
function generateXXLS(msg) {
    var ast = typeof msg === 'string' ? icu_messageformat_parser_1.parse(msg) : msg;
    var lastChunk = ast.pop();
    if (lastChunk && icu_messageformat_parser_1.isLiteralElement(lastChunk)) {
        lastChunk.value += 'SSSSSSSSSSSSSSSSSSSSSSSSS';
        return tslib_1.__spreadArray(tslib_1.__spreadArray([], ast), [lastChunk]);
    }
    return tslib_1.__spreadArray(tslib_1.__spreadArray([], ast), [{ type: icu_messageformat_parser_1.TYPE.literal, value: 'SSSSSSSSSSSSSSSSSSSSSSSSS' }]);
}
exports.generateXXLS = generateXXLS;
function generateXXAC(msg) {
    var ast = typeof msg === 'string' ? icu_messageformat_parser_1.parse(msg) : msg;
    ast.forEach(function (el) {
        if (icu_messageformat_parser_1.isLiteralElement(el)) {
            el.value = el.value.toUpperCase();
        }
        else if (icu_messageformat_parser_1.isPluralElement(el) || icu_messageformat_parser_1.isSelectElement(el)) {
            for (var _i = 0, _a = Object.values(el.options); _i < _a.length; _i++) {
                var opt = _a[_i];
                generateXXAC(opt.value);
            }
        }
        else if (icu_messageformat_parser_1.isTagElement(el)) {
            generateXXAC(el.children);
        }
    });
    return ast;
}
exports.generateXXAC = generateXXAC;
function generateXXHA(msg) {
    var ast = typeof msg === 'string' ? icu_messageformat_parser_1.parse(msg) : msg;
    var firstChunk = ast.shift();
    if (firstChunk && icu_messageformat_parser_1.isLiteralElement(firstChunk)) {
        firstChunk.value = '[javascript]' + firstChunk.value;
        return tslib_1.__spreadArray([firstChunk], ast);
    }
    return tslib_1.__spreadArray([{ type: icu_messageformat_parser_1.TYPE.literal, value: '[javascript]' }], ast);
}
exports.generateXXHA = generateXXHA;
var ASCII = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
var ACCENTED_ASCII = 'âḃćḋèḟĝḫíĵǩĺṁńŏṗɋŕśṭůṿẘẋẏẓḀḂḈḊḔḞḠḢḬĴḴĻḾŊÕṔɊŔṠṮŨṼẄẌŸƵ';
function generateENXA(msg) {
    var ast = typeof msg === 'string' ? icu_messageformat_parser_1.parse(msg) : msg;
    ast.forEach(function (el) {
        if (icu_messageformat_parser_1.isLiteralElement(el)) {
            el.value = el.value
                .split('')
                .map(function (c) {
                var i = ASCII.indexOf(c);
                if (i < 0) {
                    return c;
                }
                return ACCENTED_ASCII[i];
            })
                .join('');
        }
        else if (icu_messageformat_parser_1.isPluralElement(el) || icu_messageformat_parser_1.isSelectElement(el)) {
            for (var _i = 0, _a = Object.values(el.options); _i < _a.length; _i++) {
                var opt = _a[_i];
                generateENXA(opt.value);
            }
        }
        else if (icu_messageformat_parser_1.isTagElement(el)) {
            generateENXA(el.children);
        }
    });
    return ast;
}
exports.generateENXA = generateENXA;
function generateENXB(msg) {
    var ast = typeof msg === 'string' ? icu_messageformat_parser_1.parse(msg) : msg;
    ast.forEach(function (el) {
        if (icu_messageformat_parser_1.isLiteralElement(el)) {
            var pseudoString = el.value
                .split('')
                .map(function (c, index) {
                var i = ASCII.indexOf(c);
                var canPad = (index + 1) % 3 === 0;
                if (i < 0) {
                    return c;
                }
                return canPad ? ACCENTED_ASCII[i].repeat(3) : ACCENTED_ASCII[i];
            })
                .join('');
            el.value = "[!! " + pseudoString + " !!]";
        }
        else if (icu_messageformat_parser_1.isPluralElement(el) || icu_messageformat_parser_1.isSelectElement(el)) {
            for (var _i = 0, _a = Object.values(el.options); _i < _a.length; _i++) {
                var opt = _a[_i];
                generateENXB(opt.value);
            }
        }
        else if (icu_messageformat_parser_1.isTagElement(el)) {
            generateENXB(el.children);
        }
    });
    return ast;
}
exports.generateENXB = generateENXB;
