"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseScript = void 0;
var tslib_1 = require("tslib");
var ts_transformer_1 = require("@formatjs/ts-transformer");
var typescript_1 = tslib_1.__importDefault(require("typescript"));
var console_utils_1 = require("./console_utils");
/**
 * Invoid TypeScript module transpilation with our TS transformer
 * @param opts Formatjs TS Transformer opt
 * @param fn filename
 */
function parseScript(opts, fn) {
    return function (source) {
        var output;
        try {
            console_utils_1.debug('Using TS compiler to process file', fn);
            output = typescript_1.default.transpileModule(source, {
                compilerOptions: {
                    allowJs: true,
                    target: typescript_1.default.ScriptTarget.ESNext,
                    noEmit: true,
                    experimentalDecorators: true,
                },
                reportDiagnostics: true,
                fileName: fn,
                transformers: {
                    before: [ts_transformer_1.transformWithTs(typescript_1.default, opts)],
                },
            });
        }
        catch (e) {
            e.message = "Error processing file " + fn + " \n" + (e.message || '');
            throw e;
        }
        if (output.diagnostics) {
            var errs = output.diagnostics.filter(function (d) { return d.category === typescript_1.default.DiagnosticCategory.Error; });
            if (errs.length) {
                throw new Error(typescript_1.default.formatDiagnosticsWithColorAndContext(errs, {
                    getCanonicalFileName: function (fileName) { return fileName; },
                    getCurrentDirectory: function () { return process.cwd(); },
                    getNewLine: function () { return typescript_1.default.sys.newLine; },
                }));
            }
        }
    };
}
exports.parseScript = parseScript;
