"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compile = exports.compareMessages = exports.format = void 0;
var format = function (msgs) {
    var results = {
        smartling: {
            translate_paths: [
                {
                    path: '*/message',
                    key: '{*}/message',
                    instruction: '*/description',
                },
            ],
            variants_enabled: true,
            string_format: 'icu',
        },
    };
    for (var _i = 0, _a = Object.entries(msgs); _i < _a.length; _i++) {
        var _b = _a[_i], id = _b[0], msg = _b[1];
        results[id] = {
            message: msg.defaultMessage,
            description: msg.description,
        };
    }
    return results;
};
exports.format = format;
var compareMessages = function (el1, el2) {
    // `smartling` has to be the 1st key
    if (el1.key === 'smartling') {
        return -1;
    }
    if (el2.key === 'smartling') {
        return 1;
    }
    return el1.key < el2.key ? -1 : el1.key === el2.key ? 0 : 1;
};
exports.compareMessages = compareMessages;
var compile = function (msgs) {
    var results = {};
    for (var _i = 0, _a = Object.entries(msgs); _i < _a.length; _i++) {
        var _b = _a[_i], id = _b[0], msg = _b[1];
        if (id === 'smartling') {
            continue;
        }
        results[id] = msg.message;
    }
    return results;
};
exports.compile = compile;
