import { Opts, MessageDescriptor } from '@formatjs/ts-transformer';
import { Formatter } from './formatters';
export interface ExtractionResult<M = Record<string, string>> {
    /**
     * List of extracted messages
     */
    messages: MessageDescriptor[];
    /**
     * Metadata extracted w/ `pragma`
     */
    meta?: M;
}
export interface ExtractedMessageDescriptor extends MessageDescriptor {
    /**
     * Line number
     */
    line?: number;
    /**
     * Column number
     */
    col?: number;
    /**
     * Metadata extracted from pragma
     */
    meta?: Record<string, string>;
}
export declare type ExtractCLIOptions = Omit<ExtractOpts, 'overrideIdFn' | 'onMsgExtracted' | 'onMetaExtracted'> & {
    /**
     * Output File
     */
    outFile?: string;
    /**
     * Ignore file glob pattern
     */
    ignore?: string[];
};
export declare type ExtractOpts = Opts & {
    /**
     * Whether to throw an error if we had any issues with
     * 1 of the source files
     */
    throws?: boolean;
    /**
     * Message ID interpolation pattern
     */
    idInterpolationPattern?: string;
    /**
     * Whether we read from stdin instead of a file
     */
    readFromStdin?: boolean;
    /**
     * Path to a formatter file that controls the shape of JSON file from `outFile`.
     */
    format?: string | Formatter;
    /**
     * Whether to hoist selectors & flatten sentences
     */
    flatten?: boolean;
} & Pick<Opts, 'onMsgExtracted' | 'onMetaExtracted'>;
/**
 * Extract strings from source files
 * @param files list of files
 * @param extractOpts extract options
 * @returns messages serialized as JSON string since key order
 * matters for some `format`
 */
export declare function extract(files: readonly string[], extractOpts: ExtractOpts): Promise<string>;
/**
 * Extract strings from source files, also writes to a file.
 * @param files list of files
 * @param extractOpts extract options
 * @returns A Promise that resolves if output file was written successfully
 */
export default function extractAndWrite(files: readonly string[], extractOpts: ExtractCLIOptions): Promise<void>;
//# sourceMappingURL=extract.d.ts.map