"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStdinAsString = exports.error = exports.warn = exports.debug = exports.clearLine = void 0;
var tslib_1 = require("tslib");
var chalk_1 = require("chalk");
var readline_1 = tslib_1.__importDefault(require("readline"));
var tty_1 = tslib_1.__importDefault(require("tty"));
var util_1 = require("util");
var CLEAR_WHOLE_LINE = 0;
// From:
// https://github.com/yarnpkg/yarn/blob/53d8004229f543f342833310d5af63a4b6e59c8a/src/reporters/console/util.js
function clearLine(terminal) {
    if (!chalk_1.supportsColor) {
        if (terminal instanceof tty_1.default.WriteStream) {
            // terminal
            if (terminal.columns > 0) {
                terminal.write("\r" + ' '.repeat(terminal.columns - 1));
            }
            terminal.write("\r");
        }
        // ignore piping to file
    }
    else {
        readline_1.default.clearLine(terminal, CLEAR_WHOLE_LINE);
        readline_1.default.cursorTo(terminal, 0);
    }
}
exports.clearLine = clearLine;
var LEVEL_COLORS = {
    debug: chalk_1.green,
    warn: chalk_1.yellow,
    error: chalk_1.red,
};
function label(level, message) {
    return "[@formatjs/cli] [" + LEVEL_COLORS[level](level.toUpperCase()) + "] " + message;
}
function debug(message) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    if (process.env.LOG_LEVEL !== 'debug') {
        return;
    }
    clearLine(process.stderr);
    process.stderr.write(util_1.format.apply(void 0, tslib_1.__spreadArray([label('debug', message)], args)));
    process.stderr.write('\n');
}
exports.debug = debug;
function warn(message) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    clearLine(process.stderr);
    process.stderr.write(util_1.format.apply(void 0, tslib_1.__spreadArray([label('warn', message)], args)));
    process.stderr.write('\n');
}
exports.warn = warn;
function error(message) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    clearLine(process.stderr);
    process.stderr.write(util_1.format.apply(void 0, tslib_1.__spreadArray([label('error', message)], args)));
    process.stderr.write('\n');
}
exports.error = error;
function getStdinAsString() {
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var result;
        return tslib_1.__generator(this, function (_a) {
            result = '';
            return [2 /*return*/, new Promise(function (resolve) {
                    process.stdin.setEncoding('utf-8');
                    process.stdin.on('readable', function () {
                        var chunk;
                        while ((chunk = process.stdin.read())) {
                            result += chunk;
                        }
                    });
                    process.stdin.on('end', function () {
                        resolve(result);
                    });
                })];
        });
    });
}
exports.getStdinAsString = getStdinAsString;
