import { Formatter } from './formatters';
export declare type CompileFn = (msgs: any) => Record<string, string>;
export declare type PseudoLocale = 'xx-LS' | 'xx-AC' | 'xx-HA' | 'en-XA' | 'en-XB';
export interface CompileCLIOpts extends Opts {
    /**
     * The target file that contains compiled messages.
     */
    outFile?: string;
}
export interface Opts {
    /**
     * Whether to compile message into AST instead of just string
     */
    ast?: boolean;
    /**
     * Whether to continue compiling messages after encountering an error.
     * Any keys with errors will not be included in the output file.
     */
    skipErrors?: boolean;
    /**
     * Path to a formatter file that converts <translation_files> to
     * `Record<string, string>` so we can compile.
     */
    format?: string | Formatter;
    /**
     * Whether to compile to pseudo locale
     */
    pseudoLocale?: PseudoLocale;
}
/**
 * Aggregate `inputFiles` into a single JSON blob and compile.
 * Also checks for conflicting IDs.
 * Then returns the serialized result as a `string` since key order
 * makes a difference in some vendor.
 * @param inputFiles Input files
 * @param opts Options
 * @returns serialized result in string format
 */
export declare function compile(inputFiles: string[], opts?: Opts): Promise<string>;
/**
 * Aggregate `inputFiles` into a single JSON blob and compile.
 * Also checks for conflicting IDs and write output to `outFile`.
 * @param inputFiles Input files
 * @param compileOpts options
 * @returns A `Promise` that resolves if file was written successfully
 */
export default function compileAndWrite(inputFiles: string[], compileOpts?: CompileCLIOpts): Promise<void>;
//# sourceMappingURL=compile.d.ts.map