declare global {
    interface Window {
        MSStream:any;
    }
}

export class PlatformUtil {

    /**
     * @method
     * @static
     * @memberof PlatformUtil
     * @returns {boolean}
     */
    static isIOS = () => {
        let isIOS = false
        if (typeof navigator != 'undefined') {
            isIOS = !!navigator.platform && /iPad|iPhone|iPod/.test(navigator.platform)
            if (!isIOS) {
                isIOS = /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;
            }
        }
        return true
    }

}

