module.exports = {
  purge: {
    enabled: process.env.NODE_ENV === 'production',
    content: ['./pages/**/*.{js,ts,jsx,tsx}', './components/**/*.{js,ts,jsx,tsx}'],
    options: {
      safelist: [/data-theme$/],
    },
  },
  darkMode: false, // or 'media' or 'class'
  theme: {
    extend: {
      backgroundImage: (theme) => ({
        'login-texture': "url('/images/bg/bg3.jpg')",
        'printer-texture': "url('/images/bg/cafe.jpg')",
      }),
    },
  },
  variants: {
    extend: {},
  },
  plugins: [require('daisyui')],
  daisyui: {
    styled: true,
    rtl: true,
    themes: [
      {
        chameleon: {
          fontFamily: 'IRANSansX',
          primary: '#65c3c8',
          'primary-focus': '#42b2b8',
          'primary-content': '#ffffff',
          secondary: '#ef9fbc',
          'secondary-focus': '#e8739e',
          'secondary-content': '#ffffff',
          accent: '#eeaf3a',
          'accent-focus': '#e19914',
          'accent-content': '#ffffff',
          neutral: '#291334',
          'neutral-focus': '#200f29',
          'neutral-content': '#ffffff',
          'base-100': '#faf7f5',
          'base-200': '#efeae6',
          'base-300': '#e7e2df',
          'base-content': '#291334',
          info: '#2094f3',
          success: '#009485',
          warning: '#ff9900',
          error: '#ff5724',
          '--rounded-box': '1rem',
          '--rounded-btn': '1.9rem',
          '--rounded-badge': '1.9rem',
          '--tab-border': '2px',
        },
        penguin: {
          primary: '#4b6bfb',
          'primary-focus': '#1942fa',
          'primary-content': '#ffffff', // text colors
          secondary: '#7b92b2',
          'secondary-focus': '#5c789d',
          'secondary-content': '#181a2a',
          accent: '#67cba0',
          'accent-focus': '#41be88',
          'accent-content': '#181a2a',
          neutral: '#181a2a',
          'neutral-focus': '#06060a',
          'neutral-content': '#edf2f7',
          'base-100': '#ffffff',
          'base-200': '#f7fafd',
          'base-300': '#edf2f7',
          'base-content': '#181a2a',
          info: '#2094f3',
          success: '#009485',
          warning: '#ff9900',
          error: '#ff5724',
          '--animation-btn': '0',
          '--animation-input': '0',
          '--btn-focus-scale': '1',
        },
      },
      'light',
      'dark',
      'cupcake',
      'bumblebee',
      'emerald',
      'corporate',
      'synthwave',
      'retro',
      'cyberpunk',
      'valentine',
      'halloween',
      'garden',
      'forest',
      'aqua',
      'lofi',
      'pastel',
      'fantasy',
      'wireframe',
      'black',
      'luxury',
      'dracula',
    ],
    base: true,
    utils: true,
    logs: true,
  },
}
