import apiUrl from "apiUrl";
import { formatPrice, roundFinalPrice } from "helpers/format";
import ICart from "interfaces/cart";
import ICustomer from "interfaces/customer";
import { submitOrderOffline } from "./order";

export const printOrder = async (
    order,
    repeat?,
    salon?,
    printer?,
    reprint?,
    print_type?,
    raw_items?,
    printData?,
) => {
    if (order["order"]) {
        let o = JSON.parse(order["order"].order_details);
        let local = JSON.parse(order["order"].order_local);
        o["detail"].table_id = order["order"].table_id;
        o["detail"].use_point = order["order"].use_point
            ? order["order"].use_point
            : false;
        o["detail"].user_point = order["order"].user_point
            ? order["order"].user_point
            : 0;
        o["detail"].service = order["order"].service
            ? order["order"].service
            : "";
        o["detail"].tip = order["order"].tip ? order["order"].tip : "";
        o["detail"].payment_card = order["order"].payment_card
            ? order["order"].payment_card
            : "";
        o["detail"].payment_pos = order["order"].payment_pos
            ? order["order"].payment_pos
            : "";
        o["detail"].payment_cash = order["order"].payment_cash
            ? order["order"].payment_cash
            : "";
        o["detail"].numPeople = local.numPeople ? local.numPeople : "";
        o["detail"].note = order["order"].note ? order["order"].note : "";
        o["detail"].userDiscount = order["order"].userDiscount ? order["order"].userDiscount : "";
        if (salon) o["salon"] = salon;
        if (printer) o["printer"] = printer;
        // console.log('sadsadsadsad')
        renderDetailsOrderInCart(
            o,
            repeat,
            order["order"],
            reprint ? reprint : 0,
            print_type ? print_type : "",
            raw_items,
            printData
        );
    }
};
const renderDetailsOrderInCart = (
    order,
    repeatPrint?: any,
    orderObj?: any,
    reprint?: any,
    print_type?: any,
    raw_items?: any,
    printData?: any,
) => {

    let newOrder = getNewOrder(order, raw_items);
    if (repeatPrint != 1) {
        return true;
    } else {
        repeatPrintOffline(
            order,
            newOrder,
            orderObj,
            reprint ? reprint : 0,
            print_type ? print_type : "",
            raw_items,
            printData
        );
    }
};
const getNewOrder = (order, raw_items) => {
    let newOrder = [];

    Object.keys(order["items"]).map((item) => {
        let id_item = item.split("_")[0];

        let options = [];
        if (order["items"][item]["options"] != null) {
            const opts = JSON.parse(order["items"][item]["options"] || "[]");
            for (const opt of opts) {
                options.push({
                    id: opt,
                    name: raw_items[opt]["name"],
                    price: raw_items[opt]["last_price"] / 1000,
                    image: apiUrl[0] + "/",
                });
            }
        }

        newOrder = [
            ...newOrder,
            {
                product: {
                    name: `${options.length
                        ? `${raw_items[id_item].name}(${options
                            .map((opt) => opt.name)
                            .join("-")})`
                        : raw_items[id_item].name
                        }`,
                    baseName: raw_items[id_item].name,
                    id: Number(id_item),
                    price:
                        (options.length
                            ? options
                                .map((i) => i.price)
                                .reduce((accumulator, curr) => accumulator + curr) +
                            raw_items[id_item].last_price
                            : raw_items[id_item].last_price) * 1000,
                    options: options,
                    vat_include: raw_items[id_item].vat_include,
                    unique: `${id_item}-${options.length
                        ? `${raw_items[id_item].name}(${options
                            .map((opt) => opt.name)
                            .join("-")})`
                        : raw_items[id_item].name
                        }`,
                },
                count: order["items"][item]["qty"],
                note: order["items"][item]["note"]
                    ? order["items"][item]["note"]
                    : "",
            },
        ];
    });
    return newOrder;
};
const repeatPrintOffline = (
    order,
    newOrder,
    orderObj,
    reprint,
    print_type?,
    raw_items?,
    printData?,
) => {
    const orderId = order["detail"].id;
    const tableId = order["detail"].table_id;
    let totalAmount = 0;

    newOrder.map((item) => {
        totalAmount += item.product.price * item.count;
    });

    let price = totalAmount;
    let discount = orderObj.discount;
    if (discount) totalAmount -= parseInt(discount);
    if (orderObj.service) totalAmount += parseInt(orderObj.service);
    if (orderObj.tip) totalAmount += parseInt(orderObj.tip);
    if (orderObj.tax) totalAmount += orderObj.tax;

    // const totalAmount = orderObj.total;
    const factorID = orderObj._id;
    let customer = { name: "", id: -1 };
    if (order["detail"].user_name)
        customer = { name: order["detail"].user_name, id: 0 };

    let p_bill = null;
    let printer = null;
    if (order.printer) printer = order.printer;
    totalAmount = roundFinalPrice(totalAmount);
    requestPrintOffline(
        newOrder,
        customer,
        formatPrice(totalAmount),
        orderId,
        factorID,
        discount,
        tableId,
        print_type,
        p_bill,
        printer,
        orderObj.note,
        "",
        order["detail"].service,
        reprint,
        orderObj.tip ? orderObj.tip : null,
        orderObj.tax,
        orderObj.loviuna,
        raw_items,
        printData
    );
};
const requestPrintOffline = (
    order: ICart[],
    customer: ICustomer,
    totalAmount: string,
    offline_id: string,
    factorID: string,
    useDiscount?: any,
    table_id?: string,
    print_type?: any,
    p_bill?: any,
    printer?: any,
    note?: any,
    numPeople?: any,
    service?: any,
    reprint?: any,
    tip?: any,
    taxPrice?: any,
    loviuna?: any,
    raw_items?: any,
    printData?: any
) => {

    let prns = printData['prns'];
    let custom_print_valuet = printData['custom_print_valuet'];
    let salon = printData['salon'];
    let tabales = printData['tabales'];
    let phone = printData['phone'];
    let p_bar;
    if (table_id) {
        if (salon != null)
            Object.keys(salon).forEach((k) => {
                if (tabales[k][table_id]) {
                    p_bar = salon[k].p_bar;
                }
            });
    }

    let borderSize = printData['borderSize'];
    let fontSize = printData['fontSize'];
    let pageWidth = printData['pageWidth'];
    print_type = "پرینت مشتری و باریستا";
    submitOrderOffline(
        order,
        customer,
        totalAmount,
        prns,
        offline_id,
        custom_print_valuet,
        raw_items,
        table_id,
        factorID,
        useDiscount,
        print_type,
        p_bill,
        p_bar,
        phone,
        note,
        numPeople,
        borderSize,
        fontSize,
        pageWidth,
        service,
        reprint,
        tip,
        taxPrice,
        loviuna,
        {
            no_brand: printData['no_brand'],
            branchName: printData['branchName'],
            custom_note: printData['custom_note']
        }
    )
        .then((response) => {
            // console.log('response', response);
        })
        .catch((err) => {
            console.log('err', err);
        });
};