import { requestPrint } from "helpers/printer";
import { IPrintOrder } from "interfaces/print-order";
import ICustomer from "interfaces/customer";
import ICart from "interfaces/cart";
import axios, { AxiosRequestConfig } from "axios";
import router from "next/router";
import { toast } from "react-toastify";

import basUrl from "../baseU.js";

export const getCustomer = (
  token: string,
  query: string,
  searchWithId : any = 0
): Promise<object[]> => {
  return new Promise((resolve, reject) => {
    var data = new FormData();

    data.append("token", token);

    var config: AxiosRequestConfig = {
      method: "post",
      url: `/check-user?q=${query}&point=${1}&search_with_id=${searchWithId}&is_seperate_name=1`,
      data: data,
    };

    axios(config)
      .then(function (response) {
        resolve(response.data["results"]);
      })
      .catch(function (error) {
        // console.log(error)
        reject();
      });
  });
};

export const submitOrderOffline = (
  order: ICart[],
  customer: ICustomer,
  totalAmount: string,
  printers,
  offline_id: string,
  custom_print_valuet: any,
  raw_items: any,
  table_id?: any,
  factorID?: any,
  discount?: any,
  print_type?: any,
  p_bill?: any,
  p_bar?: any,
  phone?: any,
  note?: any,
  numPeople?: any,
  borderSize?: any,
  fontSize?: any,
  pageWidth?: any,
  service?: any,
  reprint?: any,
  tip?: any,
  taxPrice?: any,
  loviuna?: any,
  branchData?: any,
  isOnline?: any,
  customFields?: any,
): Promise<string> => {
  let no_brand: string = '';
  let branchName: string = '';
  let custom_note: string = '';
  if (!branchData) {
    no_brand = localStorage.getItem('no_brand');
    if (!no_brand) no_brand = '0';
    branchName = localStorage.getItem('branch_name');
    if (localStorage.getItem('custom_note'))
      custom_note = localStorage.getItem('custom_note');
  } else {
    no_brand = branchData['no_brand'];
    branchName = branchData['branchName'];
    custom_note = branchData['custom_note'] ? branchData['custom_note'] : '';
  }
  return new Promise((resolve, reject) => {
    const config: AxiosRequestConfig = {
      method: "post",
      baseURL: basUrl,
      url: "submit-order",
      headers: {
        "Content-Type": "application/json",
      },
      data: JSON.stringify({
        order,
        customer,
        totalAmount,
        printers,
        offline_id,
        custom_print_valuet,
        raw_items,
        table_id,
        factorID,
        discount,
        print_type,
        p_bill,
        p_bar,
        phone,
        note,
        numPeople,
        borderSize,
        fontSize,
        pageWidth,
        service,
        reprint,
        tip,
        taxPrice,
        loviuna,
        no_brand,
        branchName,
        isOnline,
        custom_note,
        customFields
      }),
    };

    axios(config)
      .then(function (response) {
        // console.log(response.data)
        resolve(response.data);
      })
      .catch((error) => {
        console.log(error)
        reject(error)
      });
  });
};

export const saveOrderOffline = (req): Promise<string> => {
  return new Promise((resolve, reject) => {
    const config: AxiosRequestConfig = {
      method: "post",
      baseURL: basUrl,
      url: "api/create",
      headers: {
        "Content-Type": "application/json",
      },
      data: JSON.stringify(req),
    };
    axios(config)
      .then(function (response) {
        resolve(response.data);
      })
      .catch((error) => reject(error));
  });
};
export const findOrder = (req, one?): Promise<string> => {
  return new Promise((resolve, reject) => {
    const config: AxiosRequestConfig = {
      method: "post",
      baseURL: basUrl,
      url: "api/find" + (one == 1 ? "?one=1" : ""),
      headers: {
        "Content-Type": "application/json",
      },
      data: JSON.stringify(req),
    };
    axios(config)
      .then(function (response) {        
        resolve(response.data);
      })
      .catch((error) => reject(error));
  });
};
export const saveBranch = (req): Promise<string> => {
  return new Promise((resolve, reject) => {
    const config: AxiosRequestConfig = {
      method: "post",
      baseURL: basUrl,
      url: "api/branch",
      headers: {
        "Content-Type": "application/json",
      },
      data: JSON.stringify(req),
    };
    axios(config)
      .then(function (response) {
        resolve(response.data);
      })
      .catch((error) => reject(error));
  });
};

export const submitOrder = (
  order: ICart[],
  token: string,
  customer: ICustomer,
  note: string,
  tableId: string,
  orderTypeDefault: string,
  paymentTypeDefault: string,
  usePoint,
  useDiscount,
  customerNote: string,
  noCustomer: Boolean,
  orderId,
  numPeople
) => {
  return new Promise((resolve, reject) => {
    let cart = [];
    order.forEach((item) => {
      cart.push({
        id: item.product.id,
        options: item.product.options,
        qty: item.count,
        note: item.note,
      });
    });
    let finalOrder = {
      cart,
      user_id: customer.id === 0 ? customer.name : customer.id,
    };

    var data = new FormData();
    data.append("token", token);
    data.append("cart", JSON.stringify(finalOrder));
    data.append("note", note);
    data.append("table_id", tableId);
    data.append("order_type_default", orderTypeDefault);
    data.append("payment_type", paymentTypeDefault);
    data.append("usePoint", usePoint);
    data.append("useDiscount", useDiscount.id);
    data.append("customer_note", customerNote);
    data.append("noCustomer", noCustomer.toString());
    data.append("order_id", orderId == 0 ? "" : orderId);
    data.append("numPeople", numPeople ? numPeople : "");

    var config: AxiosRequestConfig = {
      method: "post",
      url: "/submit-order",
      data: data,
    };

    axios(config)
      .then(function (response) {
        const printers = response.data.print_list;

        const printerBehave = localStorage.getItem("printer_behave_default");
        if (response.data.msg) {
          // alert(response.data.msg)
          toast.error(response.data.msg, {
            position: "bottom-right",
            style: { direction: "rtl", fontFamily: "IRANSansX" },
            theme: "colored",
          });
        }

        let printersArr = [];

        // console.log(printers);

        if (!printers) return reject();

        Object.keys(printers).forEach((node) => {
          let printer = localStorage.getItem(node);
          let printerNode = printers[node];

          // Management of individual printers
          const custom_print_valuet = JSON.parse(
            localStorage.getItem("custom_print_valuet") || "[]"
          );
          const raw_items = JSON.parse(localStorage.getItem("raw_items"));
          if (custom_print_valuet[node] && custom_print_valuet[node].cat) {
            let PO = [];
            order.map((item, i) => {
              if (
                custom_print_valuet[node].cat.includes(
                  raw_items[item.product.id].category_id.toString()
                )
              ) {
                PO.push(i);
              }
            });
            if (PO.length == 0) {
              return;
            }
          }

          if (!printer) {
            // router.push('/printers')
          } else {
            //print behave
            if (printerBehave == "بدون پرینت") {
            }
            if (printerBehave == "پرینت باریستا") {
              if (printerNode.type == "bar_all") {
                printersArr.push({
                  id: node,
                  name: printer,
                  page: printerNode.path,
                });
              }
            }
            if (printerBehave == "پرینت مشتری و باریستا") {
              printersArr.push({
                id: node,
                name: printer,
                page: printerNode.path,
              });
            }
          }
        });

        if (printerBehave != "بدون پرینت" && printersArr.length) {
          const printOrder: IPrintOrder = {
            printers: printersArr,
            orderId: response.data.order_id,
            billUrl: printersArr[0].page,
            totalItems: response.data.item.length,
          };
          requestPrint(printOrder)
            .then((resp) => {
              resolve(resp);
            })
            .catch((err) => {
              reject(err);
            });
        } else {
          resolve("ok");
        }
      })
      .catch(function (error) {
        console.log("catch");
        reject();
      });
  });
};

export const saveBill5 = (
  printer_id: string,
  pinter_name: string,
  pdf_url: string,
  status: string,
  orderId: string
): Promise<string> => {
  return new Promise((resolve, reject) => {
    const config: AxiosRequestConfig = {
      method: "post",
      baseURL: basUrl,
      url: "print1",
      headers: {
        "Content-Type": "application/json",
      },
      data: JSON.stringify({
        printer_id,
        pinter_name,
        pdf_url,
        status,
        orderId,
      }),
    };
    axios(config)
      .then(function (response) {
        resolve(response.data);
      })
      .catch((error) => reject(error));
  });
};

export const getTableList = (): Promise<string> => {
  return new Promise((resolve, reject) => {
    const client_id = localStorage.getItem("user_client_id");
    const token = localStorage.getItem("token");

    var data = new FormData();
    data.append("token", token);
    data.append("client_id", client_id);

    const config: AxiosRequestConfig = {
      method: "post",
      url: "/table?offline=1",
      data,
    };

    axios(config)
      .then(function ({ data }) {
        resolve(data.table_list);
      })
      .catch((error) => reject(error));
  });
};

export const getOnlineOrderData = (order_id, action = null): Promise<string> => {
  return new Promise((resolve, reject) => {
    const client_id = localStorage.getItem("user_client_id");
    const token = localStorage.getItem("token");

    var data = new FormData();
    data.append("token", token);
    data.append("client_id", client_id);
    data.append("order_id", order_id);

    const config: AxiosRequestConfig = {
      method: "post",
      url: action ? "/get-order-data2" : "/get-order-data",
      data,
    };
    axios(config)
      .then(function (response) {
        resolve(response.data);
      })
      .catch((error) => reject(error));
  });
};

export const createOrderData = (order) => {
  let raw_items = localStorage.getItem("raw_items") || "[]";
  raw_items = JSON.parse(raw_items);

  let newOrder = [];
  Object.keys(order["items"]).map((item) => {
    let id_item = item.split("_")[0];
    let options = [];
    if (order["items"][item]["options"] != null) {
      const opts = JSON.parse(order["items"][item]["options"] || "[]");
      for (const opt of opts) {
        options.push({
          id: opt,
          name: raw_items[opt]["name"],
          price: raw_items[opt]["last_price"] * 1000,
          image: "",
        });
      }
    }
    newOrder = [
      ...newOrder,
      {
        product: {
          name: `${options.length
            ? `${raw_items[id_item].name}(${options
              .map((opt) => opt.name)
              .join("-")})`
            : raw_items[id_item].name
            }`,
          baseName: raw_items[id_item].name,
          id: Number(id_item),
          price: (options.length
            ? options
              .map((i) => i.price)
              .reduce((accumulator, curr) => accumulator + curr) +
            raw_items[id_item].last_price
            : raw_items[id_item].last_price) * 1000,
          options: options,
          vat_include: raw_items[id_item].vat_include,
          unique: `${id_item}-${options.length
            ? `${raw_items[id_item].name}(${options
              .map((opt) => opt.name)
              .join("-")})`
            : raw_items[id_item].name
            }`,
        },
        count: order["items"][item]["qty"],
        note: order["items"][item]["note"] ? order["items"][item]["note"] : "",
        custom_fields: order?.["order"]?.["custom"] || null,
      },
    ];
  });
  return newOrder;
};

export const setOrderStatus = (order_id, status): Promise<string> => {
  return new Promise((resolve, reject) => {
    const client_id = localStorage.getItem("user_client_id");
    const token = localStorage.getItem("token");

    var data = new FormData();
    data.append("token", token);
    data.append("client_id", client_id);
    data.append("order_id", order_id);
    data.append("status", status);

    const config: AxiosRequestConfig = {
      method: "post",
      url: "/set-order-status",
      data,
    };
    axios(config)
      .then(function (response) {
        resolve(response.data);
      })
      .catch((error) => reject(error));
  });
};
export const removeOrder = (order_id): Promise<string> => {
  return new Promise((resolve, reject) => {
    const client_id = localStorage.getItem("user_client_id");
    const token = localStorage.getItem("token");

    var data = new FormData();
    data.append("token", token);
    data.append("client_id", client_id);
    data.append("order_id", order_id);

    const config: AxiosRequestConfig = {
      method: "post",
      url: "/remove-order",
      data,
    };
    axios(config)
      .then(function (response) {
        resolve(response.data);
      })
      .catch((error) => reject(error));
  });
};
export const printAllOrders = (
  orders,
  pageWidth,
  startDate,
  endDate,
  borderSize,
  fontSize,
  totalAmount,
  printers
): Promise<string> => {
  return new Promise((resolve, reject) => {
    const config: AxiosRequestConfig = {
      method: "post",
      baseURL: basUrl,
      url: "print-all-order",
      // url: "api/test",
      headers: {
        "Content-Type": "application/json",
      },
      data: JSON.stringify({
        orders,
        pageWidth,
        startDate,
        endDate,
        borderSize,
        fontSize,
        totalAmount,
        printers,
      }),
    };
    axios(config)
      .then(function (response) {
        resolve(response.data);
      })
      .catch((error) => reject(error));
  });
};
