import axios, { AxiosRequestConfig } from "axios";

export const getOnlineBranchData = (): Promise<string> => {
  return new Promise((resolve, reject) => {
    const token = localStorage.getItem("token");
    const branchName = localStorage.getItem('branch_name');

    var data = new FormData();
    data.append("token", token);
    data.append("branch_name", branchName);

    const config: AxiosRequestConfig = {
      method: "post",
      url: "/get-branch-data",
      data,
    };
    axios(config)
      .then(function (response) {
        resolve(response.data);
      })
      .catch((error) => reject(error));
  });
};
