import express, { Request, Response } from "express";
import IMenuItem from "interfaces/menuItem";
import morgan from "morgan";
import next from "next";
import path from "path";
import pdf from "pdf-creator-node";
import ptp from "pdf-to-printer";
import { printLocal, saveBill, saveBill5 } from "../helpers/downloader";
import {
  billStyle,
  footer,
  headerStart,
  headerTemplate,
  headerTemplateDynamic,
  htmlStart,
  htmlStart2,
  tableHeader,
  tableStart,
  tableStart2,
} from "./../helpers/bill-template";

import basUrl from "../baseU.js";

// const dev = process.env.NODE_ENV !== 'production'
const dev = false;
const app = next({ dev });
const handle = app.getRequestHandler();
function formatPrice2(price: number) {
  let price2 = price.toFixed();
  let formattedPrice = price2.replace(/\B(?=(\d{3})+(?!\d))/g, ",");
  return formattedPrice;
}
function roundFinalPrice(totalPrice) {
  let text = (parseFloat(totalPrice) * 1000).toFixed();
  let replacement = "00";
  let result = text.substring(0, text.length - 2) + replacement;
  let finalPrice = parseInt(result) / 1000;
  return finalPrice;
}
const save_pdf = async (htmlContent, filePath, printers) => {
  var document = {
    html: htmlContent,
    path: filePath,
    data: {},
    type: "",
  };
  pdf
    .create(document, {
      width: "8cm",
      height: "29.7cm",
      timeout: "100000",
      // border: {
      //   top: '0cm',
      //   left: '1cm',
      //   right: '1cm',
      // }
    })
    .then((rs) => {
      // let printer = ptp.getDefaultPrinter()
      for (let i = 0; i < printers.length; i++) {
        const options = {
          printer: printers[i],
          unix: ["-o fit-to-page"],
          win32: ['-print-settings "noscale"'],
        };
        ptp
          .print(filePath, options)
          .then((res) => {
            return res;
          })
          .catch((err) => {
            return err;
          });
      }

      // return res.json({ success: true })
      // console.log(rs);
    })
    .catch((error) => {
      // return res.json({ success: false })
      console.log(error);
    });
};
const port = 3000;

(async () => {
  try {
    await app.prepare();
    const server = express();
    server.use(express.json());
    server.use(morgan("dev"));
    server.use((req, res, next) => {
      res.setHeader("Access-Control-Allow-Origin", "*");
      next();
    });

    // returns a list of all the available printers to the OS back to the client
    server.get("/getprinters", (req, res) => {
      ptp
        .getPrinters()
        .then((printers) => res.json({ printers }))
        .catch((err) => res.status(500).json({ err }));
    });

    server.get("/printLocal", async (req, res) => {
      const { page, order_id, printer } = req.query;
      printLocal(page, order_id, printer)
        .then(() => {
          return res.json({ success: true });
        })
        .catch((err) => {
          res.statusCode = 402;
          return res.json({ success: false });
        });
    });

    server.get("/printChangeTable", async (req, res) => {
      const { prewTable, nextTable, printer, phone, no_brand, branchName } = req.query;
      let htmlContent: string = `
      ${billStyle}
      ${htmlStart}
      ${headerTemplateDynamic(null, null, null, null, no_brand, branchName)}
      `;

      htmlContent += `<h3>ویرایش میز</h3>
      <table class="table table-bordered text-center">
        <thead>
          <tr class="c-head">
            <th style="padding:5px;border:3px solid #000;font-size:12px;font-weight:bold;font-family:tahoma;width:30%;">میز قبلی</th>
            <th style="padding:5px;border:3px solid #000;font-size:12px;font-weight:bold;font-family:tahoma;width:30%;">میز جدید</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td style="padding:5px;border:3px solid #000;font-size:12px;font-weight:bold;font-family:tahoma;width:30%;">${prewTable}</td>
            <td style="padding:5px;border:3px solid #000;font-size:12px;font-weight:bold;font-family:tahoma;width:30%;">${nextTable}</td>
          </tr>
        </tbody>
      </table>`;

      htmlContent += `${footer(phone ? phone : "", no_brand, branchName)}`;

      const filePath = path.join(
        "bills",
        `${prewTable + "-" + nextTable}-p2.pdf`
      );

      var document = {
        html: htmlContent,
        path: filePath,
        data: {},
        type: "",
      };

      pdf
        .create(document, {
          width: "8cm",
          height: "29.7cm",
          // border: {
          //   top: '0cm',
          //   left: '1cm',
          //   right: '1cm',
          // }
        })
        .then((rs) => {
          const options = {
            printer: printer.toString(),
            unix: ["-o fit-to-page"],
            win32: ['-print-settings "noscale"'],
          };
          ptp
            .print(filePath, options)
            .then((res) => {
              return res;
            })
            .catch((err) => {
              return err;
            });
          return res.json({ success: true });
        })
        .catch((error) => {
          return res.json({ success: false });
        });
    });

    // Receives a print request
    server.post("/print", async (req, res) => {
      const { printers, orderId } = req.body;
      saveBill(printers, orderId)
        .then(() => {
          return res.json({ success: true });
        })
        .catch((err) => {
          return res.json({ success: false });
        });
    });

    // Receives a print request
    server.post("/print1", async (req, res) => {
      const { printer_id, pinter_name, pdf_url, status, orderId } = req.body;

      var _the_bill = {
        id: printer_id,
        name: pinter_name,
        page: pdf_url,
        status: status,
      };

      saveBill5(_the_bill, orderId)
        .then(() => {
          return res.json({ success: true });
        })
        .catch((err) => {
          return res.json({ success: false });
        });
    });

    server.post("/submit-order", async (req, res) => {
      let {
        customer,
        order,
        totalAmount,
        printers,
        offline_id,
        custom_print_valuet,
        raw_items,
        table_id,
        factorID,
        discount,
        print_type,
        p_bill,
        p_bar,
        phone,
        note,
        numPeople,
        borderSize,
        fontSize,
        pageWidth,
        service,
        reprint,
        tip,
        taxPrice,
        loviuna,
        no_brand,
        branchName,
        isOnline,
        custom_note,
        customFields,
      } = req.body;

      // ignore removed items
      order = order.filter((o: any) => !o.remove);

      const keyPrinterBehaves = {
        "پرینت مشتری": 4,
        "بدون پرینت": 3,
        "پرینت باریستا": 2,
        "پرینت مشتری و باریستا": 1,
      };

      let printType = keyPrinterBehaves[print_type];
      if (printType == 3) return res.json({ success: true });

      let customerName = customer.name
        ? customer.name.split("-")[1].replace("_", " ")
        : "";

      let customerMobile = customer.name
        ? customer.name.split("-")[0]
        : "";

      let htmlContent: string = `${billStyle}${htmlStart2(
        pageWidth
      )}${headerTemplateDynamic(
        factorID,
        customerName,
        1,
        reprint,
        no_brand,
        branchName,
        isOnline,
        customerMobile,
        JSON.parse(customFields),
      )}${tableStart(borderSize, fontSize, pageWidth)}`;
      let htmlContent2: string = `${billStyle}${htmlStart2(
        pageWidth
      )}${headerTemplateDynamic(
        factorID,
        customerName,
        0,
        reprint,
        no_brand,
        branchName,
        isOnline,
        customerMobile,
        JSON.parse(customFields),
      )}${tableStart2(borderSize, fontSize, pageWidth)}`;

      order.forEach((item) => {
        let count = item.count;
        if (item.old_qty) {
          if (item.old_qty == item.count && printType != 4 && !item.remove)
            return;
          if (printType != 4) {
            let new_count = item.count - item.old_qty;
            if (item.remove) count = 0;
            else
              count =
                item.count +
                "/" +
                (new_count > 0 ? "+" + new_count : new_count);
          }
        }
        htmlContent += `
            <tr class="">
              <td style="width:42%;padding:5px;border:${borderSize}px solid #000;font-size:${fontSize}px;font-weight:bold;font-family:tahoma"class="c-name">${item.product.name
          }</td>
              <td style="width:10%;padding:5px;text-align:center;border:${borderSize}px solid #000;font-size:${fontSize}px;font-weight:bold;font-family:tahoma"class="c-qty">
              ${item.count}
              </td>
              <td style="text-align:center;padding:5px;border:${borderSize}px solid #000;font-size:${fontSize}px;font-weight:bold;font-family:tahoma;"class="c-price">${item.product.price / 1000
          }</td>
            <td style="text-align:center;padding:5px;border:${borderSize}px solid #000;font-size:${fontSize}px;font-weight:bold;font-family:tahoma;"class="c-price">${(item.count * item.product.price) / 1000
          }</td></tr>
            `;
        htmlContent2 += `
            <tr class="">
            <td style="width:90%;padding:5px;border:${borderSize}px solid #000;font-size:${fontSize}px;font-weight:bold;font-family:tahoma"class="c-name">${item.product.name + (item.note ? `<hr>${item.note}` : "")
          }</td>
            <td style="width:10%;padding:5px;text-align:center;border:${borderSize}px solid #000;font-size:${fontSize}px;font-weight:bold;font-family:tahoma"class="c-qty">
            ${count}</td>
            </tr>
            `;
      });

      let foot =
        (note ? `<h4 style="white-space: break-spaces;">توضیحات: ${note}</h4>` : "") +
        (numPeople ? `<h4>تعداد نفرات: ${numPeople}</h4>` : "");
      // customer data
      // { id: 0, name: '123-ashkan' }
      totalAmount = totalAmount.replace(" تومان", "");
      totalAmount = totalAmount.replace(/,/g, "");
      totalAmount = roundFinalPrice(totalAmount);
      if (totalAmount == .1)
        totalAmount = 0;

      taxPrice *= 10;

      let loviunaDiscount = loviuna_discount ? Number(loviuna_discount * .1) : 0;
      if (loviuna) {
        var loviuna_discount = Number(loviuna['price']) * 10000;
        // console.log('we have loviuna.....' + taxPrice + " " + loviuna_discount);
        taxPrice += (loviunaDiscount);
      }
      //return;
      htmlContent += `
        
      ${taxPrice > 0
          ? `  
      <tr class="summary bgorgm" style="">
      <td style="font-weight:bold;padding:5px;border:${borderSize}px solid #000;font-family:tahoma;font-size:${fontSize}px;"
      class="total-action"colspan="5"><label>مالیات بر ارزش افزوده VAT::</label>
      <span class="total" style="float:left;">${formatPrice2(taxPrice)}</span>
      </td> </tr>`
          : ""
        }
      
        ${!loviuna
          ? `  <tr class="summary bgorgm" style="">
          <td style="font-weight:bold;padding:5px;border:${borderSize}px solid #000;font-family:tahoma;font-size:${fontSize}px;"
          class="total-action"colspan="5"><label>پرداخت از اعتبار باشگاه </label>
          <span class="total" style="float:left;">Loviuna:${formatPrice2(0)}</span>
          </td> </tr>`
          : `
        <tr class="summary bgorgm" style="">
        <td style="font-weight:bold;padding:5px;border:${borderSize}px solid #000;font-family:tahoma;font-size:${fontSize}px;"
        class="total-action"colspan="5"><label>جمع صورت حساب:</label>
        <span class="total" style="float:left;">${formatPrice2((Number(loviuna['price']) * 10000) + (totalAmount) + loviunaDiscount)}</span>
        </td> </tr>  
        <tr class="summary bgorgm" style="">
        <td style="font-weight:bold;padding:5px;border:${borderSize}px solid #000;font-family:tahoma;font-size:${fontSize}px;"
        class="total-action"colspan="5">
        <label style="float:right">پرداخت ار اعتبار باشگاه <br> ${loviuna['name']}</label>
        
        <span class="total" style="float:left"><span style="    position: relative;
        left: -4px;">Loviuna</span><br>${formatPrice2(Number(loviuna['price']) * 10000 + loviunaDiscount)}-</span>
        </td> </tr> `
        }
        
       


        ${discount > 0
          ? `  
        <tr class="summary bgorgm" style="">
        <td style="font-weight:bold;padding:5px;border:${borderSize}px solid #000;font-family:tahoma;font-size:${fontSize}px;"
        class="total-action"colspan="5"><label>تخفیف:</label>
        <span class="total" style="float:left;">${formatPrice2(discount)}</span>
        </td> </tr>`
          : ""
        }
        ${service > 0
          ? `  
        <tr class="summary bgorgm" style="">
        <td style="font-weight:bold;padding:5px;border:${borderSize}px solid #000;font-family:tahoma;font-size:${fontSize}px;"
        class="total-action"colspan="5"><label>حق سروریس:</label>
        <span class="total" style="float:left;">${formatPrice2(service)}</span>
        </td> </tr>`
          : ""
        }
        ${tip > 0
          ? `  
        <tr class="summary bgorgm" style="">
        <td style="font-weight:bold;padding:5px;border:${borderSize}px solid #000;font-family:tahoma;font-size:${fontSize}px;"
        class="total-action"colspan="5"><label>tip:</label>
        <span class="total" style="float:left;">${formatPrice2(tip)}</span>
        </td> </tr>`
          : ""
        }
        
        <tr class="summary bgorgm" style="">
        <td style="font-weight:bold;padding:5px;border:${borderSize}px solid #000;font-family:tahoma;font-size:${fontSize}px;"
        class="total-action"colspan="5"><label>جمع قابل پرداخت:</label>
        <span class="total" style="float:left;">${formatPrice2(
          totalAmount
        )} ریال</span>
        </td>
        </tr>
        <tr></tr></table>${(table_id ? `<h2>شماره میز: ${table_id}</h2>\n` : "\n") +
        `<h6>${offline_id}</h6>` +
        (note ? `<h6 style="white-space: break-spaces;">توضیحات: ${note}</h6>\n` : "\n") +
        (custom_note ? (`<h6 style="white-space: break-spaces;margin-bottom:1rem">${custom_note}</h6>\n`) : '\n') +
        footer(phone, no_brand, branchName)
        }`;

      htmlContent2 += `</table>${(table_id ? "<h2>شماره میز: " + table_id + "</h2>" : "") + foot
        }`;

      let setPrinter = [];
      let setPrinter2 = [];
      if (printers["p1"]) setPrinter.push(printers["p1"]);
      // if (printers["p0"]) setPrinter.push(printers["p0"]);

      ["p2", "p3", "p4", "p5"].map((item) => {
        if (printers[item]) setPrinter2.push(printers[item]);
      });
      if ([1, 4].includes(printType))
        save_pdf(
          htmlContent,
          path.join("bills", `${offline_id}.pdf`),
          setPrinter
        );

      if (printType == 4) return res.json({ success: true });

      setPrinter = [];

      save_pdf(
        htmlContent2,
        path.join("bills", `${offline_id}_k.pdf`),
        setPrinter2
      );

      if (p_bill && printers["p" + p_bill])
        save_pdf(
          htmlContent,
          path.join("bills", `${offline_id}_p${p_bill}.pdf`),
          [printers["p" + p_bill]]
        );
      if (p_bar && printers["p" + p_bar])
        save_pdf(
          htmlContent2,
          path.join("bills", `${offline_id}_k_p${p_bar}.pdf`),
          [printers["p" + p_bar]]
        );

      let PO = {};
      let temp = [];

      Object.keys(custom_print_valuet).forEach((i) => {
        temp = [];
        order.map((item, index) => {
          if (
            custom_print_valuet[i].cat &&
            (custom_print_valuet[i].cat.length || [])
          ) {
            if (
              custom_print_valuet[i].cat.includes(
                raw_items[item.product.id].category_id.toString()
              )
            ) {
              let count = item.count;
              if (item.old_qty) {
                if (item.old_qty == item.count) return;
                let new_count = item.count - item.old_qty;
                count =
                  item.count +
                  "/" +
                  (new_count > 0 ? "+" + new_count : new_count);
              }
              temp.push(`
                <tr class="">
                <td style="width:90%;padding:5px;border:${borderSize}px solid #000;font-size:${fontSize}px;font-weight:bold;font-family:tahoma"class="c-name">${item.product.name + (item.note ? `<hr>${item.note}` : "")
                }</td>
                <td style="width:10%;padding:5px;text-align:center;border:${borderSize}px solid #000;font-size:${fontSize}px;font-weight:bold;font-family:tahoma"class="c-qty">
                ${count}</td>
                </tr>
                `);
              PO[i] = temp;
              return;
            }
          }
        });
      });
      Object.keys(PO).forEach((i) => {
        setPrinter = [];
        htmlContent2 = `${billStyle}${htmlStart2(pageWidth)}${headerTemplateDynamic(factorID, customerName, 0, reprint, no_brand,
          branchName, isOnline) +
          "<h4>" +
          custom_print_valuet[i].name +
          "</h4>"
          }${tableStart2(borderSize, fontSize, pageWidth)}`;
        PO[i].map((item) => {
          htmlContent2 += item;
        });
        htmlContent2 += `</table>${(table_id ? "<h2>شماره میز: " + table_id + "</h2>" : "") + foot
          }`;
        if (printers[i]) setPrinter.push(printers[i]);
        save_pdf(
          htmlContent2,
          path.join("bills", `${offline_id}_k_${i}.pdf`),
          setPrinter
        );
      });
      return res.json({ success: true });
    });
  
    server.post("/print-all-order", async (req, res) => {
      let {
        orders,
        pageWidth,
        startDate,
        endDate,
        borderSize,
        fontSize,
        totalAmount,
        printers,
      } = req.body;

      let htmlContent: string = `${billStyle}${headerStart(
        pageWidth,
        startDate,
        endDate
      )}${tableHeader(borderSize, fontSize, pageWidth)}`;

      for (const item of orders) {
        let date = "";
        if (item["date"]) {
          date = item["date"].split(" ")[1];
        }
        htmlContent += `
            <tr class="">
              <td style="width:42%;padding:5px;border:${borderSize}px solid #000;font-size:${fontSize}px;font-weight:bold;font-family:tahoma"class="c-name">${item._id}</td>
              <td style="width:10%;padding:5px;text-align:center;border:${borderSize}px solid #000;font-size:${fontSize}px;font-weight:bold;font-family:tahoma"class="c-qty">
              ${date}
              </td>
              <td style="text-align:center;padding:5px;border:${borderSize}px solid #000;font-size:${fontSize}px;font-weight:bold;font-family:tahoma;"class="c-price">${item.total}</td>
            </tr>
            `;
      }
      // customer data
      // { id: 0, name: '123-ashkan' }
      htmlContent += `
        <tr class="summary bgorgm" style="">
          <td style="font-weight:bold;padding:5px;border:${borderSize}px solid #000;font-family:tahoma;font-size:${fontSize}px;"
          class="total-action" colspan="3"><label>جمع کل:</label>
          <span class="total" style="float:left;">${totalAmount}</span>
          </td>
        </tr>
        </table>
     `;

      let setPrinter = [];
      setPrinter.push(printers["p1"]);
      save_pdf(htmlContent, path.join("bills", `all_factor.pdf`), setPrinter);
      return res.json({ success: true });
    });
    // The save route is responsible for saving an offline version of each product level
    // including the images
    server.post("/save", async (req, res) => {
      const items: IMenuItem[] = req.body;
      // saveLocal(items).then((resp) => {
      // })
      return res.json({ success: true });
    });

    server.all("*", (req: Request, res: Response) => {
      return handle(req, res);
    });

    server.listen(port, (err?: any) => {
      if (err) throw err;
      // console.log(`> Ready on ${basUrl}`);
      require("child_process").exec(`start ${basUrl}`);
    });
  } catch (e) {
    console.error(e);
    process.exit(1);
  }
})();
