import apiUrl from "apiUrl";
import { useProductContext } from "components/Products";
import { formatPrice, roundFinalPrice } from "helpers/format";
import { requestPrintOffline, saveMaterialLogs } from "helpers/offline";
import Link from "next/link";
import { useRouter } from "next/router";
import { Fragment, useEffect, useState } from "react";
import { toast } from "react-toastify";
import {
  findOrder,
  getOnlineOrderData,
  removeOrder,
  saveOrderOffline,
  setOrderStatus,
} from "services/order";
import Table from "../components/Table";
import {
  changeTable,
  getDetail,
  getPrintLocal,
  getRawItems,
  getTable,
  getTable2,
  printChangeTable,
  requestPrintTablet,
  requestRepeatPrint,
} from "../services/table";
import { useCustomRefresh } from "components/contexts/RefreshContext";

const tables = () => {
  const { customRefresh } = useCustomRefresh();
  const [showTab, setShowTab] = useState("");
  const [tables, setTables] = useState({});
  const [newTables, setNewTable] = useState({});
  const [tableFullSelected, setTableFullSelected] = useState("");
  const [tableEmptySelected, setTableEmptySelected] = useState("");
  const [check, setCheck] = useState(false);
  const [page, setPage] = useState(1);
  const [pages, setPages] = useState(0);
  const [tbl1, setTbl1] = useState("");
  const [tbl2, setTbl2] = useState("");
  const router = useRouter();

  const { setDetailEditOrder, setOrder, offline, warehouse, interval, refresh, setRefresh } = useProductContext();

  useEffect(() => {
    updateTables();
    console.log("reeeeeeeeeeeeeeeeeeeeeeeeeeefresh");
    
  }, [refresh, customRefresh]);

  useEffect(() => {
    const timer = setInterval(() => {
      let s = localStorage.getItem('refresh') ?? '0';
      if (s != refresh)
        setRefresh(s);
    }, 100);
    return () => clearInterval(timer);
  }, []);

  const showErrNetwork = () => {
    toast("اتصال به سرور بر قرار نشد .", {
      position: "bottom-right",
      type: "error",
      style: { direction: "rtl", fontFamily: "IRANSansX" },
      theme: "colored",
    });
  };

  const showMsgSuccess = () => {
    toast("عملیات موفقیت امیز بود .", {
      position: "bottom-right",
      type: "success",
      style: { direction: "rtl", fontFamily: "IRANSansX" },
      theme: "colored",
    });
  };

  const pushTable = (res, _page?: any) => {
    let data = res;

    findOrder({
      status: 6,
    }).then((orders) => {
      Object.keys(res).forEach((salon) => {
        if ((orders["order"] || []).length) {
          let temp = {};
          temp[salon] = [];
          setCheck(true);
          orders["order"].map((order) => {
            let details = JSON.parse(order["order_details"]).detail;
            details.local_id = order._id;
            details.final_price = order.total * 1000;
            details.status_raw = order.status;
            details.flag = order.flag ? order.flag : 0;
            details.online_table_id = order.online_table_id
              ? order.online_table_id
              : "";
            details.date_orginal = order.date;
            details.table_id = order.table_id;
            if (salon == "no_table" && !order.table_id) {
              temp[salon].push([details]);
            }
            if (data[salon][order.table_id]) {
              data[salon][order.table_id] = [details];
            }
          });
          if (temp[salon].length) data[salon] = temp[salon];
        }
      });
    });
    let limit = 20;
    let skip = 0;

    if (page) skip = ((_page ? _page : page) - 1) * limit;
    findOrder({
      status: 0,
      limit: limit,
      skip: skip,
    }).then((orders) => {
      data["settled"] = [];
      orders["order"].map((order) => {
        let details = JSON.parse(order["order_details"]).detail;
        details.local_id = order._id;
        details.final_price = order.total * 1000;
        details.status_raw = order.status;
        data["settled"].push([details]);
      });
    });
    findOrder({
      status: 0,
      count: 1,
    }).then((c) => {
      let _pages = c["order"] > 0 ? Math.ceil(c["order"] / limit) : 0;
      setPages(_pages);
    });
    findOrder({
      status: -2,
    }).then((orders) => {
      data["suspended"] = [];
      orders["order"].map((order) => {
        let details = JSON.parse(order["order_details"]).detail;
        details.local_id = order._id;
        details.final_price = order.total * 1000;
        details.status_raw = order.status;
        data["suspended"].push([details]);
      });
    });
    setNewTable(data);
    interval();
  };
  useEffect(() => {
    if (!tableFullSelected || !tableEmptySelected) return;
    // if (offline) {
    //   // change tables offline mode
    //   let tablesNow = localStorage.getItem("tables") || "{}";
    //   tablesNow = JSON.parse(tablesNow);
    //   let tableFull, nameTableFull;

    //   Object.keys(tablesNow).forEach(salon => {
    //     Object.keys(tablesNow[salon]).forEach(table => {
    //       if (tablesNow[salon][table].length) {
    //         if (tablesNow[salon][table][0]['id'] == tableFullSelected) {
    //           tableFull = tablesNow[salon][table][0];
    //           nameTableFull = table;

    //           if (salon == 'no_table') {
    //             delete tablesNow[salon][table];
    //           }
    //           else {
    //             tablesNow[salon][table] = [];
    //           }
    //         }
    //       }
    //     })
    //   })
    //   Object.keys(tablesNow).forEach(salon => {
    //     Object.keys(tablesNow[salon]).forEach(table => {
    //       if (table == tableEmptySelected) {
    //         tablesNow[salon][table] = [{ ...tableFull, table_id: tablesNow[salon][table]['table_id'] }];
    //       }
    //     })
    //   })
    //   setTableEmptySelected("");
    //   setTableFullSelected("");

    //   setQuery('changeTable', tableFullSelected, tableEmptySelected, '');
    //   printChangeTable(nameTableFull, tableEmptySelected);

    //   setTables(tablesNow);
    // }

    changeTable(tableFullSelected["id"], tableEmptySelected)
      .then(async (res) => {
        let data = await getDataTable();
        updateTables(data);

        printChangeTable(tableFullSelected["table_id"], tableEmptySelected);
        showMsgSuccess();
      })
      .catch((err) => {
        if (err == undefined || err == null) return;
        showErrNetwork();
      })
      .finally(() => {
        setTableEmptySelected("");
        setTableFullSelected("");
      });
  }, [tableFullSelected, tableEmptySelected]);

  const getDataTable = () => {
    let res;
    // set tables offline mode
    let data = localStorage.getItem("tables") || "{}";
    data = JSON.parse(data);
    res = data;
    data["settled"] = [];
    setTables(data);
    localStorage.getItem("activeTab")
      ? null
      : localStorage.setItem("activeTab", Object.keys(data)[0]);
    setShowTab(localStorage.getItem("activeTab"));
    let s = localStorage.getItem("salon");
    if (!s || s == "null")
      getTable2().then((r) => {
        localStorage.setItem("salon", JSON.stringify(r));
      });
    if (!localStorage.getItem("tables")) {
      getTable()
        .then((data) => {
          data["settled"] = [];
          setTables(data);

          res = data;
          Object.keys(localStorage).map((item) => {
            // clear ditails order old
            if (item.split("-")[0] == "order") {
              localStorage.removeItem(item);
            }
          });

          localStorage.getItem("activeTab")
            ? null
            : localStorage.setItem("activeTab", Object.keys(data)[0]);
          setShowTab(localStorage.getItem("activeTab"));
        })
        .catch((err) => {
          showErrNetwork();
        });
    }
    return res;
  };
  const saveLocalyDetailOrder = async (id) => {
    // if (offline) {
    //   if (localStorage[`order-${id}`]) {
    //     return;
    //   }
    // }
    // getDetail(id)
    //   .then((res) => {
    //     // localStorage.setItem(`order-${res["detail"].id}`, JSON.stringify(res));
    //   })
    //   .catch((err) => {
    //     return;
    //   });
  };
  const getDetailOrder = async (id) => {
    getDetail(id)
      .then((res) => {
        renderDetailsOrderInCart(res);
      })
      .catch((err) => {
        showErrNetwork();
      });
  };
  const renderDetailsOrderInCart = (
    order,
    repeatPrint?: any,
    orderObj?: any,
    reprint?: any,
    print_type?: any
  ) => {
    if (repeatPrint != 1) setDetailEditOrder(order);

    let newOrder = getNewOrder(order);
    if (repeatPrint != 1) {
      setOrder([...newOrder]);
      router.push("/");
    } else {
      // console.log('hk1');
      repeatPrintOffline(
        order,
        newOrder,
        orderObj,
        reprint ? reprint : 0,
        print_type ? print_type : ""
      );
    }
  };
  const getNewOrder = (order) => {
    let raw_items = localStorage.getItem("raw_items") || "[]";
    raw_items = JSON.parse(raw_items);

    let newOrder = [];

    Object.keys(order["items"]).map((item) => {
      let id_item = item.split("_")[0];

      let options = [];
      if (order["items"][item]["options"] != null) {
        const opts = JSON.parse(order["items"][item]["options"] || "[]");
        for (const opt of opts) {
          options.push({
            id: opt,
            name: raw_items[opt]["name"],
            price: raw_items[opt]["last_price"],
            image: apiUrl[0] + "/",
          });
        }
      }
      //console.log(options);
      /*console.log(options
        .map((i) => i.price)
        .reduce((accumulator, curr) => accumulator + curr)); */




      /*

              (options.length
              ? options
                .map((i) => i.price)
                .reduce((accumulator, curr) => accumulator + curr) +
              raw_items[id_item].last_price
              : raw_items[id_item].last_price) * 1000,

      */
      newOrder = [
        ...newOrder,
        {
          product: {
            name: `${options.length
              ? `${raw_items[id_item].name}(${options
                .map((opt) => opt.name)
                .join("-")})`
              : raw_items[id_item].name
              }`,
            baseName: raw_items[id_item].name,
            id: Number(id_item),
            price:
              (options.length
                ? Number(options
                  .map((i) => i.price)
                  .reduce((accumulator, curr) => accumulator + curr)) +
                Number(raw_items[id_item].last_price)
                : raw_items[id_item].last_price) * 1000,
            options: options,
            vat_include: raw_items[id_item].vat_include,
            unique: `${id_item}-${options.length
              ? `${raw_items[id_item].name}(${options
                .map((opt) => opt.name)
                .join("-")})`
              : raw_items[id_item].name
              }`,
          },
          count: order["items"][item]["qty"],
          note: order["items"][item]["note"]
            ? order["items"][item]["note"]
            : "",
        },
      ];
    });
    // console.log(newOrder);
    return newOrder;
  };
  const repeatPrintOffline = async (
    order,
    newOrder,
    orderObj,
    reprint,
    print_type?
  ) => {
    const orderId = order["detail"].id;
    const tableId = order["detail"].table_id;
    let totalAmount = 0;

    newOrder.map((item) => {
      // console.log(item.product.name);
      // console.log(item.product.price);
      totalAmount += item.product.price * item.count;
    });

    let price = totalAmount;
    let discount = orderObj.discount;
    if (discount) totalAmount -= parseInt(discount);
    if (orderObj.service) totalAmount += parseInt(orderObj.service);
    if (orderObj.tip) totalAmount += parseInt(orderObj.tip);
    if (orderObj.tax) totalAmount += orderObj.tax;
    if (orderObj.loviuna && orderObj.loviuna['price']) totalAmount -= orderObj.loviuna['price'] * 1000;

    // const totalAmount = orderObj.total;
    const factorID = orderObj._id;
    let customer = { name: "", id: -1 };
    if (order["detail"].user_name)
      customer = { name: order["detail"].user_name, id: 0 };
    // submitOrderLocally(
    //   newOrder, customer, totalAmount, "پوز", order["detail"].customerNote, true, orderId, order["detail"].numPeople, tableId,
    //   detailEditOrder, setDetailEditOrder, useDiscount
    // )
    if ((orderObj.status == 1 || orderObj.status == 2) && !print_type) {
      saveOrderOffline({
        id: orderObj.offline_id,
        status: 4,
      }).then(() => updateTables());
    }
    if (!print_type) print_type = "پرینت مشتری و باریستا";
    let salon = JSON.parse(localStorage.getItem("salon"));
    let p_bill = null;
    let printer = null;
    if (salon != "null" && salon[order.salon])
      p_bill = salon[order.salon]["p_bill"];
    if (order.printer) printer = order.printer;
    totalAmount = roundFinalPrice(totalAmount);

    let customFields = "{}";

    if (!isNaN(orderObj.offline_id)) {
      const order_res = await getOnlineOrderData(orderObj.offline_id) as any;
      if (order_res?.order?.custom) customFields = JSON.stringify(order_res.order.custom);
    }

    saveOrderOffline({
      id: orderObj.offline_id,
      total: totalAmount,
      price: price,
    }).then(() => {
      updateTables();


      requestPrintOffline(
        newOrder,
        customer,
        formatPrice(totalAmount),
        orderId,
        factorID,
        discount,
        tableId,
        print_type,
        p_bill,
        printer,
        orderObj.note,
        "",
        order["detail"].service,
        reprint,
        orderObj.tip ? orderObj.tip : null,
        orderObj.tax,
        orderObj.loviuna,
        orderObj['isOnline'],
        customFields,
      );
    });
  };

  const saveRawItems = () => {
    if (!localStorage.getItem("raw_items"))
      getRawItems()
        .then((res) => {
          localStorage.setItem("raw_items", JSON.stringify(res));
        })
        .catch((err) => {
          localStorage.setItem(
            "raw_items",
            localStorage.getItem("raw_items") || "{}"
          );
        });
  };
  const updateTables = (data?: any, _page?: any) => {
    if (!data) data = getDataTable();
    pushTable(data, _page ? _page : null);
  };
  const setStatus = (order_id, st_id, online?: any) => {
    saveOrderOffline({
      id: order_id,
      status: st_id,
    }).then((res) => {
      if (warehouse) saveMaterialLogs(res);
      updateTables();
      if (online == 1) {
        setOrderStatus(order_id, st_id);
      }
    });
    // if (offline) {
    //   // change status offline mode
    //   order_id[0].status_raw = st_id;
    //   if (st_id == 6) {
    //     order_id.pop();
    //   }
    //   setTables({ ...tables });
    //   setQuery('setStatus', order_id[0].id, '', st_id);

    //   return;
    // }
    // changeStatus(order_id[0].id, st_id)
    //   .then(async () => {
    //     await getDataTable();
    //     showMsgSuccess();
    //   })
    //   .catch(() => {
    //     showErrNetwork();
    //   });
  };
  const repeatPrint = (order_id) => {
    requestRepeatPrint(order_id)
      .then((res) => {
        showMsgSuccess();
      })
      .then((err) => {
        if (err == undefined || err == null) return;
        showErrNetwork();
      });
  };
  const printTablet = (order_id) => {
    requestPrintTablet(order_id)
      .then(async (res) => {
        await getDataTable();
        showMsgSuccess();
      })
      .then((err) => {
        if (err == undefined || err == null) return;
        showErrNetwork();
      });
  };
  const printLocal = (page, orderId) => {
    let printer = localStorage.getItem("p1") ? localStorage.getItem("p1") : "";
    getPrintLocal(page, orderId, printer)
      .then((res) => {
        setStatus(orderId, 4);
      })
      .catch((err) => {
        if (err == undefined || err == null) return;
        showErrNetwork();
      });
  };

  useEffect(() => {
    let res = getDataTable();
    pushTable(res);
    saveRawItems();
  }, []);

  useEffect(() => {
    if (Object.keys(tables).length) {
      // localStorage.setItem("tables", JSON.stringify(tables));
      if (!check) pushTable(tables);
    }
  }, [tables, newTables]);
  useEffect(() => {
    // console.log(`tbl1: ${tbl1}`);
    // console.log(`tbl2: ${tbl2}`);
  }, [tbl1, tbl2]);
  const mergeTable = (tbl1, tbl2) => {
    findOrder({ offline_id: tbl2 }, 1).then((t2) => {
      let order2 = t2["order"];
      let local2 = JSON.parse(order2.order_local);
      let details2 = JSON.parse(order2.order_details);
      findOrder({ offline_id: tbl1 }, 1).then((t1) => {
        let order = t1["order"];
        if (order.flag == 1) {
          removeOrder(order.offline_id).then((res) => {
            if (res) {
              mergeTwoTable(order, order2, local2, details2, tbl1, tbl2, t1);
            }
          });
        } else {
          mergeTwoTable(order, order2, local2, details2, tbl1, tbl2);
        }
      });
    });
  };
  const print_merge_order = (order) => {
    let o = JSON.parse(order["order"].order_details);
    let local = JSON.parse(order["order"].order_local);
    o["detail"].table_id = order["order"].table_id;
    o["detail"].use_point = order["order"].use_point
      ? order["order"].use_point
      : false;
    o["detail"].user_point = order["order"].user_point
      ? order["order"].user_point
      : 0;
    o["detail"].service = order["order"].service ? order["order"].service : "";
    o["detail"].tip = order["order"].tip ? order["order"].tip : "";
    o["detail"].payment_card = order["order"].payment_card
      ? order["order"].payment_card
      : "";
    o["detail"].payment_pos = order["order"].payment_pos
      ? order["order"].payment_pos
      : "";
    o["detail"].payment_cash = order["order"].payment_cash
      ? order["order"].payment_cash
      : "";
    o["detail"].numPeople = local.numPeople ? local.numPeople : "";
    o["detail"].note = order["order"].note ? order["order"].note : "";

    renderDetailsOrderInCart(o, 1, order["order"], 1, "پرینت باریستا");
  };
  const mergeTwoTable = (
    order,
    order2,
    local2,
    details2,
    tbl1,
    tbl2,
    order_data?: any
  ) => {
    let local = JSON.parse(order.order_local);
    let details = JSON.parse(order.order_details);
    let item_id = [];
    let local1_key = {};

    local2.cart.map((item, key) => {
      let options_id = [];
      item.options.map((i) => options_id.push(i.id));
      let id =
        item.id +
        "_" +
        options_id
          .sort()
          .map((i) => i)
          .join("_");
      item_id.push(id);
      local1_key[id] = key;
    });
    local.cart.map((item) => {
      let options_id = [];
      item.options.map((i) => options_id.push(i.id));
      let id =
        item.id +
        "_" +
        options_id
          .sort()
          .map((i) => i)
          .join("_");
      if (!item_id.includes(id)) {
        local2.cart.push(item);
      } else {
        local2.cart[local1_key[id]].qty += item.qty;
      }
    });
    for (const key in details.items) {
      if (!details2.items[key]) {
        details2.items[key] = details.items[key];
      } else {
        details2.items[key].qty += details.items[key].qty;
        details2.items[key].total_price += details.items[key].total_price;
      }
    }
    order2.price += order.price;
    order2.discount += order.discount;
    order2.total += order.total;
    if (order2.service || order.service)
      order2.service = parseInt(order2.service) + parseInt(order.service);
    if (order2.payment_card || order.payment_card)
      order2.payment_card =
        parseInt(order2.payment_card) + parseInt(order.payment_card);
    if (order2.payment_pos || order.payment_pos)
      order2.payment_pos =
        parseInt(order2.payment_pos) + parseInt(order.payment_pos);
    if (order2.payment_cash || order.payment_cash)
      order2.payment_cash =
        parseInt(order2.payment_cash) + parseInt(order.payment_cash);

    order2.order_local = JSON.stringify(local2);
    order2.order_details = JSON.stringify(details2);
    delete order2._id;
    order2.id = order2.offline_id;

    findOrder({ offline_id: tbl1, removeOrder: 1 }, 1).then((r) => {
      if (r["order"].acknowledged === true) {
        saveOrderOffline(order2)
          .then((res) => {
            console.log(res);
            updateTables();
          })
          .then((e) => {
            setTbl1("");
            setTbl2("");
            toast.success('میز اول روی میز دوم ادغام گردید"', {
              position: "bottom-right",
              style: { direction: "rtl", fontFamily: "IRANSansX" },
              theme: "colored",
            });
            updateTables();
            if (order_data) print_merge_order(order_data);
          });
      }
    });
  };
  return (
    <section className="h-screen pt-32 pb-10">
      <div
        className="w-full"
        style={{ justifyContent: "center", display: "flex" }}
      >
        <div className="" style={{ width: "200px" }}>
          <button
            className="btn btn-accent w-full btn-sm text-sm"
            onClick={() => mergeTable(tbl1, tbl2)}
            disabled={tbl1 && tbl2 ? false : true}
          >
            ادغام میز
          </button>
        </div>
      </div>
      <div className="w-full text-yellow-700">
        <Link href="/">
          <a>بازگشت</a>
        </Link>
      </div>
      {Object.keys(newTables).length ? null : (
        <button className="btn btn-accent btn-sm text-sm loading mt-4">
          بروزرسانی
        </button>
      )}
      {showTab != "1" ? (
        <Fragment>
          <ul
            className="nav nav-tabs flex flex-row flex-wrap list-none border-b-0 pl-0 mb-4"
            id="tabs-tab3"
            role="tablist"
          >
            {Object.keys(newTables).map((table) => (
              <li className="nav-item" key={table}>
                <a
                  href="javascript:void(0)"
                  onClick={() => {
                    setShowTab(table);
                    localStorage.setItem("activeTab", table);
                    // console.log(newTables)
                  }}
                  className={`nav-link w-full block font-medium text-xs leading-tight uppercase border-x-0 border-t-0 border-b-2 border-transparent px-6 py-3 my-2 hover:border-transparent focus:border-transparent ${showTab == table ? "bg-blue-200" : "hover:bg-gray-100"
                    }`}
                >
                  {table == "null"
                    ? "بدون سالن"
                    : table == "no_table"
                      ? "بدون میز"
                      : table == "settled"
                        ? "تسویه شده"
                        : table == "suspended" ? 'معلق' : table}
                </a>
              </li>
            ))}
          </ul>
          <div className="tab-content">
            {Object.keys(newTables).map((salon) =>
              showTab == salon ? (
                <div
                  className="tab-pane pb-10 show active"
                  key={salon + "1"}
                  onClick={(e) => {
                    document
                      .querySelectorAll(".popup-options")
                      .forEach((el) => {
                        el.classList.add("hidden");
                      });
                  }}
                >
                  <div className="flex justify-between gap-4 flex-wrap">
                    <Table
                      salon={salon}
                      tables={newTables}
                      setTableFullSelected={setTableFullSelected}
                      tableFullSelected={tableFullSelected}
                      tableEmptySelected={tableEmptySelected}
                      setTableEmptySelected={setTableEmptySelected}
                      getDetailOrder={getDetailOrder}
                      setStatus={setStatus}
                      repeatPrint={repeatPrint}
                      printTablet={printTablet}
                      printLocal={printLocal}
                      setDetailEditOrder={setDetailEditOrder}
                      setOrder={setOrder}
                      saveLocalyDetailOrder={saveLocalyDetailOrder}
                      renderDetailsOrderInCart={renderDetailsOrderInCart}
                      offline={offline}
                      page={page}
                      setPage={setPage}
                      updateTables={updateTables}
                      pages={pages}
                      getNewOrder={getNewOrder}
                      tbl1={tbl1}
                      setTbl1={setTbl1}
                      tbl2={tbl2}
                      setTbl2={setTbl2}
                      mergeTable={mergeTable}
                    />
                  </div>
                </div>
              ) : null
            )}
          </div>
        </Fragment>
      ) : null}
    </section>
  );
};

export default tables;
