import ErrorComponent from "components/shared/Error";
import ImageComponent from "components/shared/image-component";
import { getPrinters } from "helpers/printer";
import IPrinter from "interfaces/printer";
import Link from "next/link";
import { useRouter } from "next/router";
import { useContext, useEffect, useState } from "react";

import { Col, Row } from "antd";
import { useProductContext, ProductsStateContext } from "components/Products";
import { cartTotalPrice2, formatPrice, roundFinalPrice } from "helpers/format";
import { saveRawItems, submitOrderLocally, uploadOfflineOrders } from "helpers/offline";
import { toast } from "react-toastify";
import { createOrderData, findOrder, getOnlineOrderData, printAllOrders } from "services/order";
import { getPersianDate, numberFormat } from "services/persian";
import { getTable, getTable2, request, request2 } from "services/table";
import { getChildren, saveItemsOffline } from "helpers/check-items";
import io from "socket.io-client";
import { getOnlineBranchData } from "services/branch";
import { triggerRefresh } from "components/contexts/RefreshContext";

export const socketConnection = (client_type, router, acceptOrder) => {
  const playBellSound = async (order_id) => {
    const branch_data = await getOnlineBranchData() as any;
    const bellSound = new Audio("/audio/notif.mp3");
    bellSound.loop = !isNaN(branch_data?.repeat_alert) && branch_data?.repeat_alert == 1 ? true : false;
    let play = bellSound.play();
    let id = toast.success(order_id, {
      autoClose: false,
      hideProgressBar: true,
      position: "bottom-right",
      style: { direction: "rtl", fontFamily: "IRANSansX" },
      onClose: () => {
        bellSound.pause();
      },
    });
  };

  const socket = io("http://socket.cafe-viuna.com:9999", {
    reconnectionDelayMax: 10000
  });

  socket.on("connect_error", (err) => {
    console.log(`connect_error due to ${err.message}`);
  });

  socket.on('connect', () => {
    if (typeof window !== 'undefined') {
      let client_id = localStorage.getItem('user_client_id');
      if (client_id === null) {
        console.log('user client_id is Null');
      } else {
        socket.emit('joinRoom', client_id);
      }
    }
  });

  socket.on('disconnect', function () {
    console.log('user disconnect');
  });

  socket.off('joinRoom');
  socket.on('joinRoom', (roomInfo) => {
    console.log('joinRoom: ' + roomInfo);
  });

  socket.off('receiveOrder');
  socket.on('receiveOrder', (order_id) => {
    findOrder({
      offline_id: order_id[0]
    }, 1).then(o => {
      if (o['order'])
        return
      createOrder(order_id[0], 0).then(res => {
        if (!res)
          return true
        sendOrderSave(order_id[0]);
        playBellSound(order_id[1]);

        if (router.asPath == '/tables') {
          triggerRefresh();
        }

      })
    });
  });

  socket.off('receiveOrderUpdate');
  socket.on('receiveOrderUpdate', (order_id) => {
    acceptOrder(order_id[0])
  });

  socket.off('showMsg');
  socket.on('showMsg', (message) => {
    playBellSound(message[0]);
  });
};

const sendOrderSave = async (id) => {
  try {
    let res = await request2(`/saved-order?id=${id}`, 'get');
  } catch (error) {

  }
}

const createOrder = (order_id, update) => {
  return new Promise((resolve, _) => {
    getOnlineOrderData(order_id).then(res => {
      if (!res['order'].id) {
        resolve(false)
        return true
      }
      let order = createOrderData(res);

      let customer = res['customer'];
      let totalAmount = cartTotalPrice2(order)
      let paymentTypeDefault = localStorage.getItem("paymentType")
        ? localStorage.getItem("paymentType")
        : "پوز";
      let customFields = res['order']?.custom ? JSON.stringify(res['order'].custom) : "{}";
      let customerNote = res['order'].customer_note;
      let numPeople = res['order'].numPeople;
      let tableId = res['order'].table_id;
      let note = res['order'].note;
      let service = res['order'].service;
      let id = res['order'].id;
      let status = res['order']?.pay_status == 1 && res['order']?.payment_trans_id && res['order']?.status ? res['order']?.status : -1;
      const flag = res['order']?.pay_status == 1 && res['order']?.payment_trans_id ? 0 : 1;
      let useDiscount = {
        text: "انتخاب تخفیف",
        id: 0,
      };
      if (tableId && update != 1) {
        findOrder({
          status: 6,
          table_id: tableId
        }, 1).then((res) => {
          let online_table_id = '';
          if (res['order']) {
            online_table_id = tableId;
            note += (` شماره میز : ${tableId}`)
            tableId = ''
          }
          submitOrderLocally(order, customer, totalAmount, paymentTypeDefault, customerNote, false, (update == 1 ? id : 0),
            numPeople, tableId, {}, {}, useDiscount, note, 0, false, service, '',
            '', '', id, -1, 1, online_table_id, null, null, null, null, true, customFields
          ).then(res => {
            resolve(true)
          })
        })
      } else {
        submitOrderLocally(order, customer, totalAmount, paymentTypeDefault, customerNote, false, (update == 1 ? id : 0),
          numPeople, tableId, {}, {}, useDiscount, note, 0, false, service, '',
          '', '', id, status, flag, null, null, null, null, null, true, customFields
        ).then(res => {

          resolve(true)
        })
      }

    })
  })
}

const PrintersPage = () => {
  const [isError, setIsError] = useState(false);
  const [printers, setPrinters] = useState([]);
  const [printersName, setPrintersName] = useState({});
  const [printerIds, setPrinterIds] = useState<IPrinter[]>([]);
  const [total, setTotal] = useState({ count: "0", total: "0" });
  const [total2, setTotal2] = useState({ count: "0", total: "0" });
  const [total3, setTotal3] = useState({ count: "0", total: "0" });
  const [borderSize, setBorderSize] = useState("");
  const [fontSize, setFontSize] = useState("");
  const [pageWidth, setPageWidth] = useState("");
  const [com, setCom] = useState("COM4");
  const [financialAccess, setFinancialAccess] = useState(true);
  const router = useRouter();
  const { setLoader, setToken, setOrder, token, warehouse } = useProductContext();
  const getItems = async (id) => {
    try {
      let resp = await getChildren(id, token);
      let normalizedItems = resp.items;
      localStorage.setItem(`level${id}`, JSON.stringify(normalizedItems));
      localStorage.setItem(`date${id}`, String(resp.last_update));

      for (let itmN in resp.items) {
        if (resp.items[itmN].isCat) {
          getItems(resp.items[itmN].id);
        }
      }
      return true;
    } catch (error) {
      console.log(error);
      return false;
    }
  };

  const updateMenu = async () => {
    try {
      let resp = await getChildren(0, token);
      for (let catItem in resp.items) {
        getItems(resp.items[catItem].id);
      }
      return true;
    } catch (error) {
      console.log(error);
      return false;
    }
  };

  const handlePrinters = async () => {
    await getPrinters()
      .then((printersArr) => {
        // console.log(printersArr)
        setPrinters([...printersArr]);
      })
      .catch(() => setIsError(true));
  };

  useEffect(() => {
    // get all nodes from localstorage
    let pids = localStorage.getItem("printers");

    // nodes are not available? need to re-login
    if (!pids) {
      localStorage.removeItem("token");
      router.push("/login");
    }

    let pidsArr = JSON.parse(pids) || "[]";
    let pidsObjArr = [];
    pidsArr.forEach((id: string) => {
      let name = localStorage.getItem(id);
      let item = { id, name };
      pidsObjArr.push(item);
    });
    setPrinterIds([...pidsObjArr]);

    setPrintersName(JSON.parse(localStorage.getItem("printers_name") || "{}"));

    // get accessible printers from node server
    handlePrinters();
    orderSum();
    if (!localStorage.getItem("borderSize"))
      localStorage.setItem("borderSize", "3");
    if (!localStorage.getItem("fontSize"))
      localStorage.setItem("fontSize", "12");
    if (!localStorage.getItem("pageWidth"))
      localStorage.setItem("pageWidth", "90");

    setBorderSize(localStorage.getItem("borderSize"));
    setFontSize(localStorage.getItem("fontSize"));
    setPageWidth(localStorage.getItem("pageWidth"));

    if (localStorage.getItem("com")) setCom(localStorage.getItem("com"));
    let f = localStorage.getItem('access');
    if (f) {
      f = JSON.parse(f)
      f = f['financial'];
      setFinancialAccess(f ? true : false)
    }
  }, [router]);

  const orderSum = () => {
    findOrder({ sum: 1 }).then((o) => {
      if (o["total"].length) setTotal(o["total"][0]);
      else setTotal({ count: "0", total: "0" });
      if (o["total2"].length) setTotal2(o["total2"][0]);
      else setTotal2({ count: "0", total: "0" });
      if (o["total3"].length) setTotal3(o["total3"][0]);
      else setTotal3({ count: "0", total: "0" });
    });
  };

  function logOut() {
    if (confirm("آیا مطمئن هستید؟")) {
      setToken(null);
      localStorage.removeItem("token");
      setOrder([]);
      router.push("/login");
    }
  }

  const handleSendAllPrint = async () => {
    setLoader(true);
    let printers = localStorage.getItem("printers") || "[]";
    printers = JSON.parse(printers);
    const prints = {};
    for (let i = 0; i < printers.length; i++) {
      const p = localStorage.getItem(printers[i]) || 0;
      if (p) {
        prints[printers[i]] = p;
      }
    }
    let orders = await findOrder({ sort: 1 });
    if (orders["order"] && orders["order"]?.length) {
      let startDate = getPersianDate(orders["order"][0]["date"], "y/m/d");
      let endDate = getPersianDate(
        orders["order"][orders["order"].length - 1]["date"],
        "y/m/d"
      );
      let totalPrice = 0;
      const orderData = [];
      for (const iterator of orders["order"]) {
        totalPrice += iterator["total"];
        orderData.push({
          _id: iterator["_id"],
          date: iterator["date"],
          total: iterator["total"],
        });
      }
      const print = await printAllOrders(
        orderData,
        pageWidth,
        startDate,
        endDate,
        borderSize,
        fontSize,
        numberFormat(totalPrice),
        prints
      );
      if (print["success"]) {
        setLoader(false);
      }
    } else {
      setLoader(false);
    }
  };

  return (
    <>
      <section className="flex flex-col items-center h-screen md:flex-row justify-center">
        <div className="hidden w-full h-screen bg-no-repeat bg-cover bg-printer-texture lg:block md:w-1/2"></div>
        <div
          className="flex items-start justify-center w-full h-screen px-6 bg-white md:max-w-md lg:max-w-full md:mx-0 lg:px-16 xl:px-12 overflow-y-auto"
          style={{ minWidth: "fit-content" }}
        >
          <div className="flex flex-col items-center justify-center w-full h-100 m-auto pb-4 pt-32">
            <div className="w-full text-yellow-700">
              <Link href="/" className="float-right">
                <a>بازگشت</a>
              </Link>
              {token && (
                <div
                  className="px-4 cursor-pointer float-left flex items-center gap-2 bg-red-600 rounded-md py-1.5"
                  onClick={(e) => {
                    logOut();
                  }}
                >
                  <ImageComponent
                    src="/images/logout.png"
                    alt="logout"
                    width={25}
                    height={25}
                  />
                  <p className="text-white">خروج از حساب کاربری</p>
                </div>
              )}
            </div>

            <div
              className="bg-green-200 border-t-4 border-teal-500 rounded-b text-teal-900 px-4 py-3 shadow-md mb-3"
              role="alert"
            >
              <div className="flex">
                <div>
                  <p className="font-bold">تعداد کل: {total["count"]}</p>
                  {
                    financialAccess ?
                      <p className="font-bold">
                        مجموع قیمت کل:{" "}
                        {formatPrice(roundFinalPrice(parseFloat(total["total"]),true))}
                      </p>
                      : ''
                  }

                </div>
              </div>
            </div>
            <div
              className="bg-yellow-200 border-t-4 border-teal-500 rounded-b text-teal-900 px-4 py-3 shadow-md mb-3"
              role="alert"
            >
              <div className="flex">
                <div>
                  <p className="font-bold">
                    تعداد تسویه شده های ارسال نشده: {total2["count"]}
                  </p>
                  {
                    financialAccess ?
                      <p className="font-bold">
                        مجموع تسویه شده های ارسال نشده:{" "}

                        {formatPrice(roundFinalPrice(parseFloat(total2["total"]),true))}
                      </p>
                      : ''
                  }

                </div>
              </div>
            </div>
            <div
              className="bg-blue-200 border-t-4 border-teal-500 rounded-b text-teal-900 px-4 py-3 shadow-md mb-3"
              role="alert"
            >
              <div className="flex">
                <div>
                  <p className="font-bold">
                    تعداد تسویه شده های ارسال شده: {total3["count"]}
                  </p>
                  {
                    financialAccess ?
                      <p className="font-bold">
                        مجموع تسویه شده های ارسال شده:{" "}
                        {formatPrice(roundFinalPrice(parseFloat(total3["total"]),true))}
                      </p>
                      : ''
                  }

                </div>
              </div>
            </div>
            <ErrorComponent
              isError={isError}
              message="هیچ پرینتری در دسترس نیست"
            />

            <div className="flex items-center justify-center mt-12">
              <span
                className="pt-2 ml-4 cursor-pointer"
                onClick={() => {
                  // remove current nodes
                  let printers = localStorage.getItem("printers") || "[]";
                  JSON.parse(printers).forEach((node: string) => {
                    localStorage.removeItem(node);
                  });
                  // reload printers list
                  handlePrinters();
                }}
              >
                <ImageComponent
                  src="/images/undo.png"
                  width={24}
                  height={24}
                  alt="undo"
                />
              </span>
              <h1 className="text-xl font-bold leading-tight md:text-2xl">
                لیست پرینترهای تعریف شده
              </h1>
            </div>

            <div className="flex items-center justify-center mt-12">
              <span
                className="pt-2 ml-4 cursor-pointer"
                onClick={() => {
                  // remove current nodes
                  let printers = localStorage.getItem("printers") || "[]";
                  JSON.parse(printers).forEach((node: string) => {
                    localStorage.removeItem(node);
                  });

                  document.location.reload();

                  //  ("#mysaid option:selected").prop("selected", false)
                }}
              >
                <ImageComponent
                  src="/images/trash.png"
                  width={24}
                  height={24}
                  alt="trash"
                />
              </span>
              <h1 className="text-xl font-bold leading-tight md:text-2xl">
                پاک کردن پرینترهای تعریف شده
              </h1>
            </div>

            <form className="mt-6 w-full flex flex-col">
              {printerIds.map((pid, index) => {
                return (
                  <div
                    key={index}
                    className="flex items-center justify-between"
                  >
                    <p className="pb-4 ml-4">
                      {printersName[pid.id] || pid.id}
                    </p>
                    <select
                      id={`select_${pid.id}`}
                      className={`w-full mb-4 select`}
                      style={{ maxWidth: "80%" }}
                      onChange={(e) => {
                        localStorage.setItem(pid.id, e.target.value);
                      }}
                      defaultValue={0}
                    >
                      <option disabled value={0} id={`option_${pid.id}`}>
                        {pid.name ? pid.name : "انتخاب کنید"}
                      </option>
                      {printers.map((printer, idx) => {
                        // console.log(printer)
                        return (
                          <option key={idx} value={printer.name}>
                            {printer.name}
                          </option>
                        );
                      })}
                    </select>
                    <button
                      type="button"
                      className="inline-block px-2 py-2 bg-red-600 text-white font-medium text-xs leading-tight uppercase rounded-full shadow-md hover:bg-red-700 hover:shadow-lg focus:bg-red-700 focus:shadow-lg focus:outline-none focus:ring-0 active:bg-red-800 active:shadow-lg transition duration-150 ease-in-out"
                      onClick={() => {
                        localStorage.removeItem(pid.id);
                        (
                          document.getElementById(
                            `select_${pid.id}`
                          ) as HTMLSelectElement
                        ).value = "0";
                        (
                          document.getElementById(
                            `option_${pid.id}`
                          ) as HTMLSelectElement
                        ).innerHTML = "انتخاب کنید";
                      }}
                    >
                      خالی کردن
                    </button>
                  </div>
                );
              })}
            </form>
            <div
              key={"com_select"}
              className="flex items-center justify-start w-full"
            >
              <p className="pb-4 ml-4">انتخاب COM</p>
              <select
                className={`w-full mb-4 select`}
                style={{ maxWidth: "80%" }}
                onChange={(e) => {
                  localStorage.setItem("com", e.target.value);
                  setCom(e.target.value);
                }}
                value={com}
              >
                <option value="COM1">COM1</option>
                <option value="COM2">COM2</option>
                <option value="COM3">COM3</option>
                <option value="COM4">COM4</option>
                <option value="COM5">COM5</option>
                <option value="COM6">COM6</option>
                <option value="COM7">COM7</option>
                <option value="COM8">COM8</option>
                <option value="COM9">COM9</option>
                <option value="COM10">COM10</option>
              </select>
            </div>
            <div className="w-full border p-2 rounded mt-2 mb-3">
              <div className="mt-3 mb-3">
                <h6>تنظیمات پرینت</h6>
                <hr />
              </div>
              <div className="mt-3 mb-3">
                <label htmlFor="">
                  قطر کادر (پیکسل) ( عدد پیشنهادی ۳ میباشد)
                </label>
                <input
                  type="number"
                  value={borderSize}
                  onChange={(e) => {
                    setBorderSize(e.target.value);
                    localStorage.setItem(
                      "borderSize",
                      e.target.value ? e.target.value : "3"
                    );
                  }}
                  className="textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0 mb-2"
                />
              </div>
              <div className="mt-3 mb-3">
                <label htmlFor="">
                  اندازه فونت (پیکسل) ( عدد پیشنهادی ۱۲ میباشد)
                </label>
                <input
                  type="number"
                  value={fontSize}
                  onChange={(e) => {
                    setFontSize(e.target.value);
                    localStorage.setItem(
                      "fontSize",
                      e.target.value ? e.target.value : "18"
                    );
                  }}
                  className="textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0 mb-2"
                />
              </div>
              <div className="mt-3 mb-3">
                <label htmlFor="">
                  {" "}
                  عرض صفحه (درصد) ( عدد پیشنهادی ۹۰ میباشد)
                </label>
                <input
                  type="number"
                  value={pageWidth}
                  onChange={(e) => {
                    setPageWidth(e.target.value);
                    localStorage.setItem(
                      "pageWidth",
                      e.target.value ? e.target.value : "90"
                    );
                  }}
                  className="textarea textarea-bordered w-full p-3 py-0 h-8 min-h-0 mb-2"
                />
              </div>
            </div>
            <div className="w-full">
              <Row>
                <Col md={12} lg={12} sm={24} xs={24} className="p-2">
                  <button
                    className="btn btn-accent w-full mt-4"
                    onClick={(e) => {
                      if (confirm("آیا مطمئن هستید؟")) {
                        localStorage.clear();
                        router.push("/login");
                      }
                    }}
                  >
                    ریست تمام تنظمیات برنامه و حذف پرینتر ها
                  </button>
                </Col>
                <Col md={12} lg={12} sm={24} xs={24} className="p-2">
                  <button
                    className="btn btn-accent w-full mt-4"
                    onClick={(e) => {
                      if (confirm("آیا مطمئن هستید؟")) {
                        setLoader(true);
                        updateMenu().then((res) => {
                          saveRawItems().then(() => {
                            setLoader(false);
                            router.push("/");
                          });
                        });
                      }
                    }}
                  >
                    به روز رسانی منو
                  </button>
                </Col>

                <Col md={12} lg={12} sm={24} xs={24} className="p-2">
                  <button
                    className="btn btn-accent w-full mt-4"
                    onClick={(e) => {
                      if (confirm("آیا مطمئن هستید؟")) {
                        setLoader(true);
                        getTable().then((res) => {
                          if (res) {
                            localStorage.setItem("tables", JSON.stringify(res));
                            setLoader(false);
                          }
                        });
                        getTable2().then((r) => {
                          localStorage.setItem("salon", JSON.stringify(r));
                        });
                      }
                    }}
                  >
                    به روز رسانی میز ها
                  </button>
                </Col>

                <Col md={12} lg={12} sm={24} xs={24} className="p-2">
                  <button
                    className="btn btn-accent w-full mt-4"
                    onClick={(e) => {
                      if (confirm("آیا مطمئن هستید؟")) {
                        setLoader(true);
                        uploadOfflineOrders(null, null, warehouse);
                        findOrder({ status: 20 }).then((o) => {
                          if (o["order"].length) {
                            toast.error(
                              "تمامی اطلاعات   هنوز به صورت کامل به  پایگاه  داده ارسال نشده",
                              {
                                hideProgressBar: true,
                                position: "bottom-right",
                                style: {
                                  direction: "rtl",
                                  fontFamily: "IRANSansX",
                                },
                              }
                            );
                            setLoader(false);
                            return;
                          } else {
                            findOrder({ remove: 1 }).then((r) => {
                              if (r["order"].acknowledged === true) {
                                request(
                                  { status: 0 },
                                  "/api/find2?model=Log"
                                ).then((res) => {
                                  if (!res?.length)
                                    request(
                                      { removeAll: 1 },
                                      "/api/find2?model=Log"
                                    );
                                });
                                toast.success(" با موفقیت انجام شد", {
                                  hideProgressBar: true,
                                  position: "bottom-right",
                                  style: {
                                    direction: "rtl",
                                    fontFamily: "IRANSansX",
                                  },
                                });
                                setLoader(false);
                                return;
                              }
                            });
                          }
                        });
                      }
                    }}
                  >
                    صفر کردن صندق
                  </button>
                </Col>
                {
                  financialAccess ? <Col md={12} lg={12} sm={24} xs={24} className="p-2">
                    <button
                      className="btn btn-accent w-full mt-4"
                      onClick={(e) => {
                        handleSendAllPrint();
                      }}
                    >
                      پرینت صندوق
                    </button>
                  </Col> : ''
                }

                {warehouse ? (
                  <Col md={12} lg={12} sm={24} xs={24} className="p-2">
                    <Link href={"/materials"}>
                      <button className="btn btn-primary w-full mt-4">
                        {" "}
                        ثبت ورود خروج انبار
                      </button>
                    </Link>
                  </Col>
                ) : (
                  ""
                )}
              </Row>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default PrintersPage;
