import { toast } from "react-toastify";
import { findOrder, saveOrderOffline } from "services/order";
import { printOrder } from "services/printOrder";

/**
 * @param {import('next').NextApiRequest} req
 * @param {import('next').NextApiResponse} res
 */
export default async function addOrder(req, res) {
  try {
    let order_id = req.body.order_id;
    delete req.body.order_id;
    let raw_items = req.body.raw_items;
    delete req.body.raw_items;
    let print_type = req.body.print_type;
    delete req.body.print_type;
    let print_data = req.body.print_data;
    delete req.body.print_data;
    let update = {
      id: order_id,
      poz_response: req.body,
    };
    if (req.body.ResponseCode == "00") {
      update["status"] = 6;
    }
    let order = await findOrder({ offline_id: order_id }, 1);
    saveOrderOffline(update).then((r) => {
      if (r["order"]) {
        // console.log("test", order["order"]["status"]);
        // console.log("test2", r["order"]["status"]);
        if (order["order"]["status"] == -2 && r["order"]["status"] == 6) {
          console.log("from poz ==>");
          console.log(r, order);

          printOrder(r, 1, null, null, 1, print_type, raw_items, print_data);
        }
        return res.status(200).json({ success: true, msg: req.body.ResponseDescription, status: r["order"].status });
      }
    });
  } catch (error) {
    console.log(error);
    res.json({ error });
  }
}
