import MaterialLog from 'models/materialLogModel';
import connectMongo from 'util/connectMongo';
const getTime = () => {
    const d = new Date();
    let time = d.getTime();
    return time;
}
/**
 * @param {import('next').NextApiRequest} req
 * @param {import('next').NextApiResponse} res
 */
export default async function saveMaterialLog(req, res) {
    try {
        await connectMongo();
        let order;
        if (req.body.delete) {
            let logs = await MaterialLog.deleteMany();
            return res.status(200).json(logs);
        }
        if (req.body.remove) {
            let logs = await MaterialLog.deleteOne(req.body);
            return res.status(200).json(logs);
        }
        if (req.body.update) {
            let logs = await MaterialLog.updateMany({ status: req.body.status }, { "$set": { "status": req.body.newStatus } });
            return res.status(200).json(logs);
        }
        if (req.body.data) {
            let data = req.body.data;
            for (const key in data) {
                let doc = await MaterialLog.findOne({ id: key, status: 0 }).then(async (item) => {
                    if (item) {
                        item.qty = (parseFloat(data[key]) + parseFloat(item.qty));
                        order = await item.save();
                    } else {
                        let count = await MaterialLog.findOne({}, {}, { sort: { '_id': -1 } });

                        if (!count)
                            count = 1;
                        else
                            count = count._id + 1
                        let hash = `${req.body.branch_id}_${key}_${getTime()}`;
                        order = await MaterialLog.create({ _id: count, id: key, qty: data[key], status: 0, hash: hash });
                    }
                });
            }

        }
        return res.status(200).json(order);


        // order = await MaterialLog.findOne({ _id: req.body._id }).then(item => {
        //     if (!item) {
        //         MaterialLog.create(req.body);
        //     } else {
        //         let qty = (parseFloat(req.body.qty) + parseFloat(item.qty));
        //         MaterialLog.updateOne({ _id: req.body._id }, { qty: qty }, function (err, docs) {
        //             if (err) {
        //                 console.log(err)
        //             }
        //             else {
        //                 console.log("Updated Docs : ", docs);
        //             }
        //         })
        //     }
        // })
        // return res.status(200).json(order);
    } catch (error) {
        console.log(error);
        return res.json({ error });
    }
}

