import { ifError } from 'assert';
import Order from 'models/orderModel';
import connectMongo from 'util/connectMongo';

/**
 * @param {import('next').NextApiRequest} req
 * @param {import('next').NextApiResponse} res
 */
export default async function findOrder(req, res) {
    try {
        await connectMongo();
        let order, total, total2, total3;
        if (req.body.remove == 1) {
            order = await Order.deleteMany();
            return res.status(200).json({ order });
        }
        if (req.body.removeOrder == 1) {
            order = await Order.deleteOne(req.body);
            return res.status(200).json({ order });
        }
        if (req.body.sum == 1) {
            total = await Order.aggregate([
                {
                    $match: {
                        status: { $nin: [-2] },
                    }
                }, {
                    $group:
                    {
                        _id: '',
                        total: { $sum: "$total" },
                        count: { $sum: 1 }
                    },
                }])
            total2 = await Order.aggregate(
                [
                    {
                        $match: {
                            status: 6,
                        }
                    },
                    {
                        $group:
                        {
                            _id: '',
                            total: { $sum: "$total" },
                            count: { $sum: 1 }
                        },
                    }
                ]
            )
            total3 = await Order.aggregate(
                [
                    {
                        $match: {
                            status: 20,
                        }
                    },
                    {
                        $group:
                        {
                            _id: '',
                            total: { $sum: "$total" },
                            count: { $sum: 1 }
                        },
                    }
                ]
            )
            return res.status(200).json({ total: total, total2: total2, total3: total3 });
        } else {
            if (req.body.table_id == 0) {
                req.body.table_id = { $exists: true, $ne: null };
            }
            if (req.body.status == 6 && req.body.just_status != 6) {
                req.body.status = { $nin: [6, 20, -2] };
            }
            if (req.body.status == 20) {
                req.body.status = { $nin: [20, -2] };
            }
            if (req.body.status == 0) {
                req.body.status = { $in: [6, 20] };
            }
            let limit = 1000;
            let skip = 0;
            if (req.body.limit) {
                limit = req.body.limit
                skip = req.body.skip;
                delete req.body.limit;
                delete req.body.skip;
            }

            if (req.query.one == 1)
                order = await Order.findOne(req.body);
            else if (!req.body.sort)
                order = await Order.find(req.body).skip(skip).limit(limit).sort({ _id: -1 });
            else
                order = await Order.find(req.body).skip(skip).limit(limit);

            if (req.body.count == 1) {
                delete req.body.count;
                order = await Order.find(req.body).count();
            }

        }
        return res.status(200).json({ order });
    } catch (error) {
        console.log(error);
        res.json({ error });
    }
}

