import { ifError } from 'assert';
import Branch from 'models/branchModel';
import connectMongo from 'util/connectMongo';

/**
 * @param {import('next').NextApiRequest} req
 * @param {import('next').NextApiResponse} res
 */
export default async function saveBranch(req, res) {
    try {
        await connectMongo();
        let order;
        if (req.body.id) {
            order = await Branch.findOne(req.body);
        } else {
            await Branch.deleteMany();
            order = await Branch.create(req.body);
        }
        return res.status(200).json({ order });
    } catch (error) {
        console.log(error);
        res.json({ error });
    }
}

