import Head from "next/head";
// 3rd-parties
import axios from "axios";
// Application
import Layout from "components/Layout";
import PageTitle from "components/shared/PageTitle";
// Styles
import "styles/globals.scss";
import "styles/style.css";
// import 'styles/style2.css'
import apiUrl from "apiUrl";
import { ProductsStateContext } from "components/Products";
import { saveRawItems, uploadOfflineOrders } from "helpers/offline";
import ICart from "interfaces/cart";
import IMenuItem from "interfaces/menuItem";
import { useRouter } from "next/router";
import { useEffect, useState } from "react";
import { saveBranch } from "services/order";
import { getMaterial } from "services/table";

const FRONTEND_SERVER_URL = "http://localhost:3000";
var CronJob = require("cron").CronJob;

axios.defaults.baseURL = apiUrl[1];
axios.interceptors.response.use(
  function (response) {
    // Call was successful, don't do anything special.
    return response;
  },
  function (error) {
    if (error.response) {
      switch (error.response.status) {
        case 401: // Not logged in
          // console.log("خطا در احراز هویت.");
          localStorage.clear();
          window.location.href = `${FRONTEND_SERVER_URL}/login`;
          break;
        case 419: // Session expired
        case 503: // Down for maintenance
          // Bounce the user to the login screen with a redirect back
          // window.location.reload();
          // console.log(error.response);
          break;
        case 500:
          // console.log(
          //   "Oops, something went wrong!  The team have been notified."
          // );
          break;
        default:
          // Allow individual requests to handle other errors
          return Promise.reject(error);
      }
    }
  }
);

function MyApp({ Component, pageProps }): JSX.Element {
  {
    const router = useRouter();
    const [menuItems, setMenuItems] = useState<IMenuItem[]>([]);
    const [catItems, setCatItems] = useState<IMenuItem[]>([]);
    const [order, setOrder] = useState<ICart[]>([]);
    const [offline, setOffline] = useState<boolean>(false);
    const [offlineBills, setOfflineBills] = useState<number>(0);
    const [token, setToken] = useState<string>(null);
    const [detailEditOrder, setDetailEditOrder] = useState({});
    const [tableId, setTableId] = useState("");
    const [repeatPrinting, setRepeatPrinting] = useState<boolean>(false);
    const [cron_job, setCron_job] = useState("4");
    const [runCron, setRunCron] = useState<boolean>(true);
    const [loader, setLoader] = useState<boolean>(false);
    const [warehouse, setWarehouse] = useState<boolean>(true);
    const [tax, setTax] = useState("0");
    const [branchName, setBranchName] = useState('');
    const [seconds, setSeconds] = useState(1);
    const [refresh, setRefresh] = useState('0');

    const interval = () => {
      const timer = setInterval(() => {
        setSeconds(seconds + 1);
      }, 100);
      return () => clearInterval(timer);
    }
    useEffect(() => {
      setOffline(!window.navigator.onLine);
      // let c = localStorage.getItem('cronjob');
      // if (c)
      //   setCron_job(c);
    });
    useEffect(() => {
      let t = localStorage.getItem("tax");
      setTax(t ? t : "0");
      setRefresh(localStorage.getItem('refresh') ?? '0')
      // console.log('first')
    }, [router]);
    useEffect(() => {
      saveBranch({ id: 1 }).then((res) => {
        let w =
          res["order"] && res["order"].warehouse && res["order"].warehouse == 1
            ? true
            : false;
        setWarehouse(w);

        if (res["order"] && res["order"]['name'])
          setBranchName(res["order"]['name']);

        if (!res["order"] || !res["order"].cronjob) {
          localStorage.removeItem("token");
          router.push("/login");
        } else {
          var job = new CronJob(
            "0 " + res["order"].cronjob + " * * * *",
            function () {
              uploadOfflineOrders(null, null, w);
            },
            null,
            true,
            "Asia/Tehran"
          );
        }
      });
      var job2 = new CronJob(
        "0 0 12 * * *",
        function () {
          saveRawItems();
          if (warehouse) getMaterial(1);
        },
        null,
        true,
        "Asia/Tehran"
      );
      if (warehouse) getMaterial();
    }, []);
    return (
      <ProductsStateContext.Provider
        value={{
          menuItems,
          setMenuItems,
          order,
          setOrder,
          offline,
          setOffline,
          offlineBills,
          setOfflineBills,
          token,
          setToken,
          catItems,
          setCatItems,
          detailEditOrder,
          setDetailEditOrder,
          tableId,
          setTableId,
          repeatPrinting,
          setRepeatPrinting,
          loader,
          setLoader,
          warehouse,
          tax,
          setTax,
          branchName,
          setBranchName,
          interval,
          refresh,
          setRefresh
        }}
      >
        <Layout>
          <PageTitle />
          <Head>
            <meta
              name="viewport"
              content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=5"
            />
            <script src="/js/jquery.js"></script>
            <script src="/js/signalr.js"></script>
            <script src="http://localhost:8080/signalr/hubs"></script>
            <script src="/js/poz.js?v=1015"></script>
          </Head>
          <Component {...pageProps} />
        </Layout>
      </ProductsStateContext.Provider>
    );
  }
}

export default MyApp;
