import { Schema, model, models } from "mongoose";

const orderSchema = new Schema({
  _id: Number,
  order_details: {
    type: String,
    required: true,
  },
  offline_id: {
    type: String,
    required: true,
    unique: true,
  },
  order_local: {
    type: String,
    required: true,
  },
  status: {
    type: Number,
    required: true,
  },
  table_id: {
    type: String,
    required: false,
  },
  price: {
    type: Number,
    required: true,
  },
  discount: {
    type: Number,
    required: false,
  },
  total: {
    type: Number,
    required: true,
    default: 0,
  },
  date: String,
  updateDate: String,
  note: String,
  revision_num: Number,
  use_point: Boolean,
  user_point: Number,
  service: {
    type: String,
    required: false,
  },
  payment_card: {
    type: String,
    required: false,
  },
  payment_pos: {
    type: String,
    required: false,
  },
  payment_cash: {
    type: String,
    required: false,
  },
  flag: {
    type: Number,
    default: 0,
  },
  tax: {
    type: Number,
    default: 0,
  },
  online_table_id: {
    type: String,
    default: "",
  },
  username: String,
  tip: String,
  name_and_fam: String,
  remove_flag: {
    type: Number,
    default: 0,
  },
  poz_response: Object,
  loviuna: Object,
  userDiscount: Number,
  isOnline: Boolean,
  customFields: {
    type: String,
    default: "",
  },
});

const Order = models.Order || model("Order", orderSchema);

export default Order;
