import ICart from "interfaces/cart";
export function formatPrice(price: number) {
  // console.log(price);
  price *= 10;
  let formattedPrice = price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
  return formattedPrice + " ریال";
}
export function formatPrice2(price: number) {
  price = price;
  let price2 = price.toFixed();
  let formattedPrice = price2.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
  return formattedPrice;
}

export function cartTotalPrice(cart: ICart[], tax?: string) {
  let totalPrice = cart
    .map((item) => item.product.price * item.count)
    .reduce((prev, next) => prev + next, 0);
  if (tax === "1") {
    const noVat = cart
      .map((item) => item.product.vat_include == 1 ? (item.product.price * item.count) : 0)
      .reduce((prev, next) => prev + next, 0);
    let final = totalPrice - noVat;
    let vat_percent: any = localStorage.getItem('vat_percent');
    vat_percent = vat_percent ? parseFloat(vat_percent) : 0.1;
    let taxPrice = final * vat_percent;
    totalPrice += taxPrice;
  }
  let finalPrice = formatPrice(roundFinalPrice(totalPrice));
  return finalPrice;
}
export function roundFinalPrice(totalPrice, show_zero = false) {
  let text = totalPrice.toFixed();
  let replacement = "00";
  let result = text.substring(0, text.length - 2) + replacement;
  let finalPrice = parseInt(result);
  if (finalPrice == 0 && !show_zero)
    finalPrice = .1;
  return finalPrice;
}
export function cartTotalPrice2(cart: ICart[]) {
  const totalPrice = cart
    .map((item) => item.product.price * item.count)
    .reduce((prev, next) => prev + next, 0);
  return totalPrice;
}
export function cartTotalTax(totalPrice, tax, tip, cart) {
  const noVat = cart
    .map((item) => item.product.vat_include == 1 ? (item.product.price * item.count) : 0)
    .reduce((prev, next) => prev + next, 0);
  if (tip) totalPrice -= parseInt(tip);
  
  totalPrice -= noVat;
  if (tax !== "1") return 0;
  let vat_percent: any = localStorage.getItem('vat_percent');
  vat_percent = vat_percent ? parseFloat(vat_percent) : 0.1;
  let taxPrice = totalPrice * vat_percent;
  taxPrice = taxPrice;

  return Math.round(taxPrice);
}
export const p2e = (s) => s.replace(/[۰-۹]/g, (d) => "۰۱۲۳۴۵۶۷۸۹".indexOf(d));
export const e2p = (s) => s.replace(/\d/g, (d) => "۰۱۲۳۴۵۶۷۸۹"[d]);

export const parseInputValue = (value, number = false) => {
  if (value) {
    value = p2e(value);
    if (/\D/g.test(value) && number) {
      value = value.replace(/[^0-9.-]/g, "");
    }
    return value;
  }
  return value;
};
export function numberFormat(price) {
  let formattedPrice = price
    ? price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")
    : "";

  return formattedPrice;
}
export function maskm(val) {
  val = p2e(val).replace(/\D/g, "");
  val = val.replace(/,/g, "");
  val = numberFormat(val);
  return val;
}
