import IPrinter from 'interfaces/printer'
import IMenuItem from 'interfaces/menuItem'
import axios from 'axios'
import fs from 'fs'
import path from 'path'
import ptp from 'pdf-to-printer'

export function download(url, filename) {
  fetch(url).then(function (t) {
    return t.blob().then((b) => {
      var a = document.createElement('a')
      a.href = URL.createObjectURL(b)
      a.setAttribute('download', filename)
      a.click()
    })
  })
}

function downloadImage(url: string, target: string) {
  // console.log(`saving ${url} into ${target}`)
  return new Promise(function (resolve, reject) {
    axios({
      url,
      responseType: 'stream',
    }).then((response) => response.data.pipe(fs.createWriteStream(target)).on('finish', resolve).on('error', reject))
  })
}

function downloadFile(url: string, target: string, printer = '') {
  // console.log(`saving ${url} into ${target}`)
  return new Promise(function (resolve, reject) {
    axios({
      url,
      responseType: 'stream',
    }).then((response) =>
      response.data
        .pipe(fs.createWriteStream(target))
        .on('finish', () => {
          const options = {
            printer: printer,
            unix: ['-o fit-to-page'],
            win32: ['-print-settings "noscale"'],
          }
          if (fs.existsSync(target)) {
            ptp.print(target, options).then(res => {
              resolve(true)
            }).catch(err => {
              resolve(true)
            })
          }
          else resolve(true)
        })
        .on('error', reject)
    ).catch(err => {
      reject(err);
    })
  })
}

export const printLocal = (page, orderId, printer) => {
  const basePath = path.resolve(__dirname, '..', '..', 'bills')
  let filePath = path.resolve(basePath, orderId + '.pdf')
  if (fs.existsSync(filePath)) {
    fs.unlinkSync(filePath)
  }
  return downloadFile(page, filePath, printer);
}

export const saveBill = (printers: IPrinter[], orderId: string) => {
  const basePath = path.resolve(__dirname, '..', '..', 'bills')
  return Promise.all(
    printers.map(function (item) {
      let filePath = path.resolve(basePath, orderId + '-' + item.id + '.pdf')
      if (fs.existsSync(filePath)) {
        // console.log('deleting existing img')
        fs.unlinkSync(filePath)
      }
      return downloadFile(item.page, filePath, item.name)
    })
  )
}

export const saveBill5 = (printers, orderId: string) => {
  const basePath = path.resolve(__dirname, '..', '..', 'bills')
  let filePath = path.resolve(basePath, orderId + '-' + printers.id + '.pdf')
  if (fs.existsSync(filePath)) {
    // console.log('deleting existing img')
    fs.unlinkSync(filePath)
  }
  return downloadFile(printers.page, filePath, printers.name)


  // })


  // )
}

export const saveLocal = (items: IMenuItem[]) => {
  const basePath = path.resolve(__dirname, '..', '..', 'public', 'images', 'products')
  return Promise.all(

    items.map(function (item) {
      let filePath = path.resolve(basePath, item.id + '.jpeg')
      if (fs.existsSync(filePath)) {
        // console.log('deleting existing img')
        fs.unlinkSync(filePath)
      }
      return downloadImage(item.img, filePath)
    })
  )
}
