import axios, { AxiosRequestConfig } from "axios";

import IMenuItem, { IMenuItems } from "interfaces/menuItem";
import ICart from "../interfaces/cart";

import basUrl from "../baseU.js";
import apiUrl from "apiUrl";

export const replaceSecondChar = (word: string): string => {
  var t = 0;
  word = word.replace(/ /g, function (match) {
    t++;
    return t === 2 ? "-" : match;
  });

  return word;
};

export const removeItemFromCart = (unique, orders: ICart[]): ICart[] => {
  orders.some((item, idx) => {
    if (item.product.unique === unique) {
      --orders[idx].count;
      if (orders[idx].count <= 0) {
        orders.splice(idx, 1);
      }
      return;
    }
  });
  return orders;
};

export const updateOrderNote = (
  unique,
  orders: ICart[],
  note: string
): ICart[] => {
  orders.some((item, idx) => {
    if (item.product.unique === unique) {
      orders[idx].note = note;
      return;
    }
  });
  return orders;
};

export const addItemToCart = (unique, orders: ICart[]): ICart[] => {
  orders.some((item, idx) => {
    if (item.product.unique === unique) {
      ++orders[idx].count;
      return;
    }
  });
  return orders;
};
export const removeItemsFromCart = (unique, orders: ICart[]): ICart[] => {
  orders.some((item, idx) => {
    if (item.product.unique === unique) {
      orders.splice(idx, 1);
      return;
    }
  });
  return orders;
};

export const getChildrenOffline = (parentId: number) => {
  return new Promise((resolve, reject) => {
    let subItems: IMenuItem[] = [];
    const localItems = localStorage.getItem(`level${parentId}`);
    if (!localItems) {
      reject("local data does not exists");
    } else {
      subItems = JSON.parse(localItems);
      return resolve(subItems);
    }
  });
};

export const GetCurrentPageUpdate = (parentId: number, token: string) => {
  return new Promise((resolve, reject) => {
    const brancId = localStorage.getItem("user_client_id");
    const query =
      parentId === 0
        ? `?branch_id=${brancId}`
        : `?parent_id=${parentId}&branch_id=${brancId}`;
    const data = new FormData();
    data.append("token", token);
    axios({ method: "POST", url: `/category${query}`, data })
      .then((resp) => {
        if (resp) resolve(resp.data.last_update);
      })
      .catch((err) => reject(err));
  });
};

export const saveItemsOffline = (
  subItems: IMenuItem[],
  parentId: number,
  lastUpdate: number
) => {
  return new Promise((resolve, reject) => {
    // save items locally
    var data = JSON.stringify(subItems);
    var config: AxiosRequestConfig = {
      method: "post",
      baseURL: basUrl,
      url: "/save",
      headers: {
        "Content-Type": "application/json",
      },
      data: data,
    };

    axios(config)
      .then(function (response) {
        // subItems.forEach((item: IMenuItem) => {
        //   item.img = `/images/products/${item.id}.jpeg`;
        // });
        return resolve(subItems);
      })
      .catch(function (error) {
        reject(error);
      });
  });
};

export const getChildren = async (
  parentId: number,
  token: string
): Promise<IMenuItems> => {
  return new Promise((resolve, reject) => {
    let subItems: IMenuItem[] = [];
    // Let's fetch the items from viuna server
    const brancId = localStorage.getItem("user_client_id");
    const query =
      parentId === 0
        ? `?branch_id=${brancId}`
        : `?parent_id=${parentId}&branch_id=${brancId}`;
    const data = new FormData();
    data.append("token", token);
    axios({ method: "POST", url: `/category${query}`, data })
      .then((resp) => {
        if (resp.data.length <= 0) {
          reject("no data");
        }
        // normalizing subItems array
        Object.keys(resp.data).forEach((item) => {
          if (item !== "items" && item !== "last_update") {
            // it's a category
            subItems.push({
              ...resp.data[item],
              id: item,
              parent: parentId,
              isCat: true,
            });
          } else if (item === "items") {
            // it's a product
            const products = resp.data[item];

            Object.keys(products).forEach((id) => {
              subItems.push({
                ...products[id],
                id,
                parent: parentId,
                isCat: false,
              });
            });
          }
        });

        const result: IMenuItems = {
          items: subItems,
          last_update: resp.data.last_update,
        };
        resolve(result);
      })
      .catch((err) => {
        // console.log(err)
        return reject(err);
      });
  });
};
const saveItems = async (data, id, last_update) => {
  localStorage.setItem(`level${id}`, JSON.stringify(data));
  localStorage.setItem(`date${id}`, String(last_update));
};
export const getMenu = async (token: string): Promise<Boolean> => {
  return new Promise((resolve, reject) => {
    const brancId = localStorage.getItem("user_client_id");
    const data = new FormData();
    data.append("token", token);
    axios({
      method: "POST",
      url: `${apiUrl[0]}/restapi/category?branch_id=${brancId}`,
      data,
    })
      .then((resp) => {
        let res = resp.data;
        let items = res["items"];
        let cats = res["cats"];
        // if (items) {
        //   for (const key in items) {
        //     saveItems(items[key], false, key, 0, res["last_update"]);
        //   }
        // }
        if (items) {
          let level0 = [];
          for (const key in cats) {
            let item = cats[key]["item"];
            let child = [];
            for (const k in item) {
              child.push({
                ...item[k],
                parent: key,
                isCat: false,
                id: k,
              });
            }
            saveItems(child, key, res["last_update"]);
            delete cats[key]["item"];
            level0.push({
              ...cats[key],
              parent: 0,
              isCat: true,
              id: key,
            });
          }
          saveItems(level0, 0, res["last_update"]);
        }
        resolve(true);
      })
      .catch((err) => {
        // console.log(err)
        return reject(err);
      });
  });
};
