import { getMaterial } from "./../services/table";
import axios, { AxiosRequestConfig } from "axios";
import { saveBranch } from "services/order";

export const refreshToken = "";

export const login = (username: string, password: string) => {
  return new Promise((resolve, reject) => {
    var data = new FormData();
    data.append("username", username);
    data.append("password", password);

    var config: AxiosRequestConfig = { method: "POST", url: "/auth", data };

    axios(config)
      .then((response) => {
        if (response.data.order_type_default) {
          localStorage.setItem(
            "order_type_default",
            response.data.order_type_default
          );
        }
        if (response.data.custom_print_valuet) {
          localStorage.setItem(
            "custom_print_valuet",
            JSON.stringify(response.data.custom_print_valuet)
          );
        }

        if (response.data.default_print_type) {
          localStorage.setItem(
            "default_print_type",
            response.data.branch_type == 1
              ? 1
              : response.data.default_print_type
          );
        }

        if (response.data.table_list) {
          localStorage.setItem(
            "table_list",
            JSON.stringify(response.data.table_list)
          );
        }

        if (response.data.client_type) {
          localStorage.setItem(
            "client_type",
            JSON.stringify(response.data.client_type)
          );
        }
        if (response.data.branch_type) {
          localStorage.setItem("branch_type", response.data.branch_type);
        }
        if (response.data.username) {
          localStorage.setItem("username", response.data.username);
        }
        if (response.data.user_name_and_fam) {
          localStorage.setItem(
            "user_name_and_fam",
            response.data.user_name_and_fam
          );
        }
        localStorage.setItem("tax", response.data.vat ? response.data.vat : 0);
        localStorage.setItem("no_brand", response.data.no_brand ? response.data.no_brand : 0);
        if (response.data?.custom_note) {

          localStorage.setItem("custom_note", response.data?.custom_note);
        } else {
          localStorage.removeItem("custom_note");

        }
        if (response.data.cronjob) {
          localStorage.setItem("branch_name", response.data.token[0].name);
          localStorage.setItem("cronjob", response.data.cronjob);
          saveBranch({
            token: response.data.token[0].token,
            name: response.data.token[0].name,
            cronjob: response.data.cronjob,
            _id: 1,
            warehouse: response.data.warehouse ? response.data.warehouse : 0,
          });
        }

        if (response.data.discount_list) {
          let discount_list = response.data.discount_list;
          let dl = [];
          Object.keys(discount_list).forEach((key) => {
            dl.push({
              text: discount_list[key],
              id: key,
            });
          });
          localStorage.setItem("discount_list", JSON.stringify(dl));
        }
        if (response.data.discount_list_app) {
          localStorage.setItem(
            "discount_list_app",
            JSON.stringify(response.data.discount_list_app)
          );
        }

        if (response.data.printer_list) {
          localStorage.setItem(
            "printers_name",
            JSON.stringify(response.data.printer_list)
          );
        }
        if (response.data.phone) {
          localStorage.setItem("phone", response.data.phone);
        }
        if (response.data.access) {
          localStorage.setItem("access", response.data.access);
        }
        localStorage.setItem("point_free", response.data.point_free ? response.data.point_free : 20);
        localStorage.setItem("vat_percent", response.data.vat_percent ? response.data.vat_percent : 0.1);
        if (response.data.token) {
          localStorage.setItem(
            "printers",
            JSON.stringify(response.data.printer_id)
          );

          localStorage.setItem(
            "user_client_id",
            JSON.stringify(response.data.client_id)
          );
          resolve(response.data.token);
        } else {
          reject("token not available");
        }

        if (response.data.iterval) {
          localStorage.setItem("iterval", response.data.iterval);
        }
      })
      .catch((err) => {
        reject(err);
      });
  });
};
