"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.request = exports.saveLog = exports.saveMaterialLog = exports.saveMaterial = exports.getAndSaveMaterial = exports.getMaterial = exports.printChangeTable = exports.setQuery = exports.getPrintLocal = exports.requestPrintTablet = exports.requestRepeatPrint = exports.changeTable = exports.changeStatus = exports.getRawItems = exports.getDetail = exports.getTable2 = exports.getTable = void 0;
var order_1 = require("./order");
var axios_1 = __importDefault(require("axios"));
var baseU_js_1 = __importDefault(require("../baseU.js"));
var apiUrl_1 = __importDefault(require("apiUrl"));
var status_text = {
    0: "معلق",
    1: " باز ",
    2: "ویرایش ",
    3: "کنسل ",
    4: " چاپ شده ",
    5: "پرداخت  و مانده",
    6: "پرداخت  و رفته",
    7: "DIGI JET",
    10: "refund",
};
var getTable = function () {
    return new Promise(function (resolve, reject) {
        var brancId = localStorage.getItem("user_client_id");
        var url = "".concat(apiUrl_1.default[0], "/in-branch-order/table?branch_id=").concat(brancId, "&offline=1");
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getTable = getTable;
var getTable2 = function () {
    return new Promise(function (resolve, reject) {
        var brancId = localStorage.getItem("user_client_id");
        var url = "".concat(apiUrl_1.default[0], "/in-branch-order/table_offline?branch_id=").concat(brancId);
        axios_1.default
            .get(url)
            .then(function (res) {
            if (res)
                resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getTable2 = getTable2;
var getDetail = function (id) {
    return new Promise(function (resolve, reject) {
        var url = "".concat(apiUrl_1.default[0], "/in-branch-order/table_detail2?order_id=").concat(id);
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getDetail = getDetail;
var getRawItems = function () {
    return new Promise(function (resolve, reject) {
        var token = localStorage.getItem("token");
        var id = "";
        if (token)
            id = token.split("%")[1];
        var url = "".concat(apiUrl_1.default[0], "/in-branch-order/raw_items?id=").concat(id);
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getRawItems = getRawItems;
var changeStatus = function (order_id, st_id) {
    return new Promise(function (resolve, reject) {
        var url = "".concat(apiUrl_1.default[0], "/in-branch-order/table_change_st?order_id=").concat(order_id, "&st_id=").concat(st_id);
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.changeStatus = changeStatus;
var changeTable = function (order_id, table_id) {
    return new Promise(function (resolve, reject) {
        console.log(order_id);
        console.log(table_id);
        (0, order_1.saveOrderOffline)({
            id: order_id,
            table_id: table_id,
        }).then(function (res) {
            if (res["order"]) {
                var r = res["order"];
                var d = JSON.parse(r.order_details);
                var data = {
                    final_price: r.total,
                    id: r.offline_id,
                    local_id: r.id,
                    table_id: r.table_id,
                    user_name: d.user_name,
                    user_id: d.user_id,
                    note: d.customer_note,
                    date: r.date,
                    date_orginal: r.date,
                    status_raw: r.status,
                    status: status_text[r.status],
                    pdf_customer: "",
                    pdf_bar: "",
                };
                resolve(data);
            }
        });
        // saveOrder
    });
};
exports.changeTable = changeTable;
var requestRepeatPrint = function (order_id) {
    return new Promise(function (resolve, reject) {
        var url = "".concat(apiUrl_1.default[0], "/in-branch-order/table_print_all?order_id=").concat(order_id);
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.requestRepeatPrint = requestRepeatPrint;
var requestPrintTablet = function (order_id) {
    return new Promise(function (resolve, reject) {
        var url = "".concat(apiUrl_1.default[0], "/in-branch-order/table_print_tablet?order_id=").concat(order_id);
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.requestPrintTablet = requestPrintTablet;
var getPrintLocal = function (page, order_id, printer) {
    return new Promise(function (resolve, reject) {
        var url = "".concat(baseU_js_1.default, "/printLocal?page=").concat(page, "&order_id=").concat(order_id, "&printer=").concat(printer);
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getPrintLocal = getPrintLocal;
var setQuery = function (type, order_id, table_id, st_id) {
    // set query for server
    var queryList = localStorage.getItem("queryList");
    if (!queryList) {
        localStorage.setItem("queryList", "[]");
        queryList = localStorage.getItem("queryList");
    }
    queryList = JSON.parse(queryList);
    var newQuery = {
        type: type,
        order_id: order_id || "",
        table_id: table_id || "",
        st_id: st_id || "",
        date: Date.now(),
    };
    queryList.push(newQuery);
    localStorage.setItem("queryList", JSON.stringify(queryList));
    setTimeout(function () {
        queryList = localStorage.getItem("queryList") || "[]";
        queryList = JSON.parse(queryList);
        if (type == "setStatus") {
            (0, exports.changeStatus)(order_id, st_id);
            queryList = queryList.filter(function (item) { return item.order_id != order_id && item.st_id != st_id; });
        }
        else if (type == "changeTable") {
            (0, exports.changeTable)(order_id, table_id);
            queryList = queryList.filter(function (item) { return item.order_id != order_id && item.table_id != table_id; });
        }
        localStorage.setItem("queryList", JSON.stringify(queryList));
    }, 5400000);
};
exports.setQuery = setQuery;
var printChangeTable = function (prewTable, nextTable) {
    var printer = localStorage.getItem("p2") || "";
    if (!printer)
        return;
    var phone = " ";
    if (localStorage.getItem("phone"))
        phone = localStorage.getItem("phone");
    var url = "".concat(baseU_js_1.default, "/printChangeTable?prewTable=").concat(prewTable, "&nextTable=").concat(nextTable, "&printer=").concat(printer, "&phone=").concat(phone);
    axios_1.default
        .get(url)
        .then(function (res) {
        return;
    })
        .catch(function (err) {
        return;
    });
};
exports.printChangeTable = printChangeTable;
var getMaterial = function (update) {
    return new Promise(function (resolve, reject) {
        if (update == 1) {
            (0, exports.getAndSaveMaterial)().then(function (r) {
                resolve(r);
            });
        }
        else {
            (0, exports.request)({ _id: 1 }, "/api/find2?model=Material").then(function (res) {
                if (!res.length) {
                    (0, exports.getAndSaveMaterial)().then(function (r) {
                        resolve(r);
                    });
                }
            });
        }
    });
};
exports.getMaterial = getMaterial;
var getAndSaveMaterial = function () {
    return new Promise(function (resolve, reject) {
        var url = "".concat(apiUrl_1.default[0], "/in-branch-item/qty-detail");
        axios_1.default
            .get(url)
            .then(function (res) {
            if (res.data) {
                resolve(res.data);
                (0, exports.saveMaterial)({ data: res.data });
            }
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getAndSaveMaterial = getAndSaveMaterial;
var saveMaterial = function (req) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: "post",
            baseURL: baseU_js_1.default,
            url: "api/material",
            headers: {
                "Content-Type": "application/json",
            },
            data: JSON.stringify(req),
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.saveMaterial = saveMaterial;
var saveMaterialLog = function (req) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: "post",
            baseURL: baseU_js_1.default,
            url: "api/material_log",
            headers: {
                "Content-Type": "application/json",
            },
            data: JSON.stringify(req),
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.saveMaterialLog = saveMaterialLog;
var saveLog = function (req) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: "post",
            baseURL: baseU_js_1.default,
            url: "api/saveLog",
            headers: {
                "Content-Type": "application/json",
            },
            data: JSON.stringify(req),
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.saveLog = saveLog;
var request = function (req, url) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: "post",
            baseURL: baseU_js_1.default,
            url: url,
            headers: {
                "Content-Type": "application/json",
            },
            data: JSON.stringify(req),
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.request = request;
