"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.printAllOrders = exports.removeOrder = exports.setOrderStatus = exports.createOrderData = exports.getOnlineOrderData = exports.getTableList = exports.saveBill5 = exports.submitOrder = exports.saveBranch = exports.findOrder = exports.saveOrderOffline = exports.submitOrderOffline = exports.getCustomer = void 0;
var printer_1 = require("helpers/printer");
var axios_1 = __importDefault(require("axios"));
var react_toastify_1 = require("react-toastify");
var baseU_js_1 = __importDefault(require("../baseU.js"));
var getCustomer = function (token, query) {
    return new Promise(function (resolve, reject) {
        var data = new FormData();
        data.append("token", token);
        var config = {
            method: "post",
            url: "/check-user?q=".concat(query),
            data: data,
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data["results"]);
        })
            .catch(function (error) {
            // console.log(error)
            reject();
        });
    });
};
exports.getCustomer = getCustomer;
var submitOrderOffline = function (order, customer, totalAmount, printers, offline_id, custom_print_valuet, raw_items, table_id, factorID, discount, print_type, p_bill, p_bar, phone, note, numPeople, borderSize, fontSize, pageWidth, service, reprint, tip, taxPrice, loviuna) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: "post",
            baseURL: baseU_js_1.default,
            url: "submit-order",
            headers: {
                "Content-Type": "application/json",
            },
            data: JSON.stringify({
                order: order,
                customer: customer,
                totalAmount: totalAmount,
                printers: printers,
                offline_id: offline_id,
                custom_print_valuet: custom_print_valuet,
                raw_items: raw_items,
                table_id: table_id,
                factorID: factorID,
                discount: discount,
                print_type: print_type,
                p_bill: p_bill,
                p_bar: p_bar,
                phone: phone,
                note: note,
                numPeople: numPeople,
                borderSize: borderSize,
                fontSize: fontSize,
                pageWidth: pageWidth,
                service: service,
                reprint: reprint,
                tip: tip,
                taxPrice: taxPrice,
                loviuna: loviuna,
            }),
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.submitOrderOffline = submitOrderOffline;
var saveOrderOffline = function (req) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: "post",
            baseURL: baseU_js_1.default,
            url: "api/create",
            headers: {
                "Content-Type": "application/json",
            },
            data: JSON.stringify(req),
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.saveOrderOffline = saveOrderOffline;
var findOrder = function (req, one) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: "post",
            baseURL: baseU_js_1.default,
            url: "api/find" + (one == 1 ? "?one=1" : ""),
            headers: {
                "Content-Type": "application/json",
            },
            data: JSON.stringify(req),
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.findOrder = findOrder;
var saveBranch = function (req) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: "post",
            baseURL: baseU_js_1.default,
            url: "api/branch",
            headers: {
                "Content-Type": "application/json",
            },
            data: JSON.stringify(req),
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.saveBranch = saveBranch;
var submitOrder = function (order, token, customer, note, tableId, orderTypeDefault, paymentTypeDefault, usePoint, useDiscount, customerNote, noCustomer, orderId, numPeople) {
    return new Promise(function (resolve, reject) {
        var cart = [];
        order.forEach(function (item) {
            cart.push({
                id: item.product.id,
                options: item.product.options,
                qty: item.count,
                note: item.note,
            });
        });
        var finalOrder = {
            cart: cart,
            user_id: customer.id === 0 ? customer.name : customer.id,
        };
        var data = new FormData();
        data.append("token", token);
        data.append("cart", JSON.stringify(finalOrder));
        data.append("note", note);
        data.append("table_id", tableId);
        data.append("order_type_default", orderTypeDefault);
        data.append("payment_type", paymentTypeDefault);
        data.append("usePoint", usePoint);
        data.append("useDiscount", useDiscount.id);
        data.append("customer_note", customerNote);
        data.append("noCustomer", noCustomer.toString());
        data.append("order_id", orderId == 0 ? "" : orderId);
        data.append("numPeople", numPeople ? numPeople : "");
        var config = {
            method: "post",
            url: "/submit-order",
            data: data,
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            var printers = response.data.print_list;
            var printerBehave = localStorage.getItem("printer_behave_default");
            if (response.data.msg) {
                // alert(response.data.msg)
                react_toastify_1.toast.error(response.data.msg, {
                    position: "bottom-right",
                    style: { direction: "rtl", fontFamily: "IRANSansX" },
                    theme: "colored",
                });
            }
            var printersArr = [];
            console.log(printers);
            if (!printers)
                return reject();
            Object.keys(printers).forEach(function (node) {
                var printer = localStorage.getItem(node);
                var printerNode = printers[node];
                // Management of individual printers
                var custom_print_valuet = JSON.parse(localStorage.getItem("custom_print_valuet") || "[]");
                var raw_items = JSON.parse(localStorage.getItem("raw_items"));
                if (custom_print_valuet[node] && custom_print_valuet[node].cat) {
                    var PO_1 = [];
                    order.map(function (item, i) {
                        if (custom_print_valuet[node].cat.includes(raw_items[item.product.id].category_id.toString())) {
                            PO_1.push(i);
                        }
                    });
                    if (PO_1.length == 0) {
                        return;
                    }
                }
                if (!printer) {
                    // router.push('/printers')
                }
                else {
                    //print behave
                    if (printerBehave == "بدون پرینت") {
                    }
                    if (printerBehave == "پرینت باریستا") {
                        if (printerNode.type == "bar_all") {
                            printersArr.push({
                                id: node,
                                name: printer,
                                page: printerNode.path,
                            });
                        }
                    }
                    if (printerBehave == "پرینت مشتری و باریستا") {
                        printersArr.push({
                            id: node,
                            name: printer,
                            page: printerNode.path,
                        });
                    }
                }
            });
            if (printerBehave != "بدون پرینت" && printersArr.length) {
                var printOrder = {
                    printers: printersArr,
                    orderId: response.data.order_id,
                    billUrl: printersArr[0].page,
                    totalItems: response.data.item.length,
                };
                (0, printer_1.requestPrint)(printOrder)
                    .then(function (resp) {
                    resolve(resp);
                })
                    .catch(function (err) {
                    reject(err);
                });
            }
            else {
                resolve("ok");
            }
        })
            .catch(function (error) {
            console.log("catch");
            reject();
        });
    });
};
exports.submitOrder = submitOrder;
var saveBill5 = function (printer_id, pinter_name, pdf_url, status, orderId) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: "post",
            baseURL: baseU_js_1.default,
            url: "print1",
            headers: {
                "Content-Type": "application/json",
            },
            data: JSON.stringify({
                printer_id: printer_id,
                pinter_name: pinter_name,
                pdf_url: pdf_url,
                status: status,
                orderId: orderId,
            }),
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.saveBill5 = saveBill5;
var getTableList = function () {
    return new Promise(function (resolve, reject) {
        var client_id = localStorage.getItem("user_client_id");
        var token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        var config = {
            method: "post",
            url: "/table?offline=1",
            data: data,
        };
        (0, axios_1.default)(config)
            .then(function (_a) {
            var data = _a.data;
            resolve(data.table_list);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.getTableList = getTableList;
var getOnlineOrderData = function (order_id) {
    return new Promise(function (resolve, reject) {
        var client_id = localStorage.getItem("user_client_id");
        var token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        data.append("order_id", order_id);
        var config = {
            method: "post",
            url: "/get-order-data",
            data: data,
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.getOnlineOrderData = getOnlineOrderData;
var createOrderData = function (order) {
    var raw_items = localStorage.getItem("raw_items") || "[]";
    raw_items = JSON.parse(raw_items);
    var newOrder = [];
    Object.keys(order["items"]).map(function (item) {
        var id_item = item.split("_")[0];
        var options = [];
        if (order["items"][item]["options"] != null) {
            var opts = JSON.parse(order["items"][item]["options"] || "[]");
            for (var _i = 0, opts_1 = opts; _i < opts_1.length; _i++) {
                var opt = opts_1[_i];
                options.push({
                    id: opt,
                    name: raw_items[opt]["name"],
                    price: raw_items[opt]["last_price"],
                    image: "",
                });
            }
        }
        newOrder = __spreadArray(__spreadArray([], newOrder, true), [
            {
                product: {
                    name: "".concat(options.length
                        ? "".concat(raw_items[id_item].name, "(").concat(options
                            .map(function (opt) { return opt.name; })
                            .join("-"), ")")
                        : raw_items[id_item].name),
                    baseName: raw_items[id_item].name,
                    id: Number(id_item),
                    price: options.length
                        ? options
                            .map(function (i) { return i.price; })
                            .reduce(function (accumulator, curr) { return accumulator + curr; }) +
                            raw_items[id_item].last_price
                        : raw_items[id_item].last_price,
                    options: options,
                    unique: "".concat(id_item, "-").concat(options.length
                        ? "".concat(raw_items[id_item].name, "(").concat(options
                            .map(function (opt) { return opt.name; })
                            .join("-"), ")")
                        : raw_items[id_item].name),
                },
                count: order["items"][item]["qty"],
                note: order["items"][item]["note"] ? order["items"][item]["note"] : "",
            },
        ], false);
    });
    return newOrder;
};
exports.createOrderData = createOrderData;
var setOrderStatus = function (order_id, status) {
    return new Promise(function (resolve, reject) {
        var client_id = localStorage.getItem("user_client_id");
        var token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        data.append("order_id", order_id);
        data.append("status", status);
        var config = {
            method: "post",
            url: "/set-order-status",
            data: data,
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.setOrderStatus = setOrderStatus;
var removeOrder = function (order_id) {
    return new Promise(function (resolve, reject) {
        var client_id = localStorage.getItem("user_client_id");
        var token = localStorage.getItem("token");
        var data = new FormData();
        data.append("token", token);
        data.append("client_id", client_id);
        data.append("order_id", order_id);
        var config = {
            method: "post",
            url: "/remove-order",
            data: data,
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.removeOrder = removeOrder;
var printAllOrders = function (orders, pageWidth, startDate, endDate, borderSize, fontSize, totalAmount, printers) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: "post",
            baseURL: baseU_js_1.default,
            url: "print-all-order",
            // url: "api/test",
            headers: {
                "Content-Type": "application/json",
            },
            data: JSON.stringify({
                orders: orders,
                pageWidth: pageWidth,
                startDate: startDate,
                endDate: endDate,
                borderSize: borderSize,
                fontSize: fontSize,
                totalAmount: totalAmount,
                printers: printers,
            }),
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.printAllOrders = printAllOrders;
