"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var express_1 = __importDefault(require("express"));
var morgan_1 = __importDefault(require("morgan"));
var next_1 = __importDefault(require("next"));
var path_1 = __importDefault(require("path"));
var pdf_creator_node_1 = __importDefault(require("pdf-creator-node"));
var pdf_to_printer_1 = __importDefault(require("pdf-to-printer"));
var downloader_1 = require("../helpers/downloader");
var bill_template_1 = require("./../helpers/bill-template");
var baseU_js_1 = __importDefault(require("../baseU.js"));
// const dev = process.env.NODE_ENV !== 'production'
var dev = false;
var app = (0, next_1.default)({ dev: dev });
var handle = app.getRequestHandler();
function formatPrice2(price) {
    var price2 = price.toFixed();
    var formattedPrice = price2.replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return formattedPrice;
}
function roundFinalPrice(totalPrice) {
    var text = (parseFloat(totalPrice) * 1000).toFixed();
    var replacement = "00";
    var result = text.substring(0, text.length - 2) + replacement;
    var finalPrice = parseInt(result) / 1000;
    return finalPrice;
}
var save_pdf = function (htmlContent, filePath, printers) { return __awaiter(void 0, void 0, void 0, function () {
    var document;
    return __generator(this, function (_a) {
        document = {
            html: htmlContent,
            path: filePath,
            data: {},
            type: "",
        };
        pdf_creator_node_1.default
            .create(document, {
            width: "8cm",
            height: "29.7cm",
            timeout: "100000",
            // border: {
            //   top: '0cm',
            //   left: '1cm',
            //   right: '1cm',
            // }
        })
            .then(function (rs) {
            // let printer = ptp.getDefaultPrinter()
            for (var i = 0; i < printers.length; i++) {
                var options = {
                    printer: printers[i],
                    unix: ["-o fit-to-page"],
                    win32: ['-print-settings "noscale"'],
                };
                pdf_to_printer_1.default
                    .print(filePath, options)
                    .then(function (res) {
                    return res;
                })
                    .catch(function (err) {
                    return err;
                });
            }
            // return res.json({ success: true })
            // console.log(rs);
        })
            .catch(function (error) {
            // return res.json({ success: false })
            console.log(error);
        });
        return [2 /*return*/];
    });
}); };
var port = 3000;
(function () { return __awaiter(void 0, void 0, void 0, function () {
    var server, e_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                _a.trys.push([0, 2, , 3]);
                return [4 /*yield*/, app.prepare()];
            case 1:
                _a.sent();
                server = (0, express_1.default)();
                server.use(express_1.default.json());
                server.use((0, morgan_1.default)("dev"));
                server.use(function (req, res, next) {
                    res.setHeader("Access-Control-Allow-Origin", "*");
                    next();
                });
                // returns a list of all the available printers to the OS back to the client
                server.get("/getprinters", function (req, res) {
                    pdf_to_printer_1.default
                        .getPrinters()
                        .then(function (printers) { return res.json({ printers: printers }); })
                        .catch(function (err) { return res.status(500).json({ err: err }); });
                });
                server.get("/printLocal", function (req, res) { return __awaiter(void 0, void 0, void 0, function () {
                    var _a, page, order_id, printer;
                    return __generator(this, function (_b) {
                        _a = req.query, page = _a.page, order_id = _a.order_id, printer = _a.printer;
                        (0, downloader_1.printLocal)(page, order_id, printer)
                            .then(function () {
                            return res.json({ success: true });
                        })
                            .catch(function (err) {
                            res.statusCode = 402;
                            return res.json({ success: false });
                        });
                        return [2 /*return*/];
                    });
                }); });
                server.get("/printChangeTable", function (req, res) { return __awaiter(void 0, void 0, void 0, function () {
                    var _a, prewTable, nextTable, printer, phone, no_brand, branchName, htmlContent, filePath, document;
                    return __generator(this, function (_b) {
                        _a = req.query, prewTable = _a.prewTable, nextTable = _a.nextTable, printer = _a.printer, phone = _a.phone, no_brand = _a.no_brand, branchName = _a.branchName;
                        htmlContent = "\n      ".concat(bill_template_1.billStyle, "\n      ").concat(bill_template_1.htmlStart, "\n      ").concat((0, bill_template_1.headerTemplateDynamic)(null, null, null, null, no_brand, branchName), "\n      ");
                        htmlContent += "<h3>\u0648\u06CC\u0631\u0627\u06CC\u0634 \u0645\u06CC\u0632</h3>\n      <table class=\"table table-bordered text-center\">\n        <thead>\n          <tr class=\"c-head\">\n            <th style=\"padding:5px;border:3px solid #000;font-size:12px;font-weight:bold;font-family:tahoma;width:30%;\">\u0645\u06CC\u0632 \u0642\u0628\u0644\u06CC</th>\n            <th style=\"padding:5px;border:3px solid #000;font-size:12px;font-weight:bold;font-family:tahoma;width:30%;\">\u0645\u06CC\u0632 \u062C\u062F\u06CC\u062F</th>\n          </tr>\n        </thead>\n        <tbody>\n          <tr>\n            <td style=\"padding:5px;border:3px solid #000;font-size:12px;font-weight:bold;font-family:tahoma;width:30%;\">".concat(prewTable, "</td>\n            <td style=\"padding:5px;border:3px solid #000;font-size:12px;font-weight:bold;font-family:tahoma;width:30%;\">").concat(nextTable, "</td>\n          </tr>\n        </tbody>\n      </table>");
                        htmlContent += "".concat((0, bill_template_1.footer)(phone ? phone : "", no_brand, branchName));
                        filePath = path_1.default.join("bills", "".concat(prewTable + "-" + nextTable, "-p2.pdf"));
                        document = {
                            html: htmlContent,
                            path: filePath,
                            data: {},
                            type: "",
                        };
                        pdf_creator_node_1.default
                            .create(document, {
                            width: "8cm",
                            height: "29.7cm",
                            // border: {
                            //   top: '0cm',
                            //   left: '1cm',
                            //   right: '1cm',
                            // }
                        })
                            .then(function (rs) {
                            var options = {
                                printer: printer.toString(),
                                unix: ["-o fit-to-page"],
                                win32: ['-print-settings "noscale"'],
                            };
                            pdf_to_printer_1.default
                                .print(filePath, options)
                                .then(function (res) {
                                return res;
                            })
                                .catch(function (err) {
                                return err;
                            });
                            return res.json({ success: true });
                        })
                            .catch(function (error) {
                            return res.json({ success: false });
                        });
                        return [2 /*return*/];
                    });
                }); });
                // Receives a print request
                server.post("/print", function (req, res) { return __awaiter(void 0, void 0, void 0, function () {
                    var _a, printers, orderId;
                    return __generator(this, function (_b) {
                        _a = req.body, printers = _a.printers, orderId = _a.orderId;
                        (0, downloader_1.saveBill)(printers, orderId)
                            .then(function () {
                            return res.json({ success: true });
                        })
                            .catch(function (err) {
                            return res.json({ success: false });
                        });
                        return [2 /*return*/];
                    });
                }); });
                // Receives a print request
                server.post("/print1", function (req, res) { return __awaiter(void 0, void 0, void 0, function () {
                    var _a, printer_id, pinter_name, pdf_url, status, orderId, _the_bill;
                    return __generator(this, function (_b) {
                        _a = req.body, printer_id = _a.printer_id, pinter_name = _a.pinter_name, pdf_url = _a.pdf_url, status = _a.status, orderId = _a.orderId;
                        _the_bill = {
                            id: printer_id,
                            name: pinter_name,
                            page: pdf_url,
                            status: status,
                        };
                        (0, downloader_1.saveBill5)(_the_bill, orderId)
                            .then(function () {
                            return res.json({ success: true });
                        })
                            .catch(function (err) {
                            return res.json({ success: false });
                        });
                        return [2 /*return*/];
                    });
                }); });
                server.post("/submit-order", function (req, res) { return __awaiter(void 0, void 0, void 0, function () {
                    var _a, customer, order, totalAmount, printers, offline_id, custom_print_valuet, raw_items, table_id, factorID, discount, print_type, p_bill, p_bar, phone, note, numPeople, borderSize, fontSize, pageWidth, service, reprint, tip, taxPrice, loviuna, no_brand, branchName, isOnline, custom_note, customFields, keyPrinterBehaves, printType, customerName, customerMobile, htmlContent, htmlContent2, foot, loviunaDiscount, loviuna_discount, setPrinter, setPrinter2, PO, temp;
                    return __generator(this, function (_b) {
                        _a = req.body, customer = _a.customer, order = _a.order, totalAmount = _a.totalAmount, printers = _a.printers, offline_id = _a.offline_id, custom_print_valuet = _a.custom_print_valuet, raw_items = _a.raw_items, table_id = _a.table_id, factorID = _a.factorID, discount = _a.discount, print_type = _a.print_type, p_bill = _a.p_bill, p_bar = _a.p_bar, phone = _a.phone, note = _a.note, numPeople = _a.numPeople, borderSize = _a.borderSize, fontSize = _a.fontSize, pageWidth = _a.pageWidth, service = _a.service, reprint = _a.reprint, tip = _a.tip, taxPrice = _a.taxPrice, loviuna = _a.loviuna, no_brand = _a.no_brand, branchName = _a.branchName, isOnline = _a.isOnline, custom_note = _a.custom_note, customFields = _a.customFields;
                        // ignore removed items
                        order = order.filter(function (o) { return !o.remove; });
                        keyPrinterBehaves = {
                            "پرینت مشتری": 4,
                            "بدون پرینت": 3,
                            "پرینت باریستا": 2,
                            "پرینت مشتری و باریستا": 1,
                        };
                        printType = keyPrinterBehaves[print_type];
                        if (printType == 3)
                            return [2 /*return*/, res.json({ success: true })];
                        customerName = customer.name
                            ? customer.name.split("-")[1].replace("_", " ")
                            : "";
                        customerMobile = customer.name
                            ? customer.name.split("-")[0]
                            : "";
                        htmlContent = "".concat(bill_template_1.billStyle).concat((0, bill_template_1.htmlStart2)(pageWidth)).concat((0, bill_template_1.headerTemplateDynamic)(factorID, customerName, 1, reprint, no_brand, branchName, isOnline, customerMobile, JSON.parse(customFields))).concat((0, bill_template_1.tableStart)(borderSize, fontSize, pageWidth));
                        htmlContent2 = "".concat(bill_template_1.billStyle).concat((0, bill_template_1.htmlStart2)(pageWidth)).concat((0, bill_template_1.headerTemplateDynamic)(factorID, customerName, 0, reprint, no_brand, branchName, isOnline, customerMobile, JSON.parse(customFields))).concat((0, bill_template_1.tableStart2)(borderSize, fontSize, pageWidth));
                        order.forEach(function (item) {
                            var count = item.count;
                            if (item.old_qty) {
                                if (item.old_qty == item.count && printType != 4 && !item.remove)
                                    return;
                                if (printType != 4) {
                                    var new_count = item.count - item.old_qty;
                                    if (item.remove)
                                        count = 0;
                                    else
                                        count =
                                            item.count +
                                                "/" +
                                                (new_count > 0 ? "+" + new_count : new_count);
                                }
                            }
                            htmlContent += "\n            <tr class=\"\">\n              <td style=\"width:42%;padding:5px;border:".concat(borderSize, "px solid #000;font-size:").concat(fontSize, "px;font-weight:bold;font-family:tahoma\"class=\"c-name\">").concat(item.product.name, "</td>\n              <td style=\"width:10%;padding:5px;text-align:center;border:").concat(borderSize, "px solid #000;font-size:").concat(fontSize, "px;font-weight:bold;font-family:tahoma\"class=\"c-qty\">\n              ").concat(item.count, "\n              </td>\n              <td style=\"text-align:center;padding:5px;border:").concat(borderSize, "px solid #000;font-size:").concat(fontSize, "px;font-weight:bold;font-family:tahoma;\"class=\"c-price\">").concat(item.product.price / 1000, "</td>\n            <td style=\"text-align:center;padding:5px;border:").concat(borderSize, "px solid #000;font-size:").concat(fontSize, "px;font-weight:bold;font-family:tahoma;\"class=\"c-price\">").concat((item.count * item.product.price) / 1000, "</td></tr>\n            ");
                            htmlContent2 += "\n            <tr class=\"\">\n            <td style=\"width:90%;padding:5px;border:".concat(borderSize, "px solid #000;font-size:").concat(fontSize, "px;font-weight:bold;font-family:tahoma\"class=\"c-name\">").concat(item.product.name + (item.note ? "<hr>".concat(item.note) : ""), "</td>\n            <td style=\"width:10%;padding:5px;text-align:center;border:").concat(borderSize, "px solid #000;font-size:").concat(fontSize, "px;font-weight:bold;font-family:tahoma\"class=\"c-qty\">\n            ").concat(count, "</td>\n            </tr>\n            ");
                        });
                        foot = (note ? "<h4 style=\"white-space: break-spaces;\">\u062A\u0648\u0636\u06CC\u062D\u0627\u062A: ".concat(note, "</h4>") : "") +
                            (numPeople ? "<h4>\u062A\u0639\u062F\u0627\u062F \u0646\u0641\u0631\u0627\u062A: ".concat(numPeople, "</h4>") : "");
                        // customer data
                        // { id: 0, name: '123-ashkan' }
                        totalAmount = totalAmount.replace(" تومان", "");
                        totalAmount = totalAmount.replace(/,/g, "");
                        totalAmount = roundFinalPrice(totalAmount);
                        if (totalAmount == .1)
                            totalAmount = 0;
                        taxPrice *= 10;
                        loviunaDiscount = loviuna_discount ? Number(loviuna_discount * .1) : 0;
                        if (loviuna) {
                            loviuna_discount = Number(loviuna['price']) * 10000;
                            // console.log('we have loviuna.....' + taxPrice + " " + loviuna_discount);
                            taxPrice += (loviunaDiscount);
                        }
                        //return;
                        htmlContent += "\n        \n      ".concat(taxPrice > 0
                            ? "  \n      <tr class=\"summary bgorgm\" style=\"\">\n      <td style=\"font-weight:bold;padding:5px;border:".concat(borderSize, "px solid #000;font-family:tahoma;font-size:").concat(fontSize, "px;\"\n      class=\"total-action\"colspan=\"5\"><label>\u0645\u0627\u0644\u06CC\u0627\u062A \u0628\u0631 \u0627\u0631\u0632\u0634 \u0627\u0641\u0632\u0648\u062F\u0647 VAT::</label>\n      <span class=\"total\" style=\"float:left;\">").concat(formatPrice2(taxPrice), "</span>\n      </td> </tr>")
                            : "", "\n      \n        ").concat(!loviuna
                            ? "  <tr class=\"summary bgorgm\" style=\"\">\n          <td style=\"font-weight:bold;padding:5px;border:".concat(borderSize, "px solid #000;font-family:tahoma;font-size:").concat(fontSize, "px;\"\n          class=\"total-action\"colspan=\"5\"><label>\u067E\u0631\u062F\u0627\u062E\u062A \u0627\u0632 \u0627\u0639\u062A\u0628\u0627\u0631 \u0628\u0627\u0634\u06AF\u0627\u0647 </label>\n          <span class=\"total\" style=\"float:left;\">Loviuna:").concat(formatPrice2(0), "</span>\n          </td> </tr>")
                            : "\n        <tr class=\"summary bgorgm\" style=\"\">\n        <td style=\"font-weight:bold;padding:5px;border:".concat(borderSize, "px solid #000;font-family:tahoma;font-size:").concat(fontSize, "px;\"\n        class=\"total-action\"colspan=\"5\"><label>\u062C\u0645\u0639 \u0635\u0648\u0631\u062A \u062D\u0633\u0627\u0628:</label>\n        <span class=\"total\" style=\"float:left;\">").concat(formatPrice2((Number(loviuna['price']) * 10000) + (totalAmount) + loviunaDiscount), "</span>\n        </td> </tr>  \n        <tr class=\"summary bgorgm\" style=\"\">\n        <td style=\"font-weight:bold;padding:5px;border:").concat(borderSize, "px solid #000;font-family:tahoma;font-size:").concat(fontSize, "px;\"\n        class=\"total-action\"colspan=\"5\">\n        <label style=\"float:right\">\u067E\u0631\u062F\u0627\u062E\u062A \u0627\u0631 \u0627\u0639\u062A\u0628\u0627\u0631 \u0628\u0627\u0634\u06AF\u0627\u0647 <br> ").concat(loviuna['name'], "</label>\n        \n        <span class=\"total\" style=\"float:left\"><span style=\"    position: relative;\n        left: -4px;\">Loviuna</span><br>").concat(formatPrice2(Number(loviuna['price']) * 10000 + loviunaDiscount), "-</span>\n        </td> </tr> "), "\n        \n       \n\n\n        ").concat(discount > 0
                            ? "  \n        <tr class=\"summary bgorgm\" style=\"\">\n        <td style=\"font-weight:bold;padding:5px;border:".concat(borderSize, "px solid #000;font-family:tahoma;font-size:").concat(fontSize, "px;\"\n        class=\"total-action\"colspan=\"5\"><label>\u062A\u062E\u0641\u06CC\u0641:</label>\n        <span class=\"total\" style=\"float:left;\">").concat(formatPrice2(discount), "</span>\n        </td> </tr>")
                            : "", "\n        ").concat(service > 0
                            ? "  \n        <tr class=\"summary bgorgm\" style=\"\">\n        <td style=\"font-weight:bold;padding:5px;border:".concat(borderSize, "px solid #000;font-family:tahoma;font-size:").concat(fontSize, "px;\"\n        class=\"total-action\"colspan=\"5\"><label>\u062D\u0642 \u0633\u0631\u0648\u0631\u06CC\u0633:</label>\n        <span class=\"total\" style=\"float:left;\">").concat(formatPrice2(service), "</span>\n        </td> </tr>")
                            : "", "\n        ").concat(tip > 0
                            ? "  \n        <tr class=\"summary bgorgm\" style=\"\">\n        <td style=\"font-weight:bold;padding:5px;border:".concat(borderSize, "px solid #000;font-family:tahoma;font-size:").concat(fontSize, "px;\"\n        class=\"total-action\"colspan=\"5\"><label>tip:</label>\n        <span class=\"total\" style=\"float:left;\">").concat(formatPrice2(tip), "</span>\n        </td> </tr>")
                            : "", "\n        \n        <tr class=\"summary bgorgm\" style=\"\">\n        <td style=\"font-weight:bold;padding:5px;border:").concat(borderSize, "px solid #000;font-family:tahoma;font-size:").concat(fontSize, "px;\"\n        class=\"total-action\"colspan=\"5\"><label>\u062C\u0645\u0639 \u0642\u0627\u0628\u0644 \u067E\u0631\u062F\u0627\u062E\u062A:</label>\n        <span class=\"total\" style=\"float:left;\">").concat(formatPrice2(totalAmount), " \u0631\u06CC\u0627\u0644</span>\n        </td>\n        </tr>\n        <tr></tr></table>").concat((table_id ? "<h2>\u0634\u0645\u0627\u0631\u0647 \u0645\u06CC\u0632: ".concat(table_id, "</h2>\n") : "\n") +
                            "<h6>".concat(offline_id, "</h6>") +
                            (note ? "<h6 style=\"white-space: break-spaces;\">\u062A\u0648\u0636\u06CC\u062D\u0627\u062A: ".concat(note, "</h6>\n") : "\n") +
                            (custom_note ? ("<h6 style=\"white-space: break-spaces;margin-bottom:1rem\">".concat(custom_note, "</h6>\n")) : '\n') +
                            (0, bill_template_1.footer)(phone, no_brand, branchName));
                        htmlContent2 += "</table>".concat((table_id ? "<h2>شماره میز: " + table_id + "</h2>" : "") + foot);
                        setPrinter = [];
                        setPrinter2 = [];
                        if (printers["p1"])
                            setPrinter.push(printers["p1"]);
                        // if (printers["p0"]) setPrinter.push(printers["p0"]);
                        ["p2", "p3", "p4", "p5"].map(function (item) {
                            if (printers[item])
                                setPrinter2.push(printers[item]);
                        });
                        if ([1, 4].includes(printType))
                            save_pdf(htmlContent, path_1.default.join("bills", "".concat(offline_id, ".pdf")), setPrinter);
                        if (printType == 4)
                            return [2 /*return*/, res.json({ success: true })];
                        setPrinter = [];
                        save_pdf(htmlContent2, path_1.default.join("bills", "".concat(offline_id, "_k.pdf")), setPrinter2);
                        if (p_bill && printers["p" + p_bill])
                            save_pdf(htmlContent, path_1.default.join("bills", "".concat(offline_id, "_p").concat(p_bill, ".pdf")), [printers["p" + p_bill]]);
                        if (p_bar && printers["p" + p_bar])
                            save_pdf(htmlContent2, path_1.default.join("bills", "".concat(offline_id, "_k_p").concat(p_bar, ".pdf")), [printers["p" + p_bar]]);
                        PO = {};
                        temp = [];
                        Object.keys(custom_print_valuet).forEach(function (i) {
                            temp = [];
                            order.map(function (item, index) {
                                if (custom_print_valuet[i].cat &&
                                    (custom_print_valuet[i].cat.length || [])) {
                                    if (custom_print_valuet[i].cat.includes(raw_items[item.product.id].category_id.toString())) {
                                        var count = item.count;
                                        if (item.old_qty) {
                                            if (item.old_qty == item.count)
                                                return;
                                            var new_count = item.count - item.old_qty;
                                            count =
                                                item.count +
                                                    "/" +
                                                    (new_count > 0 ? "+" + new_count : new_count);
                                        }
                                        temp.push("\n                <tr class=\"\">\n                <td style=\"width:90%;padding:5px;border:".concat(borderSize, "px solid #000;font-size:").concat(fontSize, "px;font-weight:bold;font-family:tahoma\"class=\"c-name\">").concat(item.product.name + (item.note ? "<hr>".concat(item.note) : ""), "</td>\n                <td style=\"width:10%;padding:5px;text-align:center;border:").concat(borderSize, "px solid #000;font-size:").concat(fontSize, "px;font-weight:bold;font-family:tahoma\"class=\"c-qty\">\n                ").concat(count, "</td>\n                </tr>\n                "));
                                        PO[i] = temp;
                                        return;
                                    }
                                }
                            });
                        });
                        Object.keys(PO).forEach(function (i) {
                            setPrinter = [];
                            htmlContent2 = "".concat(bill_template_1.billStyle).concat((0, bill_template_1.htmlStart2)(pageWidth)).concat((0, bill_template_1.headerTemplateDynamic)(factorID, customerName, 0, reprint, no_brand, branchName, isOnline) +
                                "<h4>" +
                                custom_print_valuet[i].name +
                                "</h4>").concat((0, bill_template_1.tableStart2)(borderSize, fontSize, pageWidth));
                            PO[i].map(function (item) {
                                htmlContent2 += item;
                            });
                            htmlContent2 += "</table>".concat((table_id ? "<h2>شماره میز: " + table_id + "</h2>" : "") + foot);
                            if (printers[i])
                                setPrinter.push(printers[i]);
                            save_pdf(htmlContent2, path_1.default.join("bills", "".concat(offline_id, "_k_").concat(i, ".pdf")), setPrinter);
                        });
                        return [2 /*return*/, res.json({ success: true })];
                    });
                }); });
                server.post("/print-all-order", function (req, res) { return __awaiter(void 0, void 0, void 0, function () {
                    var _a, orders, pageWidth, startDate, endDate, borderSize, fontSize, totalAmount, printers, htmlContent, _i, orders_1, item, date, setPrinter;
                    return __generator(this, function (_b) {
                        _a = req.body, orders = _a.orders, pageWidth = _a.pageWidth, startDate = _a.startDate, endDate = _a.endDate, borderSize = _a.borderSize, fontSize = _a.fontSize, totalAmount = _a.totalAmount, printers = _a.printers;
                        htmlContent = "".concat(bill_template_1.billStyle).concat((0, bill_template_1.headerStart)(pageWidth, startDate, endDate)).concat((0, bill_template_1.tableHeader)(borderSize, fontSize, pageWidth));
                        for (_i = 0, orders_1 = orders; _i < orders_1.length; _i++) {
                            item = orders_1[_i];
                            date = "";
                            if (item["date"]) {
                                date = item["date"].split(" ")[1];
                            }
                            htmlContent += "\n            <tr class=\"\">\n              <td style=\"width:42%;padding:5px;border:".concat(borderSize, "px solid #000;font-size:").concat(fontSize, "px;font-weight:bold;font-family:tahoma\"class=\"c-name\">").concat(item._id, "</td>\n              <td style=\"width:10%;padding:5px;text-align:center;border:").concat(borderSize, "px solid #000;font-size:").concat(fontSize, "px;font-weight:bold;font-family:tahoma\"class=\"c-qty\">\n              ").concat(date, "\n              </td>\n              <td style=\"text-align:center;padding:5px;border:").concat(borderSize, "px solid #000;font-size:").concat(fontSize, "px;font-weight:bold;font-family:tahoma;\"class=\"c-price\">").concat(item.total, "</td>\n            </tr>\n            ");
                        }
                        // customer data
                        // { id: 0, name: '123-ashkan' }
                        htmlContent += "\n        <tr class=\"summary bgorgm\" style=\"\">\n          <td style=\"font-weight:bold;padding:5px;border:".concat(borderSize, "px solid #000;font-family:tahoma;font-size:").concat(fontSize, "px;\"\n          class=\"total-action\" colspan=\"3\"><label>\u062C\u0645\u0639 \u06A9\u0644:</label>\n          <span class=\"total\" style=\"float:left;\">").concat(totalAmount, "</span>\n          </td>\n        </tr>\n        </table>\n     ");
                        setPrinter = [];
                        setPrinter.push(printers["p1"]);
                        save_pdf(htmlContent, path_1.default.join("bills", "all_factor.pdf"), setPrinter);
                        return [2 /*return*/, res.json({ success: true })];
                    });
                }); });
                // The save route is responsible for saving an offline version of each product level
                // including the images
                server.post("/save", function (req, res) { return __awaiter(void 0, void 0, void 0, function () {
                    var items;
                    return __generator(this, function (_a) {
                        items = req.body;
                        // saveLocal(items).then((resp) => {
                        // })
                        return [2 /*return*/, res.json({ success: true })];
                    });
                }); });
                server.all("*", function (req, res) {
                    return handle(req, res);
                });
                server.listen(port, function (err) {
                    if (err)
                        throw err;
                    // console.log(`> Ready on ${basUrl}`);
                    require("child_process").exec("start ".concat(baseU_js_1.default));
                });
                return [3 /*break*/, 3];
            case 2:
                e_1 = _a.sent();
                console.error(e_1);
                process.exit(1);
                return [3 /*break*/, 3];
            case 3: return [2 /*return*/];
        }
    });
}); })();
