"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPrinters = exports.requestPrint = exports.requestPrintOffline = void 0;
var axios_1 = __importDefault(require("axios"));
var baseU_js_1 = __importDefault(require("../baseU.js"));
var requestPrintOffline = function (order) {
    return new Promise(function (resolve, reject) {
        console.log(order);
        resolve('Thanks');
    });
};
exports.requestPrintOffline = requestPrintOffline;
var requestPrint = function (order) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: 'post',
            baseURL: baseU_js_1.default,
            url: '/print',
            headers: {
                'Content-Type': 'application/json',
            },
            data: JSON.stringify(order),
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            if (response.data.success) {
                resolve(response.data);
            }
            else
                reject();
        })
            .catch(function (error) {
            reject();
        });
    });
};
exports.requestPrint = requestPrint;
var getPrinters = function () {
    return new Promise(function (resolve, reject) {
        var config = {
            method: 'get',
            baseURL: baseU_js_1.default,
            url: '/getprinters',
            headers: {},
        };
        (0, axios_1.default)(config)
            .then(function (response) {
            if (!response.data) {
                //   setIsError(true)
                return reject();
            }
            if (response.data.printers.length === 0) {
                return reject;
            }
            else {
                // console.log(response.data)
                var printersArr_1 = [];
                response.data.printers.forEach(function (p) {
                    var printer = { name: p.name };
                    printersArr_1.push(printer);
                });
                // console.log(printersArr)
                resolve(printersArr_1);
            }
        })
            .catch(function (error) {
            console.log(error);
            // setIsError(true)
            reject();
        });
    });
};
exports.getPrinters = getPrinters;
