"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendLogs = exports.sendMatrial = exports.saveMaterialLogs = exports.saveRawItems = exports.saveBranchs = exports.uploadOfflineOrders = exports.submitOrderLocally = exports.requestPrintOffline = void 0;
var table_1 = require("./../services/table");
var router_1 = __importDefault(require("next/router"));
var table_2 = require("services/table");
var order_1 = require("./../services/order");
var crypto_1 = require("crypto");
var axios_1 = __importDefault(require("axios"));
var order_2 = require("../services/order");
var format_1 = require("helpers/format");
var requestPrintOffline = function (order, customer, totalAmount, offline_id, factorID, useDiscount, table_id, print_type, p_bill, printer, note, numPeople, service, reprint, tip, taxPrice, loviuna) {
    var printers = localStorage.getItem("printers") || "[]";
    printers = JSON.parse(printers);
    var prns = {};
    for (var i = 0; i < printers.length; i++) {
        var p = localStorage.getItem(printers[i]) || 0;
        if (printer && printer != printers[i])
            continue;
        if (p) {
            prns[printers[i]] = p;
        }
    }
    var custom_print_valuet = JSON.parse(localStorage.getItem("custom_print_valuet") || "[]");
    var raw_items = JSON.parse(localStorage.getItem("raw_items"));
    if (!print_type)
        print_type = localStorage.getItem("printer_behave_default");
    var p_bar;
    if (table_id) {
        var salon_1 = JSON.parse(localStorage.getItem("salon"));
        var tabales_1 = JSON.parse(localStorage.getItem("tables"));
        if (salon_1 != null)
            Object.keys(salon_1).forEach(function (k) {
                if (tabales_1[k][table_id]) {
                    p_bar = salon_1[k].p_bar;
                }
            });
    }
    var phone = "";
    if (localStorage.getItem("phone"))
        phone = localStorage.getItem("phone");
    var borderSize = localStorage.getItem("borderSize")
        ? JSON.parse(localStorage.getItem("borderSize"))
        : 3;
    var fontSize = localStorage.getItem("fontSize")
        ? JSON.parse(localStorage.getItem("fontSize"))
        : 12;
    var pageWidth = localStorage.getItem("pageWidth")
        ? JSON.parse(localStorage.getItem("pageWidth"))
        : 90;
    (0, order_2.submitOrderOffline)(order, customer, totalAmount, prns, offline_id, custom_print_valuet, raw_items, table_id, factorID, useDiscount, print_type, p_bill, p_bar, phone, note, numPeople, borderSize, fontSize, pageWidth, service, reprint, tip, taxPrice, loviuna)
        .then(function (response) {
        console.log(response);
    })
        .catch(function (err) {
        console.log(err);
    });
};
exports.requestPrintOffline = requestPrintOffline;
var getFactorID = function () {
    var factorID = localStorage.getItem("factorID");
    if (!factorID) {
        localStorage.setItem("factorID", "1");
        factorID = "1";
    }
    else {
        factorID = (parseInt(factorID) + 1).toString();
        localStorage.setItem("factorID", factorID);
    }
    return factorID;
};
var getNewDate = function () {
    return (new Date().getFullYear() +
        "-" +
        (new Date().getMonth() + 1) +
        "-" +
        new Date().getDate() +
        " " +
        new Date().getHours() +
        ":" +
        new Date().getMinutes() +
        ":" +
        new Date().getSeconds());
};
var getOptionsId = function (item) {
    var options_id = [];
    item.options.map(function (i) { return options_id.push(i.id); });
    var id = item.id +
        "_" +
        options_id
            .sort()
            .map(function (i) { return i; })
            .join("_");
    return id;
};
var updateOrder = function (order, customer, totalAmount, orderId, offlineOrders, tableId, customerNote, filteredOrders, paymentTypeDefault, noCustomer, numPeople, useDiscount, discount, price, totalAmount2, note, usePoint, userPoint, service, payment_card, payment_pos, payment_cash, status, print_type, username, tip, name_and_fam, item_price, taxPrice, loviuna) {
    var factorID, offline_id;
    var log = [];
    var localOrders = [];
    if ((offlineOrders || []).length) {
        offlineOrders.map(function (item, i) {
            if (item.id == orderId) {
                factorID = item.local_id;
                offline_id = item.id;
                delete offlineOrders[i];
                return;
            }
            localOrders.push(item);
        });
    }
    offline_id = orderId;
    (0, order_1.findOrder)({ offline_id: orderId }, 1).then(function (res) {
        if (res["order"]) {
            factorID = res["order"]._id;
            var old_order_1 = JSON.parse(res["order"].order_details);
            var _order = (0, order_1.createOrderData)(old_order_1);
            var update_id_1 = [];
            order.map(function (o, i) {
                var id = getOptionsId(o.product);
                if (old_order_1.items[id]) {
                    o["old_qty"] = old_order_1.items[id].qty;
                    log.push({
                        id: o.product.id,
                        qty: o.old_qty,
                        options: o.product.options.length
                            ? "[" + o.product.options.map(function (i) { return i.id; }).join(",") + "]"
                            : "",
                        note: o.note,
                    });
                    update_id_1.push(id);
                }
                if (!customer.name && old_order_1.detail.user_name) {
                    customer = { name: old_order_1.detail.user_name, id: 0 };
                }
            });
            var newOfflineOrder = pushOfflineOrders([], orderId, orderId, filteredOrders, customer, paymentTypeDefault, customerNote, noCustomer, numPeople, tableId, factorID, log, useDiscount);
            var detailOrderOffline = detailsOrderOffline(order, orderId, orderId, factorID, tableId, customer, customerNote, log, useDiscount);
            var cart = {};
            var raw_items = localStorage.getItem("raw_items") || "[]";
            raw_items = JSON.parse(raw_items);
            cart = createCart(order, cart, raw_items);
            // localStorage.setItem(`order-${orderId}`, JSON.stringify({ detail: detailOrderOffline, items: cart }));
            // localStorage.setItem("localOrders", JSON.stringify(localOrders));
            _order.map(function (item, key) {
                var id = getOptionsId(item.product);
                if (!update_id_1.includes(id)) {
                    log.push({
                        id: item.product.id,
                        qty: item.count,
                        options: item.product.options.length
                            ? "[" + item.product.options.map(function (i) { return i.id; }).join(",") + "]"
                            : "",
                        note: item.note,
                    });
                    item["old_qty"] = item.count;
                    item["remove"] = 1;
                    order.push(item);
                }
            });
            var new_status_1 = res["order"].status == -1 ? -1 : status ? status : 2;
            (0, order_1.saveOrderOffline)({
                status: new_status_1,
                total: totalAmount2,
                discount: discount,
                table_id: tableId,
                offline_id: orderId,
                order_details: JSON.stringify({
                    detail: detailOrderOffline,
                    items: cart,
                }),
                order_local: JSON.stringify(newOfflineOrder),
                id: orderId,
                updateDate: getNewDate(),
                note: note,
                use_point: usePoint,
                user_point: userPoint,
                service: service,
                payment_card: payment_card,
                payment_pos: payment_pos,
                payment_cash: payment_cash,
                username: username,
                tip: tip ? tip : "",
                name_and_fam: name_and_fam,
                price: item_price,
                tax: taxPrice,
                loviuna: loviuna,
            }).then(function () {
                if (new_status_1 != -1)
                    (0, exports.requestPrintOffline)(order, customer, totalAmount, orderId, factorID, discount, tableId, print_type, null, null, note, numPeople, service, null, tip ? tip : null, taxPrice, loviuna);
            });
        }
    });
};
var detailsOrderOffline = function (order, orderId, offline_id, factorID, tableId, customer, customerNote, log, useDiscount) {
    return {
        final_price: +(0, format_1.cartTotalPrice)(order).split(" ")[0].split(",").join(""),
        id: orderId ? orderId : offline_id,
        offline_id: offline_id,
        local_id: factorID,
        table_id: tableId,
        user_name: customer.name ? customer.name : "",
        user_number: customer.id,
        user_id: customer.id === 0 ? customer.name : customer.id,
        note: customerNote,
        date_orginal: getNewDate(),
        status_raw: 1,
        pdf_bar: "",
        pdf_customer: "",
        log: log ? log : [],
        discount_id: useDiscount ? useDiscount["id"] : 0,
    };
};
var createCart = function (order, cart, raw_items) {
    order.forEach(function (item) {
        var id = getOptionsId(item.product);
        cart[id] = {
            options: JSON.stringify(item.product.options.map(function (i) { return i.id; })),
            qty: item.count,
            note: item.note ? item.note : "",
            price: raw_items[item.product.id]["last_price"],
            total_price: item.product.options.length
                ? item.product.options
                    .map(function (i) { return i.price; })
                    .reduce(function (accumulator, curr) { return accumulator + curr; }) +
                    raw_items[item.product.id]["last_price"]
                : raw_items[item.product.id]["last_price"],
        };
    });
    return cart;
};
var pushOfflineOrders = function (offlineOrders, orderId, offline_id, filteredOrders, customer, paymentTypeDefault, customerNote, noCustomer, numPeople, tableId, factorID, log, useDiscount) {
    return {
        id: orderId ? orderId : offline_id,
        offline_id: offline_id,
        cart: filteredOrders,
        user_id: customer.id === 0 ? customer.name : customer.id,
        date: Date.now(),
        payment_type: paymentTypeDefault,
        customer_note: customerNote,
        noCustomer: noCustomer,
        orderId: orderId == 0 ? "" : orderId,
        numPeople: numPeople ? numPeople : "",
        table_id: tableId,
        local_id: factorID,
        log: log ? log : [],
        discount_id: useDiscount ? useDiscount["id"] : 0,
    };
};
var submitOrderLocally = function (order, customer, totalAmount, paymentTypeDefault, customerNote, noCustomer, orderId, numPeople, tableId, detailEditOrder, setDetailEditOrder, useDiscount, note, userPoint, usePoint, service, payment_card, payment_pos, payment_cash, offline_id, status, flag, online_table_id, tip, userDiscount, warehouse) {
    return new Promise(function (resolve, _) {
        var tax = localStorage.getItem("tax");
        var username = localStorage.getItem("username");
        var name_and_fam = localStorage.getItem("user_name_and_fam");
        if (!username)
            username = "";
        if (!name_and_fam)
            name_and_fam = "";
        var print_type = localStorage.getItem("printer_behave_default");
        if (flag == 1) {
            print_type = "بدون پرینت";
        }
        var storageOrders = localStorage.getItem("localOrders");
        var table_list = JSON.parse(localStorage.getItem("table_list"));
        if (tableId) {
            if (typeof table_list == "object") {
                if (!(tableId in table_list)) {
                    tableId = "";
                }
            }
            else {
                tableId = "";
            }
        }
        var offlineOrders = [];
        if (storageOrders) {
            offlineOrders = JSON.parse(storageOrders);
        }
        var filteredOrders = [];
        var raw_items = localStorage.getItem("raw_items") || "[]";
        var point_free = localStorage.getItem("point_free")
            ? parseInt(localStorage.getItem("point_free"))
            : 100;
        raw_items = JSON.parse(raw_items);
        var checkPrice = 0;
        var expensive_items_index = {};
        order.forEach(function (item, k) {
            var last_price = raw_items[item.product.id]["last_price"];
            var cat_id = raw_items[item.product.id]["category_id"];
            if (cat_id == 3 && last_price > checkPrice) {
                checkPrice = last_price;
                expensive_items_index["index"] = k;
                expensive_items_index["product_id"] = item.product.id;
                expensive_items_index["name"] = item.product.name;
                expensive_items_index["qty"] = 1;
                expensive_items_index["price"] = last_price;
            }
            filteredOrders.push({
                id: item.product.id,
                qty: item.count,
                options: item.product.options,
                unique: item.product.unique,
                note: item.note,
            });
        });
        var loviuna = null;
        if (userPoint > point_free &&
            usePoint &&
            checkPrice > 0 &&
            expensive_items_index["index"]) {
            // order[expensive_items_index["index"]].product.price = 0;
            var raw_price = raw_items[expensive_items_index["product_id"]]["last_price"];
            totalAmount -= raw_price;
            raw_items[expensive_items_index["product_id"]]["last_price"] = 0;
            loviuna = expensive_items_index;
        }
        var discount = 0;
        var totalAmount2 = totalAmount;
        var item_price = totalAmount;
        var price = totalAmount;
        if (service)
            totalAmount += parseInt(service);
        if (useDiscount["id"] > 0) {
            discount = JSON.parse(localStorage.getItem("discount_list_app"));
            discount = parseInt(discount[useDiscount["id"]].discount);
            discount = Math.round(parseInt(totalAmount) * (discount / 100));
            totalAmount = parseInt(totalAmount) - discount;
        }
        else if (userDiscount > 0) {
            discount = userDiscount;
            discount = Math.round(parseInt(totalAmount) * (discount / 100));
            totalAmount = parseInt(totalAmount) - discount;
            totalAmount2 = totalAmount;
        }
        totalAmount2 = totalAmount;
        if (tip)
            totalAmount2 += parseInt(tip);
        var taxPrice = 0;
        if (tax == "1") {
            taxPrice = Math.round(totalAmount2 * 0.09);
            totalAmount2 += taxPrice;
        }
        totalAmount = (0, format_1.formatPrice)(totalAmount2);
        if (orderId != 0) {
            updateOrder(order, customer, totalAmount, orderId, offlineOrders, tableId, customerNote, filteredOrders, paymentTypeDefault, noCustomer, numPeople, useDiscount, discount, price, totalAmount2, note, usePoint, userPoint, service, payment_card, payment_pos, payment_cash, status, print_type, username, tip, name_and_fam, item_price, taxPrice, loviuna);
            resolve(1);
            return;
        }
        if (!offline_id)
            offline_id = (0, crypto_1.randomBytes)(8).toString("hex");
        var factorID = getFactorID();
        var newOfflineOrder = pushOfflineOrders([], orderId, offline_id, filteredOrders, customer, paymentTypeDefault, customerNote, noCustomer, numPeople, tableId, factorID, [], useDiscount);
        var detailOrderOffline = detailsOrderOffline(order, orderId, offline_id, factorID, tableId, customer, customerNote, [], useDiscount);
        var tables = localStorage.getItem("tables") || "[]";
        tables = JSON.parse(tables);
        if (tableId) {
            Object.keys(tables).map(function (salon) {
                Object.keys(tables[salon]).map(function (table) {
                    if (table == tableId) {
                        tables[salon][table] = [];
                        return tables[salon][table].push(detailOrderOffline);
                    }
                });
            });
        }
        else {
            var checkStatusTable_1 = "";
            Object.keys(tables["no_table"]).map(function (table) {
                if (table == orderId) {
                    checkStatusTable_1 = "add";
                    return (tables["no_table"][table] = [detailOrderOffline]);
                }
            });
            if (checkStatusTable_1 == "") {
                if (Object.keys(tables["no_table"]).length == 0) {
                    tables["no_table"] = {};
                    tables["no_table"][offline_id] = [detailOrderOffline];
                }
                else {
                    tables["no_table"][offline_id] = [detailOrderOffline];
                }
            }
        }
        var cart = {};
        cart = createCart(order, cart, raw_items);
        // localStorage.setItem(
        //   `order-${orderId ? orderId : offline_id}`,
        //   JSON.stringify({
        //     detail: detailOrderOffline,
        //     items: cart
        //   })
        // );
        // localStorage.setItem("tables", JSON.stringify(tables));
        // localStorage.setItem("localOrders", JSON.stringify(offlineOrders));
        var myToken = localStorage.getItem("token");
        // setTimeout(() => {
        //   uploadOfflineOrders(myToken, 1);
        // }, 5400000)
        var itemProductNew = [];
        if (orderId != 0 && detailEditOrder) {
            var newDetailEditOrder_1 = detailEditOrder;
            order.map(function (item, i) {
                var key = order[i].product.id +
                    "_" +
                    order[i].product.options.map(function (o) { return o.id; }).join(",");
                if (newDetailEditOrder_1["items"][key]) {
                    if (item.count - newDetailEditOrder_1["items"][key]["qty"]) {
                        itemProductNew.push(__assign(__assign({}, item), { count: item.count - newDetailEditOrder_1["items"][key]["qty"] }));
                    }
                    delete newDetailEditOrder_1["items"][key];
                }
                else {
                    itemProductNew.push(item);
                }
            });
        }
        var type = localStorage.getItem("branch_type");
        (0, order_1.saveOrderOffline)({
            status: status ? status : type && type == "1" ? 6 : 1,
            total: totalAmount2,
            discount: discount,
            price: price,
            table_id: tableId,
            offline_id: offline_id,
            order_details: JSON.stringify({
                detail: detailOrderOffline,
                items: cart,
            }),
            order_local: JSON.stringify(newOfflineOrder),
            date: getNewDate(),
            revision_num: 0,
            note: note,
            use_point: usePoint,
            user_point: userPoint,
            service: service,
            payment_card: payment_card,
            payment_pos: payment_pos,
            payment_cash: payment_cash,
            flag: flag ? flag : 0,
            online_table_id: online_table_id ? online_table_id : "",
            username: username,
            tip: tip ? tip : "",
            name_and_fam: name_and_fam,
            tax: taxPrice,
            loviuna: loviuna,
        }).then(function (r) {
            if (r["order"].status == 6 && warehouse) {
                (0, exports.saveMaterialLogs)(r);
            }
            (0, exports.requestPrintOffline)(itemProductNew.length ? itemProductNew : order, customer, totalAmount, offline_id, r["order"]._id, discount, tableId, print_type, null, null, note, numPeople, service, null, tip ? tip : null, taxPrice, loviuna);
            resolve(1);
        });
    });
};
exports.submitOrderLocally = submitOrderLocally;
var uploadOfflineOrders = function (token, indexItem, warehouse) {
    return new Promise(function (resolve, reject) {
        // token = localStorage.getItem('token');
        // let storageOrders = localStorage.getItem("localOrders");
        // console.log(JSON.stringify(storageOrders))
        var time = 60000;
        var iterval = localStorage.getItem("iterval");
        if (iterval) {
            time = parseInt(iterval);
        }
        if (warehouse) {
            (0, exports.sendMatrial)();
            (0, exports.sendLogs)();
        }
        (0, exports.saveBranchs)(token);
        var interval_id = window.setInterval(function () {
            if (warehouse)
                (0, exports.sendLogs)();
            (0, exports.saveBranchs)(token, indexItem).then(function (res) {
                resolve(res);
            });
        }, time);
        for (var i = 1; i < interval_id; i++) {
            window.clearInterval(i);
        }
        // Clear any timeout/interval up to that id
    });
};
exports.uploadOfflineOrders = uploadOfflineOrders;
var saveBranchs = function (token, indexItem) {
    if (indexItem === void 0) { indexItem = 0; }
    return new Promise(function (resolve, reject) {
        (0, order_1.saveBranch)({ id: 1 }).then(function (res) {
            if (!res["order"] || !res["order"].token) {
                localStorage.removeItem("token");
                router_1.default.push("/location");
            }
            (0, order_1.findOrder)({
                status: 6,
                just_status: 6,
                limit: 1,
                skip: 0,
                sort: 1,
            }).then(function (order) {
                if (order["order"].length) {
                    var localOrders_1 = [];
                    order["order"].map(function (o) {
                        var local = JSON.parse(o.order_local);
                        local.table_id = o.table_id;
                        delete local["id"];
                        local.local_id = o._id;
                        local.first_price = o.price;
                        local.revision_num = o.revision_num > 0 ? o.revision_num : null;
                        local.use_point = o.use_point ? o.use_point : false;
                        local.note = o.note ? o.note : "";
                        local.customer_note = o.note ? o.note : "";
                        local.service = o.service ? parseInt(o.service) * 10000 : 0;
                        local.payment_card = o.payment_card
                            ? parseInt(o.payment_card) * 10000
                            : 0;
                        local.payment_pos = o.payment_pos
                            ? parseInt(o.payment_pos) * 10000
                            : 0;
                        local.payment_cash = o.payment_cash
                            ? parseInt(o.payment_cash) * 10000
                            : 0;
                        local.discount = o.discount ? parseInt(o.discount) * 10000 : 0;
                        local.tip = o.tip ? parseInt(o.tip) * 10000 : 0;
                        local.updateDate = o.updateDate ? o.updateDate : "";
                        local.sale_id = o.username ? o.username : "";
                        local.edit_log = local.log;
                        local.total = o.price;
                        local.poz_response = o.poz_response;
                        local.vat = o.tax ? parseInt(o.tax) * 10000 : 0;
                        delete local.log;
                        if (o.flag == 1)
                            local.order_id = o.offline_id;
                        localOrders_1.push(local);
                    });
                    var data = new FormData();
                    data.append("token", res["order"].token);
                    data.append("offline_v2", JSON.stringify(localOrders_1));
                    var config = {
                        method: "post",
                        url: "/submit-order",
                        data: data,
                    };
                    (0, axios_1.default)(config)
                        .then(function (response) {
                        if (!response) {
                            resolve(true);
                            return;
                        }
                        if (!response.data.length) {
                            resolve(true);
                            return;
                        }
                        response.data.forEach(function (item, k) {
                            (0, order_1.saveOrderOffline)({
                                id: item.offline_id,
                                status: 20,
                            });
                        });
                        //TODO: check if all offline bills submitted
                        resolve(true);
                    })
                        .catch(function (err) {
                        console.log(err);
                        reject(err);
                    });
                }
                else {
                    resolve(true);
                }
            });
        });
    });
};
exports.saveBranchs = saveBranchs;
var saveRawItems = function () {
    return new Promise(function (resolve, reject) {
        (0, table_2.getRawItems)().then(function (res) {
            if (res) {
                localStorage.setItem("raw_items", JSON.stringify(res));
                resolve(true);
            }
        });
    });
    // if (!localStorage.getItem("raw_items"))
};
exports.saveRawItems = saveRawItems;
var saveMaterialLogs = function (order) {
    var details = JSON.parse(order["order"].order_local);
    if (details) {
        details = details["cart"];
        if ((details || []).length) {
            var qtyData_1 = {};
            var sendData_1;
            details.map(function (item) {
                sendData_1 = new Promise(function (resolve, reject) {
                    (0, table_1.request)({ _id: 1 }, "/api/find2?model=Material&one=1").then(function (m) {
                        var data = m["data"][item.id];
                        if (data) {
                            Object.keys(data).map(function (obj) {
                                var qty = parseFloat(data[obj]) * item.qty;
                                qty = Math.round(qty * 1000) / 1000;
                                if (qtyData_1[obj])
                                    qtyData_1[obj] += qty;
                                else
                                    qtyData_1[obj] = qty;
                                qtyData_1[obj] = Math.round(qtyData_1[obj] * 1000) / 1000;
                                // saveMaterialLog({ _id: obj, qty: qty, id: obj });
                            });
                        }
                        item["options"].map(function (op) {
                            var data = m["data"][op.id];
                            if (data) {
                                Object.keys(data).map(function (obj) {
                                    var qty = parseFloat(data[obj]) * item.qty;
                                    qty = Math.round(qty * 1000) / 1000;
                                    if (qtyData_1[obj])
                                        qtyData_1[obj] += qty;
                                    else
                                        qtyData_1[obj] = qty;
                                    qtyData_1[obj] = Math.round(qtyData_1[obj] * 1000) / 1000;
                                    // saveMaterialLog({ _id: obj, qty: qty, id: obj });
                                });
                            }
                        });
                        // console.log(qtyData);
                        resolve(qtyData_1);
                    });
                });
            });
            sendData_1.then(function (send) {
                console.log("final", send);
                (0, table_1.saveMaterialLog)({ data: send });
            });
            //
        }
    }
};
exports.saveMaterialLogs = saveMaterialLogs;
var sendMatrial = function () {
    return new Promise(function (resolve, reject) {
        (0, table_1.request)({}, "/api/find2?model=MaterialLog").then(function (res) {
            if (res) {
                var data = new FormData();
                data.append("data", JSON.stringify(res));
                data.append("token", localStorage.getItem("token"));
                var config = {
                    method: "post",
                    url: "/sync-qty",
                    data: data,
                };
                (0, axios_1.default)(config)
                    .then(function (response) {
                    if ((response.data[0] || []).length) {
                        response.data[0].map(function (item) {
                            (0, table_1.saveMaterialLog)({ _id: item, remove: true });
                        });
                        resolve(res);
                    }
                })
                    .catch(function (err) {
                    console.log(err);
                    reject(err);
                });
            }
        });
    });
};
exports.sendMatrial = sendMatrial;
var sendLogs = function () {
    return new Promise(function (resolve, reject) {
        (0, table_1.request)({ status: 0 }, "/api/find2?model=Log&one=1").then(function (res) {
            if (res) {
                var data = new FormData();
                data.append("id", res["_id"]);
                data.append("item_id", res["item_id"]);
                data.append("qty", res["qty"]);
                data.append("info", res["info"]);
                data.append("token", localStorage.getItem("token"));
                var config = {
                    method: "post",
                    url: "https://viunaorder.avishost.com/restapi/save_single_ingredient_log",
                    data: data,
                };
                (0, axios_1.default)(config)
                    .then(function (response) {
                    if (response.data["status"]) {
                        (0, table_1.saveLog)({ id: res["_id"], status: 1 });
                        resolve(res);
                    }
                })
                    .catch(function (err) {
                    console.log(err);
                    reject(err);
                });
            }
        });
    });
};
exports.sendLogs = sendLogs;
