"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseInputValue = exports.e2p = exports.p2e = exports.cartTotalTax = exports.cartTotalPrice2 = exports.roundFinalPrice = exports.cartTotalPrice = exports.formatPrice2 = exports.formatPrice = void 0;
function formatPrice(price) {
    price *= 1000;
    var formattedPrice = price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return formattedPrice + " تومان";
}
exports.formatPrice = formatPrice;
function formatPrice2(price) {
    price *= 1000;
    var formattedPrice = price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return formattedPrice;
}
exports.formatPrice2 = formatPrice2;
function cartTotalPrice(cart, tax) {
    var totalPrice = cart
        .map(function (item) { return item.product.price * item.count; })
        .reduce(function (prev, next) { return prev + next; }, 0);
    if (tax === "1") {
        var taxPrice = totalPrice * 1000 * 0.09;
        totalPrice += taxPrice / 1000;
    }
    var finalPrice = formatPrice(roundFinalPrice(totalPrice));
    return finalPrice;
}
exports.cartTotalPrice = cartTotalPrice;
function roundFinalPrice(totalPrice) {
    var text = (totalPrice * 1000).toString();
    var replacement = "00";
    var result = text.substring(0, text.length - 2) + replacement;
    var finalPrice = parseInt(result) / 1000;
    return finalPrice;
}
exports.roundFinalPrice = roundFinalPrice;
function cartTotalPrice2(cart) {
    var totalPrice = cart
        .map(function (item) { return item.product.price * item.count; })
        .reduce(function (prev, next) { return prev + next; }, 0);
    return totalPrice;
}
exports.cartTotalPrice2 = cartTotalPrice2;
function cartTotalTax(totalPrice, tax) {
    if (tax !== "1")
        return totalPrice;
    var taxPrice = totalPrice * 1000 * 0.09;
    taxPrice = taxPrice;
    return taxPrice / 1000;
}
exports.cartTotalTax = cartTotalTax;
var p2e = function (s) { return s.replace(/[۰-۹]/g, function (d) { return "۰۱۲۳۴۵۶۷۸۹".indexOf(d); }); };
exports.p2e = p2e;
var e2p = function (s) { return s.replace(/\d/g, function (d) { return "۰۱۲۳۴۵۶۷۸۹"[d]; }); };
exports.e2p = e2p;
var parseInputValue = function (value, number) {
    if (number === void 0) { number = false; }
    if (value) {
        value = (0, exports.p2e)(value);
        if (/\D/g.test(value) && number) {
            value = value.replace(/[^0-9.-]/g, "");
        }
        return value;
    }
    return value;
};
exports.parseInputValue = parseInputValue;
