"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.saveLocal = exports.saveBill5 = exports.saveBill = exports.printLocal = exports.download = void 0;
var axios_1 = __importDefault(require("axios"));
var fs_1 = __importDefault(require("fs"));
var path_1 = __importDefault(require("path"));
var pdf_to_printer_1 = __importDefault(require("pdf-to-printer"));
function download(url, filename) {
    fetch(url).then(function (t) {
        return t.blob().then(function (b) {
            var a = document.createElement('a');
            a.href = URL.createObjectURL(b);
            a.setAttribute('download', filename);
            a.click();
        });
    });
}
exports.download = download;
function downloadImage(url, target) {
    // console.log(`saving ${url} into ${target}`)
    return new Promise(function (resolve, reject) {
        (0, axios_1.default)({
            url: url,
            responseType: 'stream',
        }).then(function (response) { return response.data.pipe(fs_1.default.createWriteStream(target)).on('finish', resolve).on('error', reject); });
    });
}
function downloadFile(url, target, printer) {
    if (printer === void 0) { printer = ''; }
    // console.log(`saving ${url} into ${target}`)
    return new Promise(function (resolve, reject) {
        (0, axios_1.default)({
            url: url,
            responseType: 'stream',
        }).then(function (response) {
            return response.data
                .pipe(fs_1.default.createWriteStream(target))
                .on('finish', function () {
                var options = {
                    printer: printer,
                    unix: ['-o fit-to-page'],
                    win32: ['-print-settings "noscale"'],
                };
                if (fs_1.default.existsSync(target)) {
                    pdf_to_printer_1.default.print(target, options).then(function (res) {
                        resolve(true);
                    }).catch(function (err) {
                        resolve(true);
                    });
                }
                else
                    resolve(true);
            })
                .on('error', reject);
        }).catch(function (err) {
            reject(err);
        });
    });
}
var printLocal = function (page, orderId, printer) {
    var basePath = path_1.default.resolve(__dirname, '..', '..', 'bills');
    var filePath = path_1.default.resolve(basePath, orderId + '.pdf');
    if (fs_1.default.existsSync(filePath)) {
        fs_1.default.unlinkSync(filePath);
    }
    return downloadFile(page, filePath, printer);
};
exports.printLocal = printLocal;
var saveBill = function (printers, orderId) {
    var basePath = path_1.default.resolve(__dirname, '..', '..', 'bills');
    return Promise.all(printers.map(function (item) {
        var filePath = path_1.default.resolve(basePath, orderId + '-' + item.id + '.pdf');
        if (fs_1.default.existsSync(filePath)) {
            // console.log('deleting existing img')
            fs_1.default.unlinkSync(filePath);
        }
        return downloadFile(item.page, filePath, item.name);
    }));
};
exports.saveBill = saveBill;
var saveBill5 = function (printers, orderId) {
    var basePath = path_1.default.resolve(__dirname, '..', '..', 'bills');
    var filePath = path_1.default.resolve(basePath, orderId + '-' + printers.id + '.pdf');
    if (fs_1.default.existsSync(filePath)) {
        // console.log('deleting existing img')
        fs_1.default.unlinkSync(filePath);
    }
    return downloadFile(printers.page, filePath, printers.name);
    // })
    // )
};
exports.saveBill5 = saveBill5;
var saveLocal = function (items) {
    var basePath = path_1.default.resolve(__dirname, '..', '..', 'public', 'images', 'products');
    return Promise.all(items.map(function (item) {
        var filePath = path_1.default.resolve(basePath, item.id + '.jpeg');
        if (fs_1.default.existsSync(filePath)) {
            // console.log('deleting existing img')
            fs_1.default.unlinkSync(filePath);
        }
        return downloadImage(item.img, filePath);
    }));
};
exports.saveLocal = saveLocal;
