"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.request = exports.saveMaterialLog = exports.saveMaterial = exports.getMaterial = exports.printChangeTable = exports.setQuery = exports.getPrintLocal = exports.requestPrintTablet = exports.requestRepeatPrint = exports.changeTable = exports.changeStatus = exports.getRawItems = exports.getDetail = exports.getTable2 = exports.getTable = void 0;
var order_1 = require("./order");
var axios_1 = __importDefault(require("axios"));
var baseU_js_1 = __importDefault(require("../baseU.js"));
var apiUrl_1 = __importDefault(require("apiUrl"));
var status_text = {
    0: 'معلق',
    1: ' باز ',
    2: 'ویرایش ',
    3: 'کنسل ',
    4: ' چاپ شده ',
    5: 'پرداخت  و مانده',
    6: 'پرداخت  و رفته',
    7: 'DIGI JET',
    10: 'refund',
};
var getTable = function () {
    return new Promise(function (resolve, reject) {
        var brancId = localStorage.getItem("user_client_id");
        var url = apiUrl_1.default[0] + "/in-branch-order/table?branch_id=" + brancId + "&offline=1";
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getTable = getTable;
var getTable2 = function () {
    return new Promise(function (resolve, reject) {
        var brancId = localStorage.getItem("user_client_id");
        var url = apiUrl_1.default[0] + "/in-branch-order/table_offline?branch_id=" + brancId;
        axios_1.default
            .get(url)
            .then(function (res) {
            if (res)
                resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getTable2 = getTable2;
var getDetail = function (id) {
    return new Promise(function (resolve, reject) {
        var url = apiUrl_1.default[0] + "/in-branch-order/table_detail2?order_id=" + id;
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getDetail = getDetail;
var getRawItems = function () {
    return new Promise(function (resolve, reject) {
        var url = apiUrl_1.default[0] + "/in-branch-order/raw_items";
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getRawItems = getRawItems;
var changeStatus = function (order_id, st_id) {
    return new Promise(function (resolve, reject) {
        var url = apiUrl_1.default[0] + "/in-branch-order/table_change_st?order_id=" + order_id + "&st_id=" + st_id;
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.changeStatus = changeStatus;
var changeTable = function (order_id, table_id) {
    return new Promise(function (resolve, reject) {
        console.log(order_id);
        console.log(table_id);
        order_1.saveOrderOffline({
            id: order_id,
            table_id: table_id
        }).then(function (res) {
            if (res['order']) {
                var r = res['order'];
                var d = JSON.parse(r.order_details);
                var data = {
                    final_price: r.total,
                    id: r.offline_id,
                    local_id: r.id,
                    table_id: r.table_id,
                    user_name: d.user_name,
                    user_id: d.user_id,
                    note: d.customer_note,
                    date: r.date,
                    date_orginal: r.date,
                    status_raw: r.status,
                    status: status_text[r.status],
                    pdf_customer: '',
                    pdf_bar: ''
                };
                resolve(data);
            }
        });
        // saveOrder
    });
};
exports.changeTable = changeTable;
var requestRepeatPrint = function (order_id) {
    return new Promise(function (resolve, reject) {
        var url = apiUrl_1.default[0] + "/in-branch-order/table_print_all?order_id=" + order_id;
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.requestRepeatPrint = requestRepeatPrint;
var requestPrintTablet = function (order_id) {
    return new Promise(function (resolve, reject) {
        var url = apiUrl_1.default[0] + "/in-branch-order/table_print_tablet?order_id=" + order_id;
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.requestPrintTablet = requestPrintTablet;
var getPrintLocal = function (page, order_id, printer) {
    return new Promise(function (resolve, reject) {
        var url = baseU_js_1.default + "/printLocal?page=" + page + "&order_id=" + order_id + "&printer=" + printer;
        axios_1.default
            .get(url)
            .then(function (res) {
            resolve(res.data);
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getPrintLocal = getPrintLocal;
var setQuery = function (type, order_id, table_id, st_id) {
    // set query for server
    var queryList = localStorage.getItem("queryList");
    if (!queryList) {
        localStorage.setItem("queryList", "[]");
        queryList = localStorage.getItem("queryList");
    }
    queryList = JSON.parse(queryList);
    var newQuery = {
        type: type,
        order_id: order_id || "",
        table_id: table_id || "",
        st_id: st_id || "",
        date: Date.now(),
    };
    queryList.push(newQuery);
    localStorage.setItem("queryList", JSON.stringify(queryList));
    setTimeout(function () {
        queryList = localStorage.getItem("queryList") || '[]';
        queryList = JSON.parse(queryList);
        if (type == "setStatus") {
            exports.changeStatus(order_id, st_id);
            queryList = queryList.filter(function (item) { return item.order_id != order_id && item.st_id != st_id; });
        }
        else if (type == "changeTable") {
            exports.changeTable(order_id, table_id);
            queryList = queryList.filter(function (item) { return item.order_id != order_id && item.table_id != table_id; });
        }
        localStorage.setItem("queryList", JSON.stringify(queryList));
    }, 5400000);
};
exports.setQuery = setQuery;
var printChangeTable = function (prewTable, nextTable) {
    var printer = localStorage.getItem('p2') || '';
    if (!printer)
        return;
    var phone = ' ';
    if (localStorage.getItem('phone'))
        phone = localStorage.getItem('phone');
    var url = baseU_js_1.default + "/printChangeTable?prewTable=" + prewTable + "&nextTable=" + nextTable + "&printer=" + printer + "&phone=" + phone;
    axios_1.default
        .get(url)
        .then(function (res) {
        return;
    })
        .catch(function (err) {
        return;
    });
};
exports.printChangeTable = printChangeTable;
var getMaterial = function () {
    return new Promise(function (resolve, reject) {
        var url = apiUrl_1.default[0] + "/in-branch-item/qty-detail";
        axios_1.default
            .get(url)
            .then(function (res) {
            if (res.data) {
                resolve(res.data);
                console.log({ data: res.data });
                exports.saveMaterial({ data: res.data });
            }
        })
            .catch(function (err) {
            reject(err);
        });
    });
};
exports.getMaterial = getMaterial;
var saveMaterial = function (req) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: 'post',
            baseURL: baseU_js_1.default,
            url: 'api/material',
            headers: {
                'Content-Type': 'application/json',
            },
            data: JSON.stringify(req),
        };
        axios_1.default(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.saveMaterial = saveMaterial;
var saveMaterialLog = function (req) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: 'post',
            baseURL: baseU_js_1.default,
            url: 'api/material_log',
            headers: {
                'Content-Type': 'application/json',
            },
            data: JSON.stringify(req),
        };
        axios_1.default(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.saveMaterialLog = saveMaterialLog;
var request = function (req, url) {
    return new Promise(function (resolve, reject) {
        var config = {
            method: 'post',
            baseURL: baseU_js_1.default,
            url: url,
            headers: {
                'Content-Type': 'application/json',
            },
            data: JSON.stringify(req),
        };
        axios_1.default(config)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.request = request;
