import { toast } from "react-toastify";

export const addToOrder = (
  e,
  isCat,
  onSelect,
  data,
  order,
  id,
  setOrder,
  price,
  name,
  count
) => {
  // console.log(data)
  if (price > 0) price *= 1000;
  let noAdd = false;
  if (e != false && data.option?.length != 0) {
    document.querySelectorAll(`#i${id} *`).forEach((item) => {
      if (e.target == item) noAdd = true;
    });
  }
  if (noAdd) return;
  if (isCat) {
    onSelect(data);
  } else {
    const isDuplicateOrder = order.some((item, idx) => {
      if (
        item.product.id === Number(id) &&
        Object.keys(item.product.options).length === 0
      ) {
        let garbage = [...order];
        ++garbage[idx].count;
        setOrder([...garbage]);
        return true;
      }
      return false;
    });
    if (!isDuplicateOrder) {
      setOrder([
        ...order,
        {
          product: {
            name,
            baseName: name,
            id: Number(id),
            price,
            options: [],
            unique: `${id}-${name}`,
            vat_include: data['vat_include']
          },
          count: count,
        },
      ]);
    }
    toast("محصول به سبد خرید اضافه شد .", {
      position: "bottom-right",
      type: "success",
      style: { direction: "rtl", fontFamily: "IRANSansX" },
      theme: "colored",
    });
  }
};
