import React, { PropsWithChildren } from 'react'
import Head from 'next/head'

interface Props extends PropsWithChildren<{}> { }

const PageTitle = (props: Props) => {
  const { children } = props
  const title = children || ''
  return (
    <Head>
      <title>
        {title}
        {title ? ' - ' : ''}
        Viuna Cafe - کافه ویونا
      </title>
    </Head>
  )
}

export default PageTitle
