import React from 'react'
import Link from 'next/link'
import Image from 'next/image'
import ImageComponent from './image-component'
import config from "../../config";

export enum logoType {
  Full = 'logo-full.png',
  White = 'logo-w.png',
  Black = 'logo-b.png',
  Text = 'viuna.png',
  Gold = 'logo-g.png',
}

const Logo = ({ w = 260, h = 75, type = logoType.Full }) => {
  return (
    <div className="flex items-center ">
      <Link href="/" aria-label="Homepage">
        <a className="px-2 flex-0 md:px-4 md:mt-4">
          <div className="inline-block  full-logo-">
            <ImageComponent src={`/images/logo/${type}`} layout="fixed" width={w} height={h} alt="viuna full logo" />
            <span className={'hidden lg:inline text-gray-400'} style={{ fontSize: '0.8rem' }}>
              نسخه
              <span className={'mr-2'}>{config.version}</span>
            </span>
          </div>
        </a>
      </Link>
    </div>
  )
}

export default Logo
