import { createContext, useContext, useState } from "react";

let globalSetRefresh = null;

const RefreshContext = createContext(null);

export const RefreshProvider = ({ children }) => {
  const [customRefresh, setCustomRefresh] = useState(0);
  globalSetRefresh = setCustomRefresh;

  return (
    <RefreshContext.Provider value={{ customRefresh, setCustomRefresh }}>
      {children}
    </RefreshContext.Provider>
  );
};

export const useCustomRefresh = () =>{
    return useContext(RefreshContext);
}

export const triggerRefresh = () => {
  if (globalSetRefresh) {
    globalSetRefresh((prev) => prev + 1);
  }
};