import IMenuItem from 'interfaces/menuItem'
import {useProductContext} from './Products'
import React from "react";
import AddToOrderButton from "./AddToOrderButton";
import AdditionalOptionsMenu from "./AdditionalOptionsMenu";
import { addToOrder } from './shared/addToOrder';

function classNames(...classes) {
    return classes.filter(Boolean).join(' ')
}

const TextMenuItem = ({data, index, onSelect}) => {

    const {name, isCat, price, id}: IMenuItem = data
    const {setOrder, order} = useProductContext()
    return (
        <div
            key={index}
            className={classNames(
                'relative group bg-white px-4 py-2 focus-within:ring-2 focus-within:ring-inset focus-within:ring-indigo-500',
                isCat ? 'bg-yellow-100 ' : '',
            )}
        >
            <div>
            </div>
            <div className='h-full'>
                {isCat ? (
                    <h3 className="text-lg font-medium cursor-pointer h-full"
                        onClick={() => onSelect(data)}>
                        <div className={'flex justify-between items-center h-full'}>
                            <span style={{fontSize: '0.9rem'}} className="flex">
                                <span
                                    className={'border-l pl-2 text-gray-500 text-baseline border-black ml-4'}>{index + 1}</span>
                                <span  className="ltr" style={{textAlign: 'right'}}>{name}</span>
                            </span>
                        </div>
                    </h3>
                ) : (
                    <>
                        <h3 className="text-lg font-medium" onClick={(e) => addToOrder(e, isCat, onSelect, data, order, id, setOrder, price, name, 1)}>
                            <div className={'flex justify-between items-center'}>
                            <span style={{fontSize: '0.9rem'}} className="flex">
                                <span
                                    className={'border-l pl-2 text-gray-500 text-baseline border-black ml-4'}>{index + 1}</span>
                                <span  className="ltr" style={{textAlign: 'right'}}>{name}</span>
                            </span>
                                {
                                    isCat ?
                                        '' :
                                        (
                                            <div className={'flex justify-center items-center'}>
                                                <AdditionalOptionsMenu data={data} idel={id}/>
                                                <div className={'rounded-md bg-yellow-400'} style={{padding: '3px 6px', fontSize: '0.9rem'}}>
                                                    {price}
                                                </div>
                                                <AddToOrderButton noClick={true} order={order} setOrder={setOrder}
                                                                  onSelect={onSelect} id={id} name={name}
                                                                  data={data} isCat={isCat} price={price}
                                                />
                                            </div>
                                        )
                                }
                            </div>
                        </h3>
                    </>
                )}
            </div>
        </div>
    )
}
export default TextMenuItem
