import React from 'react';
import IMenuItem from "../interfaces/menuItem";
import TextMenuItem from "./TextMenuItem";



function TextMenu({menuItems, onSelectCategory}) {
    return (

        <div
            className="rounded-lg mx-auto max-w-7xl bg-gray-200 shadow divide-y divide-gray-200 grid grid-cols-1 sm:divide-y-0 sm:grid sm:grid-cols-2 xl:grid-cols-3 sm:gap-px mb-20">
            {menuItems.map((menuItem: IMenuItem, index: number) => (
                <TextMenuItem data={menuItem} key={index} index={index} onSelect={onSelectCategory}/>
            ))}
        </div>
    );
}

export default TextMenu;