import React, { Fragment } from "react";
import { useRouter } from "next/router";
import { useEffect } from "react";
import { useState } from "react";
import ImageComponent from "./shared/image-component";
import ReactTooltip from "react-tooltip";
import { findOrder, removeOrder, saveOrderOffline } from "services/order";
import Pagination from "./Pagination";
import OrderDetails from "./OrderDetails";
import { useProductContext } from "./Products";

const Table = ({
  salon,
  tables,
  setTableFullSelected,
  tableFullSelected,
  tableEmptySelected,
  setTableEmptySelected,
  getDetailOrder,
  setStatus,
  repeatPrint,
  printTablet,
  printLocal,
  setDetailEditOrder,
  setOrder,
  saveLocalyDetailOrder,
  renderDetailsOrderInCart,
  offline,
  page,
  setPage,
  updateTables,
  pages,
  getNewOrder,
  tbl1,
  setTbl1,
  tbl2,
  setTbl2,
  mergeTable,
}) => {
  //
  const { refresh, setRefresh } = useProductContext();
  const router = useRouter();
  const [seconds, setSeconds] = useState(1);
  const [showModal, setShowModal] = useState(false);
  const [details, setDetails] = useState([]);
  const [order, setOrders] = useState({});

  useEffect(() => {
    const timer = setInterval(() => {
      setSeconds(seconds + 1);
    }, 100);
    // clearing interval
    return () => clearInterval(timer);
  }, [tables]);

  const getTM = (time) => {
    let oldTime = new Date(time).getTime();
    let nowTime = new Date().getTime();
    let distanceTimes = nowTime - oldTime;

    let hours = Math.floor(
      (distanceTimes % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60)
    );
    let minutes = Math.floor((distanceTimes % (1000 * 60 * 60)) / (1000 * 60));
    let secends = Math.floor((distanceTimes % (1000 * 60)) / 1000);

    return `${hours < 10 ? "0" + hours : hours}:${minutes < 10 ? "0" + minutes : minutes
      }:${secends < 10 ? "0" + secends : secends}`;
  };

  const getOrder = async (
    id,
    repeat?,
    salon?,
    printer?,
    reprint?,
    print_type?
  ) => {

    findOrder({ offline_id: id }, 1).then((order) => {
      if (order["order"]) {
        let o = JSON.parse(order["order"].order_details);
        let local = JSON.parse(order["order"].order_local);
        o["detail"].table_id = order["order"].table_id;
        o["detail"].use_point = order["order"].use_point
          ? order["order"].use_point
          : false;
        o["detail"].user_point = order["order"].user_point
          ? order["order"].user_point
          : 0;
        o["detail"].service = order["order"].service
          ? order["order"].service
          : "";
        o["detail"].tip = order["order"].tip ? order["order"].tip : "";
        o["detail"].payment_card = order["order"].payment_card
          ? order["order"].payment_card
          : "";
        o["detail"].payment_pos = order["order"].payment_pos
          ? order["order"].payment_pos
          : "";
        o["detail"].payment_cash = order["order"].payment_cash
          ? order["order"].payment_cash
          : "";
        o["detail"].numPeople = local.numPeople ? local.numPeople : "";
        o["detail"].note = order["order"].note ? order["order"].note : "";
        o["detail"].userDiscount = order["order"].userDiscount ? order["order"].userDiscount : "";
        o["detail"].isOnline = order["order"].isOnline;
        if (salon) o["salon"] = salon;
        if (printer) o["printer"] = printer;

        renderDetailsOrderInCart(
          o,
          repeat,
          order["order"],
          reprint ? reprint : 0,
          print_type ? print_type : ""
        );
      }
    });
  };

  const showDetails = (offline_id) => {
    findOrder({ offline_id: offline_id }, 1).then((order) => {
      if (order["order"]) {
        let order_obj = order["order"];
        let o = JSON.parse(order_obj.order_details);
        let local = JSON.parse(order["order"].order_local);

        o["detail"].table_id = order_obj.table_id;
        o["detail"].use_point = order_obj.use_point
          ? order_obj.use_point
          : false;
        o["detail"].user_point = order_obj.user_point
          ? order_obj.user_point
          : 0;
        o["detail"].service = order_obj.service ? order_obj.service : "";
        o["detail"].payment_card = order_obj.payment_card
          ? order_obj.payment_card
          : "";
        o["detail"].payment_pos = order_obj.payment_pos
          ? order_obj.payment_pos
          : "";
        o["detail"].payment_cash = order_obj.payment_cash
          ? order_obj.payment_cash
          : "";
        let newOrder = getNewOrder(o);
        let ord = {
          total: order_obj.total,
          discount: order_obj.discount,
          service: order_obj.service,
          note: order_obj.note,
          revision_num: order_obj.revision_num,
          table_id: order_obj.table_id,
          customer: o["detail"].user_name,
          numPeople: local.numPeople ? local.numPeople : "",
          username: order_obj.username ? order_obj.username : "",
          tip: order_obj.tip ? order_obj.tip : "",
          name_and_fam: order_obj.name_and_fam,
          tax: order_obj.tax,
          loviuna: order_obj.loviuna,
        };
        setDetails(newOrder);
        setOrders(ord);
        setShowModal(true);
      }
    });
  };

  const handleRemoveOrder = (id) => {
    if (window.confirm("آیا مطمئن هستید؟")) {
      removeOrder(id).then((res) => {
        if (res) {
          findOrder({ removeOrder: 1, offline_id: id }).then((r) => {
            if (r["order"].acknowledged === true) {
              updateTables();
            }
          });
          return;
        } else {
          findOrder({ offline_id: id }, 1).then((r) => {
            if (r["order"].remove_flag != 1) {
              saveOrderOffline({
                id: id,
                remove_flag: 1,
              });
            } else {
              findOrder({ removeOrder: 1, offline_id: id }).then((r) => {
                if (r["order"].acknowledged === true) {
                  updateTables();
                }
              });
            }
          });
        }
      });
    }
  };
  
  const sendToMerge = (id, tableId) => {
    findOrder(
      {
        status: 6,
        table_id: tableId,
      },
      1
    ).then((res) => {
      mergeTable(id, res["order"].offline_id);
    });
  };



  return (
    <Fragment>
      <style jsx>{`
        .bg-neutral-500 {
          background-color: #adadad;
        }
      `}</style>
      {Object.keys(tables[salon]).map((sln, i) => (
        <div
          style={{ maxWidth: "600px" }}
          key={sln + "-" + i}
          className={`block select-none rounded-lg shadow-lg max-w-sm text-center text-xs lg:w-40 w-full m-auto ${tableEmptySelected == sln
            ? "border-2 border-blue-500"
            : tables[salon][sln].length
              ? tableFullSelected == tables[salon][sln][0].id
                ? "border-2 border-blue-500"
                : ""
              : ""
            } ${[4, 5, 6, 20].includes(
              tables[salon][sln].length ? tables[salon][sln][0].status_raw : ""
            )
              ? "bg-green-300"
              : tables[salon][sln].length == 0
                ? "bg-neutral-500"
                : tables[salon][sln][0].status_raw == -1
                  ? "bg-yellow-300"
                  : "bg-red-300"
            }`}
          onDoubleClick={(e) => {
            if (tables[salon][sln].length && salon != "settled") {
              if (
                tableFullSelected != "" &&
                tableFullSelected != tables[salon][sln][0].id
              )
                return;
              setTableFullSelected(
                tableFullSelected
                  ? ""
                  : {
                    id: tables[salon][sln][0].id,
                    table_id: salon == "no_table" ? "" : sln,
                  }
              );
              e.currentTarget.classList.toggle("border-2");
              e.currentTarget.classList.toggle("border-blue-500");
            }
          }}
          onClick={(e) => {
            if (!tables[salon][sln].length && salon != "settled") {
              if (tableFullSelected) {
                if (tableEmptySelected != "" && tableEmptySelected != sln)
                  return;
                setTableEmptySelected(tableEmptySelected ? "" : sln);
                e.currentTarget.classList.toggle("border-2");
                e.currentTarget.classList.toggle("border-blue-500");
              } else {
                setOrder([]);
                setDetailEditOrder({
                  detail: {
                    note: "",
                    table_id: sln || "",
                    id: 0,
                  },
                });
                router.push("/");
              }
            }
          }}
        >
          {tables[salon][sln].length &&
            ![6, 20].includes(tables[salon][sln][0].status_raw) ? (
            <div className="text-right p-2">
              <input
                type="checkbox"
                checked={
                  tbl1 == tables[salon][sln][0].id ||
                    tbl2 == tables[salon][sln][0].id
                    ? true
                    : false
                }
                onClick={(e) => {
                  let check = e.currentTarget.checked;
                  let id = tables[salon][sln][0].id;
                  if (check) {
                    if (!tbl1) setTbl1(id);
                    else setTbl2(id);
                  } else {
                    if (tbl1 == id) setTbl1("");
                    if (tbl2 == id) setTbl2("");
                  }
                }}
              />
              {tbl1 == tables[salon][sln][0].id ? (
                <span>میز اول</span>
              ) : tbl2 == tables[salon][sln][0].id ? (
                <span>میز دوم</span>
              ) : null}
            </div>
          ) : null}
          <div className="py-3 px-6 border-b border-gray-300 relative flex items-center justify-center flex-col flex-wrap gap-2">
            <div className="flex items-center justify-center flex-wrap gap-2">
              <span className="text-base">
                {salon != "no_table" && salon != "settled" && salon != "suspended" ? sln : ""}
                {salon == "settled" ? tables[salon][sln][0].table_id : null}
                {salon == "no_table" && tables[salon][sln][0].online_table_id
                  ? tables[salon][sln][0].online_table_id
                  : ""}
              </span>

              {tables[salon][sln].length ? (
                <Fragment>
                  <>
                    <button
                      className="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-2 py-1 text-center inline-flex items-center dark:bg-gray-600 dark:hover:bg-gray-700 dark:focus:ring-blue-800"
                      type="button"
                      onClick={(e) => {
                        e.stopPropagation();
                        document
                          .querySelectorAll(".popup-options")
                          .forEach((el) => {
                            el.classList.add("hidden");
                          });
                        document
                          .getElementById(tables[salon][sln][0].table_id + i)
                          .classList.remove("hidden");
                        document
                          .getElementById(tables[salon][sln][0].table_id + i)
                          .classList.add("popup-options");
                      }}
                    >
                      <svg
                        className="w-4 h-4"
                        fill="none"
                        stroke="currentColor"
                        viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M19 9l-7 7-7-7"
                        ></path>
                      </svg>
                    </button>
                    <div
                      className="z-10 hidden bg-white divide-y divide-gray-100 rounded shadow w-44 dark:bg-gray-700"
                      style={{
                        position: "absolute",
                        inset: "auto auto 0px 50%",
                        margin: "0px",
                        transform: "translate(-50%, 125%) scale(1.5)",
                      }}
                      id={tables[salon][sln][0].table_id + i}
                    >
                      <ul className="text-gray-700 dark:text-gray-200">
                        {salon != "settled" &&
                          tables[salon][sln][0].status_raw != -1 ? (
                          <>
                            {tables[salon][sln][0].status_raw != 5 ? (
                              <li>
                                {(function () {
                                  saveLocalyDetailOrder(
                                    tables[salon][sln][0].id
                                  );
                                })()}
                                <a
                                  href="javascript:void(0)"
                                  className="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white cursor-pointer"
                                  onClick={() => {
                                    // if (!offline) {
                                    //   getDetailOrder(tables[salon][sln][0].id);
                                    // }
                                    // else {
                                    getOrder(
                                      tables[salon][sln][0].id,
                                      0,
                                      salon
                                    );
                                    // renderDetailsOrderInCart(JSON.parse(localStorage.getItem(`order-${tables[salon][sln][0].id}`) || '[]'));
                                    // }
                                  }}
                                >
                                  ویرایش
                                </a>
                              </li>
                            ) : null}
                            {tables[salon][sln][0].status_raw != 5 &&
                              localStorage.getItem("access") &&
                              JSON.parse(localStorage.getItem("access"))
                                .checkout ? (
                              <>
                                <li>
                                  <a
                                    href="javascript:void(0)"
                                    className="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white"
                                    onClick={() =>
                                      setStatus(tables[salon][sln][0].id, 5)
                                    }
                                  >
                                    تسویه
                                  </a>
                                </li>
                              </>
                            ) : null}
                            {tables[salon][sln][0].status_raw != 5 &&
                              localStorage.getItem("access") &&
                              JSON.parse(localStorage.getItem("access"))
                                .checkout ? (
                              <>
                                <li>
                                  <a
                                    href="javascript:void(0)"
                                    className="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white"
                                    onClick={() =>
                                      setStatus(
                                        tables[salon][sln][0].id,
                                        6,
                                        tables[salon][sln][0].flag == 1 ? 1 : 0
                                      )
                                    }
                                  >
                                    تسویه و ترک میز
                                  </a>
                                </li>
                                <li>
                                  <button
                                    className="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white cursor-pointer poz_cart w-full"
                                    data-price={
                                      tables[salon][sln][0].final_price / 100
                                    }
                                    data-id={tables[salon][sln][0].offline_id}
                                  >
                                    پرداخت با دستگاه پوز
                                  </button>
                                </li>
                              </>
                            ) : null}
                            {tables[salon][sln][0].status_raw == 5 ? (
                              <li>
                                <a
                                  href="javascript:void(0)"
                                  className="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white"
                                  onClick={() =>
                                    setStatus(
                                      tables[salon][sln][0].id,
                                      6,
                                      tables[salon][sln][0].flag == 1 ? 1 : 0
                                    )
                                  }
                                >
                                  ترک میز
                                </a>
                              </li>
                            ) : null}
                          
                          </>
                        ) : null}
                          {localStorage.getItem("client_type") == "1" ? (
                              <li>
                                <a
                                  href="javascript:void(0)"
                                  className="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white cursor-pointer"
                                  onClick={() => {
                                    getOrder(
                                      tables[salon][sln][0].id,
                                      1,
                                      salon,
                                      null,
                                      1
                                    );
                                    // renderDetailsOrderInCart(JSON.parse(localStorage.getItem(`order-${tables[salon][sln][0].id}`) || '[]'), 1);
                                  }}
                                >
                                  چاپ مجدد
                                </a>
                              </li>
                            ) : null}
                        {tables[salon][sln][0].status_raw != -1 ? (
                          <>
                            <li>
                              <a
                                href="javascript:void(0)"
                                className="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white cursor-pointer"
                                onClick={() => {
                                  getOrder(
                                    tables[salon][sln][0].id,
                                    1,
                                    salon,
                                    "p1"
                                  );
                                }}
                              >
                                صورت حساب از صندوق
                              </a>
                            </li>
                            <li>
                              <a
                                href="javascript:void(0)"
                                className="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white cursor-pointer"
                                onClick={() =>
                                  getOrder(
                                    tables[salon][sln][0].id,
                                    1,
                                    salon,
                                    "p0"
                                  )
                                }
                              >
                                صورت حساب با تبلت
                              </a>
                            </li>
                          </>
                        ) : (
                          <>
                            <li>
                              <a
                                href="javascript:void(0)"
                                className="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white cursor-pointer"
                                onClick={() => {
                                  if (tables[salon][sln][0].online_table_id) {
                                    sendToMerge(
                                      tables[salon][sln][0].id,
                                      tables[salon][sln][0].online_table_id
                                    );
                                  } else {
                                    getOrder(
                                      tables[salon][sln][0].id,
                                      1,
                                      null,
                                      null,
                                      null,
                                      "پرینت باریستا"
                                    );
                                    setStatus(
                                      tables[salon][sln][0].id,
                                      1,
                                      tables[salon][sln][0].flag == 1 ? 1 : 0
                                    );
                                  }
                                }}
                              >
                                تایید سفارش
                              </a>
                            </li>
                            {/* <li>
                              <a
                                href="javascript:void(0)"
                                className="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white cursor-pointer"
                                onClick={() =>
                                  handleRemoveOrder(tables[salon][sln][0].id)
                                }
                              >
                                رد سفارش
                              </a>
                            </li> */}
                          </>
                        )}
                      </ul>
                    </div>
                  </>

                  {"#" + tables[salon][sln][0].local_id}

                  {tables[salon][sln][0].status_raw != 5 &&
                    salon != "settled" ? (
                    <button
                      onClick={() => {
                        getOrder(tables[salon][sln][0].id, 0, salon);
                        // renderDetailsOrderInCart(JSON.parse(localStorage.getItem(`order-${tables[salon][sln][0].id}`) || '[]'));
                      }}
                      className="text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm px-2 py-1 text-center inline-flex items-center dark:bg-gray-600 dark:hover:bg-gray-700 dark:focus:ring-blue-800"
                    >
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        version="1.1"
                        width="16"
                        height="16"
                        x="0"
                        y="0"
                        viewBox="0 0 484.00019 484"
                      >
                        <g>
                          <path
                            xmlns="http://www.w3.org/2000/svg"
                            d="m401.648438 18.234375c-24.394532-24.351563-63.898438-24.351563-88.292969 0l-22.101563 22.222656-235.269531 235.144531-.5.503907c-.121094.121093-.121094.25-.25.25-.25.375-.625.746093-.871094 1.121093 0 .125-.128906.125-.128906.25-.25.375-.371094.625-.625 1-.121094.125-.121094.246094-.246094.375-.125.375-.25.625-.378906 1 0 .121094-.121094.121094-.121094.25l-52.199219 156.96875c-1.53125 4.46875-.367187 9.417969 2.996094 12.734376 2.363282 2.332031 5.550782 3.636718 8.867188 3.625 1.355468-.023438 2.699218-.234376 3.996094-.625l156.847656-52.324219c.121094 0 .121094 0 .25-.121094.394531-.117187.773437-.285156 1.121094-.503906.097656-.011719.183593-.054688.253906-.121094.371094-.25.871094-.503906 1.246094-.753906.371093-.246094.75-.621094 1.125-.871094.125-.128906.246093-.128906.246093-.25.128907-.125.378907-.246094.503907-.5l257.371093-257.371094c24.351563-24.394531 24.351563-63.898437 0-88.289062zm-232.273438 353.148437-86.914062-86.910156 217.535156-217.535156 86.914062 86.910156zm-99.15625-63.808593 75.929688 75.925781-114.015626 37.960938zm347.664062-184.820313-13.238281 13.363282-86.917969-86.917969 13.367188-13.359375c14.621094-14.609375 38.320312-14.609375 52.945312 0l33.964844 33.964844c14.511719 14.6875 14.457032 38.332031-.121094 52.949218zm0 0"
                            fill="#ffffff"
                            data-original="#ffffff"
                          ></path>
                        </g>
                      </svg>
                    </button>
                  ) : null}
                  <div className="">
                    {tables[salon][sln].length &&
                      tables[salon][sln][0].offline_id ? (
                      <>
                        <img
                          src="/images/disconnected.png"
                          alt="connection status"
                          style={{ width: `${30}px`, height: `${30}px` }}
                          className="m-auto"
                          data-tip={tables[salon][sln][0].offline_id}
                        />
                        <ReactTooltip />
                      </>
                    ) : null}
                  </div>
                  <div className="">
                    <img
                      src="/images/eye.png"
                      alt="connection status"
                      style={{
                        width: `${30}px`,
                        height: `${30}px`,
                        cursor: "pointer",
                      }}
                      className="m-auto"
                      data-tip="نمایش جزئیات"
                      onClick={() =>
                        showDetails(tables[salon][sln][0].offline_id)
                      }
                    />
                    <ReactTooltip />
                  </div>
                </Fragment>
              ) : null}
            </div>
          </div>
          <div className="px-6 py-3">
            <h5 className="text-gray-900 font-medium">
              {tables[salon][sln].length
                ? (tables[salon][sln][0].final_price / 100)
                  .toLocaleString("en-ir", {
                    style: "currency",
                    currency: "irr",
                  })
                  .split("IRR ")[1]
                : "0"}
            </h5>
          </div>
          <div className="py-3 px-6 border-t border-gray-300 text-gray-600">
            {tables[salon][sln].length
              ? getTM(tables[salon][sln][0].date_orginal)
              : "-"}
          </div>
        </div>
      ))}
      {salon == "settled" ? (
        <Pagination
          pages={pages}
          page={page}
          setPage={setPage}
          getData={updateTables}
        />
      ) : null}
      <OrderDetails
        showModal={showModal}
        setShowModal={setShowModal}
        details={details}
        setDetails={setDetails}
        order={order}
        setOrders={setOrders}
      />
    </Fragment>
  );
};

export default Table;
