import React, { useEffect, useState, useRef } from "react";
import {
  addItemToCart,
  removeItemFromCart,
  removeItemsFromCart,
  updateOrderNote,
} from "helpers/check-items";
import { useProductContext } from "./Products";
import clsx from "clsx";
import {
  cartTotalPrice,
  cartTotalPrice2,
  cartTotalTax,
  formatPrice,
  maskm,
  roundFinalPrice,
} from "helpers/format";
import CustomerSuggest from "./CustomerSuggest";
import ICustomer from "interfaces/customer";
import { findOrder, submitOrder } from "services/order";
import { useRouter } from "next/router";
import ImageComponent from "./shared/image-component";
import { submitOrderLocally, uploadOfflineOrders } from "helpers/offline";
import { getTableList } from "./../services/order";
import e, { json } from "express";
import { addToOrder } from "./shared/addToOrder";
import { changeStatus, changeTable } from "services/table";
import { toast } from "react-toastify";
import { numberFormat } from "services/persian";

const Sidebar = ({
  showSidebar,
  setShowSidebar,
  activeClasses,
  drawerWidth,
  setDrawerWidth,
}) => {
  const {
    order,
    setOrder,
    offline,
    setOfflineBills,
    token,
    detailEditOrder,
    setDetailEditOrder,
    tableId,
    setTableId,
    repeatPrinting,
    setRepeatPrinting,
    loader,
    setLoader,
    warehouse,
    tax,
  } = useProductContext();
  const [customer, setCustomer] = useState<ICustomer>({ name: "", id: -1 });
  const product = {
    name: "esm",
    price: 30000,
    image: "url",
    options: [
      {
        name: "option 1",
        price: 2000,
        additional_property: "folan",
      },
      {
        name: "option 2",
        price: 7500,
        additional_property: "bisar",
      },
    ],
  };

  const inputTableList = useRef(null);

  const [isError, setIsError] = useState(false);
  const [tableList, setTableList] = useState<object>({ "مجدد لاگین کنید": 0 });
  const [note, setNote] = useState("");
  const [orderId, setOrderId] = useState(0);
  const [customerNote, setCustomerNote] = useState("");
  const [orderTypeDefault, setOrderTypeDefault] = useState(null);
  const [printerBehaveDefault, setPrinterBehaveDefault] = useState(null);
  const [paymentTypeDefault, setPaymentTypeDefault] = useState(null);
  const [usePoint, setUsePoint] = useState(false);
  const [userPoint, setUserPoint] = useState(0);
  const [userDiscount, setUserDiscount] = useState(0);
  const [numPeople, setNumPeople] = useState("");
  const [useDiscount, setUseDiscount] = useState({
    text: "انتخاب تخفیف",
    id: 0,
  });
  const [discount, setDiscount] = useState("");
  const [totalPrice, setTotalPrice] = useState("");
  const [totalPrice2, setTotalPrice2] = useState(0);
  const [service, setService] = useState("");
  const [tip, setTip] = useState("");
  const [payment_card, setPayment_card] = useState("");
  const [payment_pos, setPayment_pos] = useState("");
  const [payment_cash, setPayment_cash] = useState("");
  const router = useRouter();

  useEffect(() => {
    getTables();
    const localOrders = JSON.parse(localStorage.getItem("localOrders") || "[]");
    const myToken = localStorage.getItem("token");
    localOrders.forEach((item, i) => {
      if (item["date"]) {
        setTimeout(
          () => {
            uploadOfflineOrders(myToken, 1);
          },
          Date.now() - item["date"] > 5400000
            ? 90000 * (i + 1)
            : 5400000 - (Date.now() - item["date"]) + 90000 * (i + 1)
        );
      }
    });

    let queryList: any = localStorage.getItem("queryList");
    if (queryList) {
      queryList = JSON.parse(queryList);
      queryList.forEach((item, i) => {
        setTimeout(
          () => {
            queryList = localStorage.getItem("queryList");
            queryList = JSON.parse(queryList || "[]");
            if (item.type == "setStatus") {
              changeStatus(item.order_id, item.st_id);
              queryList = queryList.filter(
                (it) => it.order_id != item.order_id && it.st_id != item.st_id
              );
            } else if (item.type == "changeTable") {
              changeTable(item.order_id, item.table_id);
              queryList = queryList.filter(
                (it) =>
                  it.order_id != item.order_id && it.table_id != item.table_id
              );
            }
            localStorage.setItem("queryList", JSON.stringify(queryList));
          },
          Date.now() - item["date"] > 5400000
            ? 90000 * (i + 1)
            : 5400000 - (Date.now() - item["date"]) + 90000 * (i + 1)
        );
      });
    }
  }, []);
  let [ListDiscounts, setListDiscounts] = useState([
    {
      text: "انتخاب تخفیف",
      id: 0,
    },
  ]);
  useEffect(() => {
    if (Object.keys(detailEditOrder).length) {
      setNote(detailEditOrder["detail"].note);
      setOrderId(detailEditOrder["detail"].id);
      setTableId(detailEditOrder["detail"].table_id);
      setUsePoint(detailEditOrder["detail"].use_point);
      setUserPoint(detailEditOrder["detail"].user_point);
      setService(detailEditOrder["detail"].service);
      setPayment_cash(detailEditOrder["detail"].payment_cash);
      setPayment_card(detailEditOrder["detail"].payment_card);
      setPayment_pos(detailEditOrder["detail"].payment_pos);
      setTip(detailEditOrder["detail"].tip);
      if (detailEditOrder["detail"].numPeople)
        setNumPeople(detailEditOrder["detail"].numPeople);
      if (
        detailEditOrder["detail"].user_id != -1 &&
        detailEditOrder["detail"].user_name
      ) {
        setCustomer({
          name: detailEditOrder["detail"].user_name,
          id: detailEditOrder["detail"].user_id,
        });
      }
      if (detailEditOrder["detail"].discount_id > 0) {
        let discount_id = detailEditOrder["detail"].discount_id;
        let d = JSON.parse(localStorage.getItem("discount_list_app"))[
          discount_id
        ].name;
        setUseDiscount({
          text: d,
          id: discount_id,
        });
      } else {
        setUseDiscount({
          text: "انتخاب تخفیف",
          id: 0,
        });
      }
    }
  }, [detailEditOrder]);

  useEffect(() => {
    calculate_discount();
  }, [useDiscount]);
  useEffect(() => {
    if (service) {
      let totalAmount = cartTotalPrice2(order);
      totalAmount = totalAmount + parseInt(service);
      if (discount) totalAmount -= parseInt(discount);
      if (tip) totalAmount += parseInt(tip);
      setTotalPrice(formatPrice(totalAmount));
      setTotalPrice2(totalAmount);
    }
    calculate_discount();
  }, [service]);
  useEffect(() => {
    if (tip) {
      let totalAmount = cartTotalPrice2(order);
      totalAmount = totalAmount + parseInt(tip);
      if (discount) totalAmount -= parseInt(discount);
      if (service) totalAmount += parseInt(service);
      setTotalPrice(formatPrice(totalAmount));
      setTotalPrice2(totalAmount);
    }
    calculate_discount();
  }, [tip]);
  useEffect(() => {
    calculate_discount();
  }, [useDiscount]);
  const calculate_discount = () => {
    let disc = 0;
    if (useDiscount["id"] > 0) {
      setUserDiscount(0);
      let totalAmount = cartTotalPrice2(order);
      if (service) totalAmount += parseInt(service);

      let d = JSON.parse(localStorage.getItem("discount_list_app"))[
        useDiscount["id"]
      ].discount;
      d = Math.round(totalAmount * (d / 100));
      totalAmount = totalAmount - d;
      if (tip) totalAmount += parseInt(tip);
      setTotalPrice(formatPrice(totalAmount));
      setTotalPrice2(totalAmount);
      setDiscount(formatPrice(d));
      disc = d;
    } else if (userDiscount > 0) {
      let totalAmount = cartTotalPrice2(order);
      let d = userDiscount;
      d = Math.round(totalAmount * (d / 100));
      totalAmount = totalAmount - d;
      setTotalPrice(formatPrice(totalAmount));
      setTotalPrice2(totalAmount);
      setDiscount(formatPrice(d));
      disc = d;
    } else {
      // setTotalPrice("");
      setDiscount("");
    }
    if (
      !service &&
      !discount &&
      !tip &&
      !disc &&
      !(userDiscount > 0 && useDiscount["id"] > 0)
    ) {
      // console.log("test");
      setTotalPrice("");
      setTotalPrice2(0);
    }
  };
  useEffect(() => {
    calculate_discount();
  }, [userDiscount]);
  useEffect(() => {
    if (orderTypeDefault === null) {
      setOrderTypeDefault(
        localStorage.getItem("order_type_default")
          ? localStorage.getItem("order_type_default")
          : "EXP"
      );
    }

    if (printerBehaveDefault === null) {
      setPrinterBehaveDefault(
        localStorage.getItem("default_print_type")
          ? localStorage.getItem("default_print_type")
          : "1"
      );
      localStorage.setItem(
        "printer_behave_default",
        printerBehaves[+localStorage.getItem("default_print_type") - 1]
      );
    }
    if (paymentTypeDefault === null) {
      setPaymentTypeDefault(
        localStorage.getItem("paymentType")
          ? localStorage.getItem("paymentType")
          : "پوز"
      );
    }

    if (
      tableList["مجدد لاگین کنید"] == 0 &&
      localStorage.getItem("table_list")
    ) {
      setTableList(
        JSON.parse(localStorage.getItem("table_list") || "[]") || {
          "مجدد لاگین کنید": 0,
        }
      );
    }

    if (localStorage.getItem("discount_list") && ListDiscounts.length == 1) {
      const dl = JSON.parse(localStorage.getItem("discount_list"));
      if (dl.length) setListDiscounts([...ListDiscounts, ...dl]);
    }
  });

  // console.log(printerBehaveDefault);

  enum errorMessages {
    Customer = "لطفا ابتدا مشتری را ثبت نمایید",
    // TableId = 'لطفا ابتدا شماره میز را ثبت نمایید',
    NoServer = "ارتباط با سرور داخلی برقرار نیست",
  }

  const [errorMessage, setErrorMessage] = useState(errorMessages.Customer);
  const [noCustomer, setNoCustomer] = useState(true);

  const handleSubmitOrder = (e: any) => {
    if (tableId) {
      findOrder(
        {
          status: 6,
          table_id: tableId,
        },
        1
      ).then((order) => {
        if (order["order"]) {
          if (orderId && order["order"].offline_id == orderId)
            submitOrder(false);
          else submitOrder(true);
        } else submitOrder(false);
      });
    } else {
      submitOrder(false);
    }
  };
  const submitOrder = (check) => {
    if (check) {
      toast.error("میز وارد شده پر میباشد", {
        position: "bottom-right",
        style: { direction: "rtl", fontFamily: "IRANSansX" },
        theme: "colored",
      });
      return;
    }
    let button = document.getElementById("submitOrder") as HTMLButtonElement;
    button.disabled = true;

    if (payment_card || payment_pos || payment_cash) {
      let sum =
        (payment_card ? parseInt(payment_card.replace(/,/g, "")) : 0) +
        (payment_pos ? parseInt(payment_pos.replace(/,/g, "")) : 0) +
        (payment_cash ? parseInt(payment_cash.replace(/,/g, "")) : 0);
      let totalAmount = cartTotalPrice2(order);
      if (service) totalAmount += parseInt(service);
      if (discount) totalAmount -= parseInt(discount);
      if (tip) totalAmount += parseInt(tip);
      totalAmount *= 1000;
      if (tax)
        totalAmount += cartTotalTax(
          totalPrice2 ? totalPrice2 : cartTotalPrice2(order),
          tax,
          tip,order
        );
      totalAmount = roundFinalPrice(totalAmount / 1000) * 1000;
      if (sum != totalAmount) {
        toast.error("مبلغ های پرداختی وارد شده با مبلغ کل برابر نمیباشند", {
          position: "bottom-right",
          style: { direction: "rtl", fontFamily: "IRANSansX" },
          theme: "colored",
        });
        button.disabled = false;
        return;
      }
    }
    setIsError(false);
    setErrorMessage(errorMessages.NoServer);
    // if offline only save the order
    button.classList.add("loading");
    // if (offline) {
    const totalAmount = cartTotalPrice2(order);
    if (totalAmount <= 0) {
      button.disabled = false;
      button.classList.remove("loading");
      return toast.error("مبلغ کل سفارش نمیتواند صفر باشد.", {
        position: "bottom-right",
        style: { direction: "rtl", fontFamily: "IRANSansX" },
        theme: "colored",
      });
    }

    submitOrderLocally(
      order,
      customer,
      totalAmount,
      paymentTypeDefault,
      customerNote,
      noCustomer,
      orderId,
      numPeople,
      tableId,
      detailEditOrder,
      setDetailEditOrder,
      useDiscount,
      note,
      userPoint,
      usePoint,
      service,
      payment_card.replace(/,/g, ""),
      payment_pos.replace(/,/g, ""),
      payment_cash.replace(/,/g, ""),
      null,
      null,
      null,
      null,
      tip,
      userDiscount,
      warehouse
    ).then((res: number) => {
      setLoader(true);
      setOfflineBills(res);
      setCustomer({ name: "", id: -1 });
      setOrder([]);
      setTableId("");
      setNote("");
      setUseDiscount({ text: "انتخاب تخفیف", id: 0 });
      setOrderTypeDefault(
        localStorage.getItem("order_type_default")
          ? localStorage.getItem("order_type_default")
          : "1"
      );
      setPaymentTypeDefault(
        localStorage.getItem("paymentType")
          ? localStorage.getItem("paymentType")
          : "پوز"
      );
      setPrinterBehaveDefault(localStorage.getItem("default_print_type"));
      localStorage.setItem(
        "printer_behave_default",
        printerBehaves[+localStorage.getItem("default_print_type") - 1]
      );
      setIsError(false);
      setCustomerNote("");
      setNoCustomer(true);
      setNote("");
      setOrderId(0);
      setDetailEditOrder({});
      setNumPeople("");
      setShowSidebar(false);
      setService("");
      setTip("");
      setPayment_card("");
      setPayment_pos("");
      setPayment_cash("");
      setUserDiscount(0);
      button.classList.remove("loading");

      setTimeout(() => {
        router.push("/tables");
        setLoader(false);
      }, 500);
      setUserPoint(0);
      setUsePoint(false);
    });
  };
  const getTables = () => {
    if (offline) {
      let tables = localStorage.getItem("tables") || "[]";
      tables = JSON.parse(tables);
      let listTables = [];
      Object.keys(tables).forEach((salon) => {
        Object.keys(tables[salon]).forEach((table) => {
          if (!tables[salon][table].length) {
            listTables.push(table);
          }
        });
      });
      // listTables = Object.assign({}, listTables);

      const listTablesOB = {};

      listTables.forEach((table) => {
        listTablesOB[table] = 0;
      });

      localStorage.setItem("table_list", JSON.stringify(listTablesOB));
      setTableList(listTablesOB);
      return;
    }
    getTableList()
      .then((table_list) => {
        localStorage.setItem("table_list", JSON.stringify(table_list) || "{}");
        setTableList(
          JSON.parse(
            localStorage.getItem("table_list") || "{'مجدد لاگین کنید': 0}"
          )
        );
      })
      .catch(() => {
        setIsError(true);
      });
  };

  useEffect(() => {
    if (
      router.pathname !== "/cart" &&
      order.length >= 1 &&
      window.innerWidth > 1130
    ) {
      setShowSidebar(true);
      document.querySelector(".toggle-wrap").classList.add("active");
      document.querySelector("aside").classList.add("active");
    }
  }, [order, router]);

  useEffect(() => {
    // console.log(order);
    if (order.length == 0) {
      setNote("");
      setOrderId(0);
      // if(!detailEditOrder['items']) {
      //   setDetailEditOrder({});
      //   setTableId("");
      // }
    }
    calculate_discount();
  }, [order]);

  const productHasOptions = (product) => {
    return product.options.length > 0;
  };
  const printerBehaves = [
    "پرینت مشتری و باریستا",
    "پرینت باریستا",
    "بدون پرینت",
    "پرینت مشتری",
  ];
  const keyPrinterBehaves = {
    "پرینت مشتری": 4,
    "بدون پرینت": 3,
    "پرینت باریستا": 2,
    "پرینت مشتری و باریستا": 1,
  };
  const keysPrinter = {
    3: "بدون پرینت",
    2: "پرینت باریستا",
    1: "پرینت مشتری و باریستا",
  };
  const paymentTypes = ["نقدی", "پوز", "کارت به کارت"];
  const orderTypes = ["EXP", "Delivery", "Salon"];
  const keyOrderTypes = {
    EXP: 1,
    Delivery: 2,
    Salon: 3,
  };

  return (
    <aside
      className={`${activeClasses} box-border fixed top-0 left-0 bottom-0 z-50 h-full shadow-md bg-yellow-50 opacity-98 rounded-r-2xl ${
        showSidebar ? "active" : ""
      }`}
      style={{ width: `${drawerWidth}`, maxWidth: "calc(100% - 65px)" }}
    >
      <div
        className={
          clsx("toggle-wrap", "-right-24 top-6") +
          ` hidden md:block ${showSidebar ? "active" : ""}`
        }
        onClick={(e) => {
          setShowSidebar(!showSidebar);
        }}
      >
        <span className="toggle-bar" />
      </div>

      {/* if basket is empty */}
      {order.length === 0 && (
        <div
          className={`flex flex-col items-center justify-center text-2xl text-gray-800 rounded-3xl overflow-hidden ${
            drawerWidth === "0" ? "pr-8" : ""
          }`}
        >
          <ImageComponent
            src="/images/empty.png"
            alt="empty basket"
            layout="fixed"
            width={100}
            height={100}
          />
          <p>آماده سفارش بعدی</p>
        </div>
      )}
      {/* if basket involves items */}
      {order.length > 0 && (
        <div className={`static h-full  ${isError ? "pt-10 md:pt-0" : ""}`}>
          <div
            className={`absolute top-0 w-full px-4 ${
              drawerWidth === "0" ? "pr-20" : ""
            }`}
          >
            <div className="flex items-center justify-center p-4 bg-yellow-100 rounded-xl">
              <CustomerSuggest
                customer={customer}
                setCustomer={setCustomer}
                setIsError={setIsError}
                setUserPoint={setUserPoint}
                setUserDiscount={setUserDiscount}
              />
            </div>
          </div>
          {isError && (
            <div className="mx-4 mb-2 alert alert-error mt-20 overflow-y-hidden">
              <div className="flex items-center">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  fill="none"
                  viewBox="0 0 24 24"
                  className="w-6 h-6 mx-2 stroke-current"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"
                  />
                </svg>
                <label>{errorMessage}</label>
                {errorMessage == errorMessages.Customer ? (
                  <button
                    className="btn btn-error"
                    onClick={() => {
                      setNoCustomer(true);
                      setIsError(false);
                    }}
                  >
                    بدون مشتری
                  </button>
                ) : null}
              </div>
            </div>
          )}
          {/* Order list */}
          <div
            className={`md:h-120 lg:h-2/3 overflow-y-auto sidebar_response ${
              isError ? "" : "mt-28 md:mt-14 pb-14"
            }`}
            style={{ maxHeight: "calc(100% - 360px)" }}
          >
            {order.map((orderItem) => {
              return (
                <div
                  tabIndex={0}
                  // key={orderItem.product.id}
                  key={orderItem.product.unique}
                  id={String(orderItem.product.id)}
                  className={`flex flex-col collapse ${
                    orderItem.note ? "collapse-open" : "collapse-close"
                  }`}
                >
                  <div className="flex justify-around py-0 pl-2 pr-4 text-sm border-b-2 collapse-title">
                    <div
                      className={`flex items-center w-1/6 ${
                        localStorage.getItem("access") &&
                        !JSON.parse(localStorage.getItem("access")).down_edit
                          ? orderId != 0 &&
                            detailEditOrder["items"][
                              orderItem.product.id +
                                "_" +
                                (orderItem.product.options.length
                                  ? orderItem.product.options
                                      .map((i) => i.id)
                                      .join(",")
                                  : "")
                            ] != undefined
                            ? "opacity-50"
                            : "cursor-pointer"
                          : ""
                      }`}
                      onClick={() => {
                        if (
                          localStorage.getItem("access") &&
                          !JSON.parse(localStorage.getItem("access")).down_edit
                        ) {
                          if (
                            orderId != 0 &&
                            detailEditOrder["items"][
                              orderItem.product.id +
                                "_" +
                                (orderItem.product.options.length
                                  ? orderItem.product.options
                                      .map((i) => i.id)
                                      .join(",")
                                  : "")
                            ] != undefined
                          )
                            return;
                        }
                        setOrder([
                          ...removeItemsFromCart(
                            orderItem.product.unique,
                            order
                          ),
                        ]);
                      }}
                    >
                      <ImageComponent
                        src="/images/cancel.png"
                        width={20}
                        height={20}
                        alt="remove"
                      />
                    </div>
                    <div
                      className="w-full align-middle cursor-pointer"
                      onClick={() => {
                        const el = document.getElementById(
                          String(orderItem.product.id)
                        );
                        if (el.classList.contains("collapse-close")) {
                          el.classList.remove("collapse-close");
                          el.classList.add("collapse-open");
                        } else {
                          el.classList.remove("collapse-open");
                          el.classList.add("collapse-close");
                        }
                      }}
                    >
                      {/*{orderItem.product.name}*/}
                      <div className="py-4">{orderItem.product.baseName}</div>

                      <div>
                        {orderItem.product.options.map((productOption) => {
                          return (
                            <span
                              key={orderItem.product.unique + productOption.id}
                              className={
                                "bg-gray-200 text-xs p-2 text-gray-800 rounded-lg mx-1 mt-2"
                              }
                              style={{ wordBreak: "break-all" }}
                            >
                              {productOption.name}
                            </span>
                          );
                        })}
                      </div>
                    </div>
                    <div className="flex items-center justify-center w-2/6">
                      <span
                        className={`${
                          localStorage.getItem("access") &&
                          !JSON.parse(localStorage.getItem("access")).down_edit
                            ? orderId != 0 &&
                              !(
                                orderItem.count >
                                (detailEditOrder["items"][
                                  orderItem.product.id +
                                    "_" +
                                    (orderItem.product.options.length
                                      ? orderItem.product.options
                                          .map((i) => i.id)
                                          .join(",")
                                      : "")
                                ] == undefined
                                  ? 0
                                  : detailEditOrder["items"][
                                      orderItem.product.id +
                                        "_" +
                                        (orderItem.product.options.length
                                          ? orderItem.product.options
                                              .map((i) => i.id)
                                              .join(",")
                                          : "")
                                    ]["qty"])
                              )
                              ? "opacity-50"
                              : "cursor-pointer"
                            : ""
                        }`}
                        onClick={() => {
                          if (
                            localStorage.getItem("access") &&
                            !JSON.parse(localStorage.getItem("access"))
                              .down_edit
                          ) {
                            if (
                              orderId != 0 &&
                              !(
                                orderItem.count >
                                (detailEditOrder["items"][
                                  orderItem.product.id +
                                    "_" +
                                    (orderItem.product.options.length
                                      ? orderItem.product.options
                                          .map((i) => i.id)
                                          .join(",")
                                      : "")
                                ] == undefined
                                  ? 0
                                  : detailEditOrder["items"][
                                      orderItem.product.id +
                                        "_" +
                                        (orderItem.product.options.length
                                          ? orderItem.product.options
                                              .map((i) => i.id)
                                              .join(",")
                                          : "")
                                    ]["qty"])
                              )
                            )
                              return;
                          }
                          setOrder([
                            ...removeItemFromCart(
                              orderItem.product.unique,
                              order
                            ),
                          ]);
                        }}
                      >
                        <ImageComponent
                          src="/images/minus.png"
                          width={20}
                          height={20}
                          alt="minus"
                        />
                      </span>
                      <span className="px-2 pb-1 text-green-00">
                        {orderItem.count}
                      </span>
                      <span
                        className="cursor-pointer"
                        onClick={() => {
                          setOrder([
                            ...addItemToCart(orderItem.product.unique, order),
                          ]);
                        }}
                      >
                        <ImageComponent
                          src="/images/plus.png"
                          width={20}
                          height={20}
                          alt="minus"
                        />
                      </span>
                    </div>
                    <div className="flex items-center justify-center w-1/6">
                      {orderItem.product.price}
                    </div>
                    <div className="flex items-center justify-center w-1/6">
                      {orderItem.count * orderItem.product.price}
                    </div>
                  </div>
                  <div className="collapse-content">
                    <textarea
                      placeholder="توضیحات"
                      value={orderItem.note}
                      onChange={(e) => {
                        setOrder([
                          ...updateOrderNote(
                            orderItem.product.unique,
                            order,
                            e.currentTarget.value
                          ),
                        ]);
                      }}
                      className="w-full h-24 textarea"
                    />
                  </div>
                </div>
              );
            })}
          </div>
          <div
            style={{ left: "-16px" }}
            className="absolute bottom-0 w-full mx-4"
          >
            <div className="flex flex-col p-4 mt-4 bg-red-100 rounded-2xl">
              <div className="flex items-center justify-between gap-2">
                <div className="w-full">
                  <button
                    className={`btn text-sm btn-sm w-full border-0 ${
                      usePoint ? "btn-success" : ""
                    }`}
                    onClick={() => setUsePoint(!usePoint)}
                  >
                    استفاده از امتیاز
                  </button>
                </div>
                {localStorage.getItem("access") &&
                JSON.parse(localStorage.getItem("access")).discount ? (
                  <div className="w-full">
                    <div className="w-full my-2 dropdown dropdown-top dropdown-end">
                      <div tabIndex={0} className="w-full btn text-sm btn-sm">
                        {useDiscount.text}
                      </div>
                      <ul
                        tabIndex={0}
                        className="w-full p-2 shadow menu dropdown-content bg-base-100 rounded-box overflow-y-auto"
                        style={{
                          maxHeight: "60vh",
                        }}
                      >
                        {ListDiscounts &&
                          ListDiscounts.map(({ text, id }) => (
                            <li key={text}>
                              <a
                                onClick={() => {
                                  setUseDiscount({ text, id });
                                  inputTableList.current.focus();
                                  inputTableList.current.blur();
                                }}
                              >
                                {text}
                              </a>
                            </li>
                          ))}
                      </ul>
                    </div>
                  </div>
                ) : null}
              </div>
              <div className="flex items-center justify-between gap-2">
                <div className="w-full">
                  <div className="w-full my-2 dropdown dropdown-top dropdown-end">
                    <div tabIndex={0} className="w-full btn text-sm btn-sm">
                      {/* {orderTypeDefault != null ? orderTypeDefault : 'انتخاب نوع پرینت'} */}
                      {orderTypes[parseInt(orderTypeDefault) - 1]}
                    </div>
                    <ul
                      tabIndex={0}
                      className="w-full p-2 shadow menu dropdown-content bg-base-100 rounded-box"
                    >
                      {orderTypes &&
                        orderTypes.map((orderType) => (
                          <li key={orderType}>
                            <a
                              onClick={() => {
                                setOrderTypeDefault(keyOrderTypes[orderType]);
                                inputTableList.current.focus();
                                inputTableList.current.blur();
                              }}
                            >
                              {orderType}
                            </a>
                          </li>
                        ))}
                    </ul>
                  </div>
                </div>
                <div className="w-full">
                  <div className="w-full my-2 dropdown dropdown-top dropdown-end">
                    <div tabIndex={0} className="w-full btn text-sm btn-sm">
                      {paymentTypeDefault != null ? paymentTypeDefault : "پوز"}
                    </div>
                    <ul
                      tabIndex={0}
                      className="w-full p-2 shadow menu dropdown-content bg-base-100 rounded-box"
                    >
                      {paymentTypes &&
                        paymentTypes.map((paymentType) => (
                          <li key={paymentType}>
                            <a
                              onClick={() => {
                                setPaymentTypeDefault(paymentType);
                                localStorage.setItem(
                                  "paymentType",
                                  paymentType
                                );
                                inputTableList.current.focus();
                                inputTableList.current.blur();
                              }}
                            >
                              {paymentType}
                            </a>
                          </li>
                        ))}
                    </ul>
                  </div>
                </div>
              </div>
              <div className="flex items-center justify-between mb-2 gap-2">
                <div className="w-full">
                  {tax === "1" ? (
                    <>
                      <div className="flex text-sm">
                        <p>جمع ایتم ها: </p>
                        <p className="mr-2">{cartTotalPrice(order)}</p>
                      </div>
                      <div className="flex text-sm">
                        <p>VAT: </p>
                        <p className="mr-2">
                          {numberFormat(
                            cartTotalTax(
                              totalPrice2
                                ? totalPrice2
                                : cartTotalPrice2(order),
                              tax,
                              tip,order
                            )
                          )}{" "}
                          تومان
                        </p>
                      </div>
                    </>
                  ) : (
                    ""
                  )}

                  {!totalPrice2 ? (
                    <div className="flex text-sm">
                      <p>جمع قیمت: </p>
                      <p className="mr-2">
                        {cartTotalPrice(order, totalPrice ? "0" : tax)}
                      </p>
                    </div>
                  ) : (
                    ""
                  )}
                  {discount ? (
                    <>
                      <div className="flex text-sm">
                        <p>تخفیف: </p>
                        <p className="mr-2">{discount}</p>
                      </div>
                    </>
                  ) : null}
                  {service ? (
                    <>
                      <div className="flex text-sm">
                        <p>سرویس: </p>
                        <p className="mr-2">{formatPrice(parseInt(service))}</p>
                      </div>
                    </>
                  ) : null}
                  {tip ? (
                    <>
                      <div className="flex text-sm">
                        <p>tip: </p>
                        <p className="mr-2">{formatPrice(parseInt(tip))}</p>
                      </div>
                    </>
                  ) : null}
                  {totalPrice ? (
                    <>
                      <div className="flex text-sm">
                        <p>مجموع: </p>
                        <p className="mr-2">
                          {formatPrice(
                            roundFinalPrice(
                              totalPrice2 +
                                cartTotalTax(totalPrice2, tax, tip,order) / 1000
                            )
                          )}
                        </p>
                      </div>
                    </>
                  ) : null}
                  {/* <div>{customer.name}</div> */}
                </div>
                <div className="w-full">
                  <button
                    className="btn btn-accent w-full btn-sm text-sm"
                    onClick={(e) => {
                      handleSubmitOrder(e);
                    }}
                    id="submitOrder"
                  >
                    ثبت
                  </button>
                </div>
              </div>
              <textarea
                className="textarea textarea-bordered p-3 py-0 h-8 min-h-0"
                value={customerNote}
                onChange={(e) => {
                  setCustomerNote(e.target.value);
                }}
                placeholder="یادداشت صندوق دار"
              />
              <div className="flex items-center justify-between gap-2">
                <div className="w-full">
                  <div className="w-full my-2 dropdown dropdown-top dropdown-end">
                    <div tabIndex={0} className="w-full btn btn-sm text-sm">
                      {printerBehaveDefault != null
                        ? printerBehaves[printerBehaveDefault - 1]
                        : "انتخاب نوع پرینت"}
                    </div>
                    {localStorage.getItem("client_type") == "2" ? null : (
                      <ul
                        tabIndex={0}
                        className="w-full p-2 shadow menu dropdown-content bg-base-100 rounded-box"
                      >
                        {printerBehaves &&
                          printerBehaves.map((printerBehave) => (
                            <li key={printerBehave}>
                              <a
                                onClick={() => {
                                  setPrinterBehaveDefault(
                                    keyPrinterBehaves[printerBehave]
                                  );
                                  localStorage.setItem(
                                    "printer_behave_default",
                                    printerBehave
                                  );
                                  inputTableList.current.focus();
                                  inputTableList.current.blur();
                                }}
                              >
                                {printerBehave}
                              </a>
                            </li>
                          ))}
                      </ul>
                    )}
                  </div>
                </div>
                <div className="w-full">
                  <div className="w-full my-2 dropdown dropdown-top dropdown-end">
                    <input
                      className="h-4 textarea textarea-bordered w-full  p-3 py-0 h-8 min-h-0"
                      value={tableId}
                      onChange={(e) => {
                        setTableId(e.target.value);
                      }}
                      ref={inputTableList}
                      placeholder="شماره میز"
                    />
                    <ul
                      tabIndex={0}
                      className="p-2 shadow menu dropdown-content bg-base-100 rounded-box flex items-start justify-start flex-row flex-wrap overflow-y-auto gap-2"
                      style={{
                        maxHeight: "80vh",
                        width: "calc(200% + .5rem)",
                      }}
                    >
                      {Object.keys(tableList).map((tl) =>
                        (tl.includes(tableId) || !tableId) && !tableList[tl] ? (
                          <li
                            key={tl}
                            style={{
                              borderRadius: "3px",
                              backgroundColor: "#eee",
                            }}
                          >
                            <a
                              className={tableId == tl ? "active" : ""}
                              style={{ borderRadius: "3px" }}
                              onClick={() => {
                                setTableId(tl);
                                inputTableList.current.focus();
                                inputTableList.current.blur();
                              }}
                            >
                              {tl}
                            </a>
                          </li>
                        ) : null
                      )}
                    </ul>
                  </div>
                </div>
              </div>
              {localStorage.getItem("access") &&
              JSON.parse(localStorage.getItem("access")).discount ? (
                <>
                  <div className="grid grid-cols-2 gap-2 hide_mobile">
                    <input
                      className="h-4 textarea textarea-bordered w-full  p-3 py-0 h-8 min-h-0"
                      style={{ direction: "ltr" }}
                      value={service}
                      onChange={(e) => {
                        setService(maskm(e.target.value));
                      }}
                      type="text"
                      placeholder="سرویس"
                    />
                    <input
                      className="h-4 textarea textarea-bordered w-full  p-3 py-0 h-8 min-h-0"
                      style={{ direction: "ltr" }}
                      value={payment_cash}
                      onChange={(e) => {
                        setPayment_cash(maskm(e.target.value));
                      }}
                      type="text"
                      placeholder="پرداخت نقدی"
                    />
                  </div>
                  <div className="grid grid-cols-2 gap-2 hide_mobile">
                    <input
                      className="h-4 textarea textarea-bordered w-full  p-3 py-0 h-8 min-h-0"
                      style={{ direction: "ltr" }}
                      value={payment_pos}
                      onChange={(e) => {
                        setPayment_pos(maskm(e.target.value));
                      }}
                      type="text"
                      placeholder="پز"
                    />
                    <input
                      className="h-4 textarea textarea-bordered w-full  p-3 py-0 h-8 min-h-0"
                      style={{ direction: "ltr" }}
                      value={payment_card}
                      onChange={(e) => {
                        setPayment_card(maskm(e.target.value));
                      }}
                      type="text"
                      placeholder="کارت به کارت"
                    />
                  </div>
                  <div className="grid grid-cols-2 gap-2 hide_mobile">
                    <input
                      className="h-4 textarea textarea-bordered w-full  p-3 py-0 h-8 min-h-0"
                      style={{ direction: "ltr" }}
                      value={tip}
                      onChange={(e) => {
                        let val = e.target.value;
                        setTip(val);
                      }}
                      type="text"
                      placeholder="tip"
                    />
                  </div>
                </>
              ) : null}

              <input
                type="number"
                className="textarea textarea-bordered w-full  p-3 py-0 h-8 min-h-0 mb-2"
                value={numPeople}
                onChange={(e) => {
                  setNumPeople(e.target.value);
                }}
                placeholder="تعداد نفرات"
              />
              <textarea
                className="textarea textarea-bordered p-3 py-0 h-8 min-h-0"
                value={note}
                onChange={(e) => {
                  setNote(e.target.value);
                }}
                placeholder="توضیحات"
              />
            </div>
          </div>
        </div>
      )}
      {!showSidebar && order.length ? (
        <button
          className={`px-4 py-2 text-sm btn btn-accent rounded-none lg:hidden absolute bottom-0 left-0 w-100 z-40 w-screen`}
          onClick={(e) => {
            handleSubmitOrder(e);
          }}
        >
          ثبت سفارش
        </button>
      ) : null}
    </aside>
  );
};

export default Sidebar;
