import { createContext, useContext } from "react";
import ICart from "./../interfaces/cart";
import IMenuItem from "interfaces/menuItem";

export type ProductsContent = {
  order: ICart[];
  setOrder: (
    cart: (
      | ICart
      | { product: { price: any; name: string; id: number }; count: number }
    )[]
  ) => void;
  menuItems: IMenuItem[];
  setMenuItems: (items: IMenuItem[]) => void;
  offline: boolean;
  setOffline: (value: boolean) => void;
  offlineBills: number;
  setOfflineBills: (value: number) => void;
  token: string;
  setToken: (token: string) => void;
  setCatItems: (items: IMenuItem[]) => void;
  catItems: IMenuItem[];
  detailEditOrder: object;
  setDetailEditOrder: (detail) => void;
  tableId: string;
  setTableId: (ti) => void;
  repeatPrinting: boolean;
  setRepeatPrinting: (value: boolean) => void;
  loader?: boolean;
  setLoader?: (value: boolean) => void;
  warehouse?: boolean;
  tax: string;
  setTax: (ti) => void;
  branchName: string;
  setBranchName: (e) => void;
  interval: () => void;
  refresh: string,
  setRefresh: (e) => void
};

export const ProductsStateContext = createContext<ProductsContent>({
  menuItems: [{ id: 0, name: "", img: "", isCat: true }],
  setMenuItems: () => { },
  order: [{ product: { name: "", id: 0 }, count: 1 }],
  setOrder: () => { },
  offline: false,
  setOffline: () => { },
  offlineBills: 0,
  setOfflineBills: () => { },
  token: null,
  setToken: () => { },
  setCatItems: () => { },
  catItems: [{ id: 0, name: "", img: "", isCat: true }],
  detailEditOrder: {},
  setDetailEditOrder: () => { },
  tableId: "",
  setTableId: () => { },
  repeatPrinting: false,
  setRepeatPrinting: () => { },
  loader: false,
  setLoader: () => { },
  warehouse: true,
  tax: "0",
  setTax: () => { },
  branchName: '',
  setBranchName: () => { },
  interval: () => { },
  refresh: '0',
  setRefresh: () => { }
});

export const useProductContext = () => useContext(ProductsStateContext);
